/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ReportComparisonView
extends ViewPart {
    private static final Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color RED = new Color((Device)Display.getDefault(), 150, 0, 0);
    private static final Color GREEN = new Color((Device)Display.getDefault(), 0, 50, 0);
    private static final Color LIGHT_GREEN = new Color((Device)Display.getDefault(), 0, 105, 0);
    private static final Color ORANGE = new Color((Device)Display.getDefault(), 150, 100, 0);
    private static final String DIFF_ENTRY = "\\s+(\\d+(\\.\\d+)?)\\%\\s+([\\+\\-]?\\d+(\\.\\d+)?)\\%.*";
    private static int SECONDARY_ID = 0;
    private StyledText result;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new GridLayout(1, true));
        this.result = new StyledText(parent, 768);
        this.result.setEditable(false);
        IPerfData data = PerfPlugin.getDefault().getReportDiffData();
        if (data != null) {
            this.setStyledText(data.getPerfData());
            this.setContentDescription(data.getTitle());
        }
    }

    private void setStyledText(String input) {
        String[] lines;
        this.result.setText(input);
        this.result.setJustify(true);
        this.result.setAlignment(16384);
        this.result.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int ptr = 0;
        String[] stringArray = lines = input.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (Pattern.matches(DIFF_ENTRY, line) && (m = Pattern.compile(DIFF_ENTRY).matcher(line)).matches() && m.group(1) != null && m.group(3) != null) {
                try {
                    float baseline = Float.parseFloat(m.group(1).trim());
                    float delta = Float.parseFloat(m.group(3).trim());
                    if (baseline > 1.0f && Math.abs(delta) > 1.0f) {
                        StyleRange curStyleRange = new StyleRange(ptr, line.length(), BLACK, null);
                        curStyleRange = delta < 0.0f ? (delta < -5.0f ? new StyleRange(ptr, line.length(), LIGHT_GREEN, null) : new StyleRange(ptr, line.length(), GREEN, null)) : (delta < 5.0f ? new StyleRange(ptr, line.length(), ORANGE, null) : new StyleRange(ptr, line.length(), RED, null));
                        styles.add(curStyleRange);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ptr += line.length() + 1;
            ++n2;
        }
        this.result.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    public void setFocus() {
    }

    public static void refreshView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    int n = SECONDARY_ID;
                    SECONDARY_ID = n + 1;
                    iWorkbenchPage.showView("org.eclipse.linuxtools.perf.ui.ReportViewDiff", Integer.toString(n), 3);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", e.getMessage(), (Throwable)e);
                    PerfPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }
}

