/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.StatComparisonData;
import org.eclipse.linuxtools.internal.perf.handlers.PerfStatDiffMenuAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class StatComparisonView
extends ViewPart {
    private static final Color RED = new Color((Device)Display.getDefault(), 150, 0, 0);
    private static final Color GREEN = new Color((Device)Display.getDefault(), 0, 100, 0);
    private static String OCCURRENCE = "\\s*(\\-?+\\d+[\\.\\,\\d]*).*";
    private StyledText text;
    private IPerfData diffData;
    private String timestamp;
    private static int SECONDARY_ID = 0;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new GridLayout(1, true));
        this.text = new StyledText(parent, 768);
        this.text.setEditable(false);
        this.timestamp = this.getTimestamp();
        IPerfData statsDiff = PerfPlugin.getDefault().getStatDiffData();
        if (statsDiff != null) {
            this.diffData = statsDiff;
            this.updateData(statsDiff, true);
        }
        this.fillToolbarActions();
    }

    public void setFocus() {
    }

    public IPerfData getDiffData() {
        return this.diffData;
    }

    private void setStyledText(String input) {
        String[] lines;
        this.setBasicStyledText(input);
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int ptr = 0;
        String[] stringArray = lines = input.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (Pattern.matches(OCCURRENCE, line) && (m = Pattern.compile(OCCURRENCE).matcher(line)).matches() && m.group(1) != null) {
                try {
                    float occurrence = StatComparisonData.toFloat(m.group(1).trim());
                    if (occurrence > 0.0f) {
                        styles.add(new StyleRange(ptr, line.length(), RED, null));
                    } else if (occurrence < 0.0f) {
                        styles.add(new StyleRange(ptr, line.length(), GREEN, null));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ptr += line.length() + 1;
            ++n2;
        }
        this.text.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    private void setBasicStyledText(String input) {
        this.text.setText(input);
        this.text.setAlignment(16384);
        this.text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
    }

    private void fillToolbarActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        PerfStatDiffMenuAction.Type[] typeArray = PerfStatDiffMenuAction.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PerfStatDiffMenuAction.Type type = typeArray[n2];
            bars.getToolBarManager().add((IAction)new PerfStatDiffMenuAction(type, this.getViewSite().getSecondaryId()));
            ++n2;
        }
    }

    public void updateData(IPerfData data, boolean style) {
        if (data != null) {
            if (style) {
                this.setStyledText(data.getPerfData());
            } else {
                this.setBasicStyledText(data.getPerfData());
            }
            this.setContentDescription(String.valueOf(data.getTitle()) + this.timestamp);
        }
    }

    public String getTimestamp() {
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        return " [" + timestamp.toString() + "]";
    }

    public static IViewPart getView(final String sID) {
        final AtomicReference viewRef = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.StatViewDiff", sID, 3);
                    viewRef.set(view);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", e.getMessage(), (Throwable)e);
                    PerfPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        });
        return (IViewPart)viewRef.get();
    }

    public static void refreshView() {
        StatComparisonView.getView(Integer.toString(SECONDARY_ID++));
    }

    public void dispose() {
        super.dispose();
        if (this.diffData instanceof StatComparisonData) {
            ((StatComparisonData)this.diffData).clearCachedData();
        }
    }
}

