/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets;

import java.text.DecimalFormat;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.AGraph;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.IGraphPrimitive;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class GraphAxis
implements IGraphPrimitive {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    protected static final String[] PREFIXES = new String[]{"", Localization.getString("GraphAxis.Kilo"), Localization.getString("GraphAxis.Mega"), Localization.getString("GraphAxis.Giga"), Localization.getString("GraphAxis.Tera"), Localization.getString("GraphAxis.Peta"), Localization.getString("GraphAxis.Exa"), Localization.getString("GraphAxis.Zetta"), Localization.getString("GraphAxis.Yotta")};
    protected int type;
    protected int tickCount;
    protected final AGraph graph;
    protected Color color;
    private String title;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected int widthX;
    protected int widthY;
    protected int range;
    protected int localMin;
    protected double locationX;
    protected double locationY;
    protected double x2a;
    protected double y2a;
    protected double tickAmount;
    protected double tickIncrament;

    public GraphAxis(AGraph graph, String title, int tickCount, int type) {
        this.graph = graph;
        this.type = type & 1;
        this.tickCount = tickCount;
        this.title = title;
        this.color = graph.axisColor;
    }

    public void setTickCount(int count) {
        this.tickCount = count;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isUnder(Point loc) {
        return this.type == 0 && loc.x < this.graph.getXPadding() || this.type == 1 && loc.y > this.graph.getSize().y - this.graph.getYPadding();
    }

    @Override
    public void calculateBounds() {
        this.x1 = this.graph.getXPadding();
        this.y2 = this.graph.getSize().y - this.graph.getYPadding();
        this.locationX = this.graph.getXPadding();
        this.tickAmount = 0.0;
        if (this.type == 1) {
            this.locationY = this.graph.getYPadding();
            this.y1 = this.graph.getSize().y - this.graph.getYPadding();
            this.x2 = this.graph.getSize().x - this.graph.getXPadding();
            this.x2a = (int)this.locationX;
            this.y2a = this.graph.getSize().y - this.graph.getYPadding();
            this.widthX = this.graph.getSize().x - (this.graph.getXPadding() << 1);
            this.widthY = 0;
            this.tickIncrament = (double)(this.graph.getLocalXMax() - this.graph.getLocalXMin()) / (double)this.tickCount;
            this.range = this.graph.getLocalXMax() - this.graph.getLocalXMin();
            this.localMin = this.graph.getLocalXMin();
        } else {
            this.locationY = this.graph.getSize().y - this.graph.getYPadding();
            this.y1 = this.graph.getYPadding();
            this.x2 = this.graph.getXPadding();
            this.x2a = this.graph.getSize().x - this.graph.getXPadding();
            this.y2a = (int)this.locationY;
            this.widthX = 0;
            this.widthY = this.graph.getSize().y - (this.graph.getYPadding() << 1);
            this.tickIncrament = (double)(this.graph.getLocalYMax() - this.graph.getLocalYMin()) / (double)this.tickCount;
            this.range = this.graph.getLocalYMax() - this.graph.getLocalYMin();
            this.localMin = this.graph.getLocalYMin();
        }
    }

    protected int stringWidth(GC gc, String s) {
        int width = 0;
        int i = 0;
        while (i < s.length()) {
            width += gc.getCharWidth(s.charAt(i));
            ++i;
        }
        return width;
    }

    protected void drawGridLine(GC gc, int x1, int y1, int x2, int y2) {
        if (this.graph.showGrid) {
            gc.setLineStyle(3);
            gc.drawLine(x1, y1, x2, y2);
        }
    }

    protected void drawTick(GC gc, int x, int y, String val) {
        gc.setLineStyle(1);
        int strWidth = this.stringWidth(gc, val);
        int strHeight = gc.getFontMetrics().getHeight();
        gc.drawLine(x, y, x + (1 == this.type ? 0 : strWidth), y + (1 == this.type ? -strHeight : 0));
        if ((x -= strWidth >> 1) < 0) {
            x = 0;
        } else if (x > this.graph.getSize().x - strWidth) {
            x = this.graph.getSize().x - strWidth;
        }
        if ((y -= strHeight >> 1) < 0) {
            y = 0;
        } else if (y > this.graph.getSize().y - strHeight) {
            y = this.graph.getSize().y - strHeight;
        }
        gc.drawText(val, x, y);
    }

    protected void drawTitle(GC gc) {
    }

    protected String getLabel(double val, int range) {
        int metric = 0;
        String pattern = ".0";
        range /= this.tickCount;
        while (val > 1000.0) {
            val /= 1000.0;
            ++metric;
            if ((range /= 10) >= 1) continue;
            pattern = String.valueOf(pattern) + "0";
        }
        DecimalFormat format = new DecimalFormat(pattern);
        return String.valueOf(format.format(val)) + PREFIXES[metric];
    }

    @Override
    public void paint(GC gc) {
        this.calculateBounds();
        Color foreground = gc.getForeground();
        gc.setForeground(this.color);
        gc.drawLine(this.x1, this.y1, this.x2, this.y2);
        this.drawTitle(gc);
        int i = 0;
        while (i <= this.tickCount) {
            this.drawGridLine(gc, (int)this.locationX, (int)this.locationY, (int)this.x2a, (int)this.y2a);
            this.drawTick(gc, (int)this.locationX, (int)this.y2a, this.getLabel((double)this.localMin + this.tickAmount, this.range));
            this.locationX += (double)this.widthX / (double)this.tickCount;
            this.x2a += (double)this.widthX / (double)this.tickCount;
            this.locationY -= (double)this.widthY / (double)this.tickCount;
            this.y2a -= (double)this.widthY / (double)this.tickCount;
            this.tickAmount += this.tickIncrament;
            ++i;
        }
        gc.setForeground(foreground);
    }
}

