/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.editor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.linuxtools.internal.systemtap.ui.editor.Localization;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class SimpleDocumentProvider
extends AbstractDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof IEditorInput) {
            Document document = new Document();
            if (this.setDocumentContent((IDocument)document, (IEditorInput)element)) {
                this.setupDocument((IDocument)document);
            }
            return document;
        }
        return null;
    }

    private boolean setDocumentContent(IDocument document, IEditorInput input) throws CoreException {
        InputStreamReader reader;
        block8: {
            reader = null;
            try {
                if (input instanceof FileStoreEditorInput) {
                    reader = new InputStreamReader(((FileStoreEditorInput)input).getURI().toURL().openStream());
                    break block8;
                }
                if (input instanceof IPathEditorInput) {
                    reader = new FileReader(((IPathEditorInput)input).getPath().toFile());
                    break block8;
                }
                return false;
            }
            catch (FileNotFoundException e) {
                return true;
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.editor", Localization.getString("SimpleDocumentProvider.incorrectURL"), (Throwable)e));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.editor", Localization.getString("SimpleDocumentProvider.errorCreatingFile"), (Throwable)e));
            }
        }
        try {
            this.setDocumentContent(document, reader);
            return true;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.editor", 0, Localization.getString("SimpleDocumentProvider.errorCreatingFile"), (Throwable)e));
        }
    }

    private void setDocumentContent(IDocument document, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        try {
            StringBuffer buffer = new StringBuffer(512);
            char[] readBuffer = new char[512];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
        }
        finally {
            ((Reader)in).close();
        }
    }

    protected void setupDocument(IDocument document) {
    }

    protected IAnnotationModel createAnnotationModel(Object element) {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            IPath path = pei.getPath();
            File file = path.toFile();
            try {
                file.createNewFile();
                if (file.exists()) {
                    if (!file.canWrite()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.editor", 0, "file is read-only", null));
                    }
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.editor", 0, "error creating file", null));
                }
                FileWriter writer = new FileWriter(file);
                this.writeDocumentContent(document, writer, monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.editor", 0, Localization.getString("errorCreatingFile"), (Throwable)e));
            }
        }
    }

    private void writeDocumentContent(IDocument document, Writer writer, IProgressMonitor monitor) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        try {
            out.write(document.get());
        }
        finally {
            ((Writer)out).close();
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            File file = pei.getPath().toFile();
            return file.canWrite() || !file.exists();
        }
        return false;
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }

    public boolean isStateValidated(Object element) {
        return true;
    }
}

