/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class ScannerContext {
    private Reader fReader;
    private int fOffset;
    private Stack<Integer> fUndo = new Stack();

    public ScannerContext initialize(Reader r) {
        this.fReader = r;
        this.fOffset = 0;
        return this;
    }

    public ScannerContext initialize(Reader r, int offset) {
        try {
            r.skip(offset);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        this.fReader = r;
        this.fOffset = offset;
        return this;
    }

    public int read() throws IOException {
        ++this.fOffset;
        return this.fReader.read();
    }

    public final int getOffset() {
        return this.fOffset;
    }

    public final Reader getReader() {
        return this.fReader;
    }

    public final int undoStackSize() {
        return this.fUndo.size();
    }

    public final int popUndo() {
        return this.fUndo.pop();
    }

    public void pushUndo(int undo) {
        this.fUndo.push(new Integer(undo));
    }
}

