/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.row.RowParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.SelectGraphAndSeriesWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SystemTapScriptGraphOptionsTab
extends AbstractLaunchConfigurationTab {
    static final String RUN_WITH_CHART = "runWithChart";
    static final String NUMBER_OF_COLUMNS = "numberOfColumns";
    static final String REGEX_BOX = "regexBox_";
    private static final String NUMBER_OF_GRAPHS = "numberOfGraphs";
    private static final String GRAPH_TITLE = "graphTitle";
    private static final String GRAPH_KEY = "graphKey";
    private static final String GRAPH_X_SERIES = "graphXSeries";
    private static final String GRAPH_ID = "graphID";
    private static final String GRAPH_Y_SERIES_LENGTH = "graphYSeriesLength";
    private static final String GRAPH_Y_SERIES = "graphYSeries";
    private ModifyListener regExListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            SystemTapScriptGraphOptionsTab.this.refreshRegEx();
        }
    };
    private static final int COLUMNS = 3;
    private static final int MAX_SERIES = 24;
    private Label lblRegEx;
    private Composite textFieldsComposite;
    private Spinner numberOfColumnsSpinner;
    private ScrolledComposite regexTextScrolledComposite;
    private Group outputParsingGroup;
    private Button runWithChartCheckButton;
    private Table graphsTable;
    private Button addGraphButton;
    private Button duplicateGraphButton;
    private Button editGraphButton;
    private Button removeGraphButton;
    private TableItem selectedTableItem;
    private Group graphsGroup;

    public static IDataSetParser createDatasetParser(ILaunchConfiguration configuration) {
        try {
            int n = configuration.getAttribute(NUMBER_OF_COLUMNS, 0);
            ArrayList<String> regEx = new ArrayList<String>(n * 2);
            int i = 0;
            while (i < n * 3) {
                if (i % 3 != 0) {
                    String text = configuration.getAttribute(REGEX_BOX + i, null);
                    regEx.add(text);
                }
                ++i;
            }
            return new RowParser(regEx.toArray(new String[0]));
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_0, (Exception)((Object)e));
            return null;
        }
    }

    public static IDataSet createDataset(ILaunchConfiguration configuration) {
        try {
            int n = configuration.getAttribute(NUMBER_OF_COLUMNS, 0);
            ArrayList<String> labels = new ArrayList<String>(n);
            int i = 0;
            while (i < n * 3) {
                if (i % 3 == 0) {
                    String text = configuration.getAttribute(REGEX_BOX + i, null);
                    labels.add(text);
                }
                ++i;
            }
            return DataSetFactory.createDataSet((String)"org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.rowdataset", (String[])labels.toArray(new String[0]));
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_1, (Exception)((Object)e));
            return null;
        }
    }

    public static LinkedList<GraphData> createGraphsFromConfiguration(ILaunchConfiguration configuration) throws CoreException {
        LinkedList<GraphData> graphs = new LinkedList<GraphData>();
        int n = configuration.getAttribute(NUMBER_OF_GRAPHS, 0);
        int i = 0;
        while (i < n) {
            GraphData graphData = new GraphData();
            graphData.title = configuration.getAttribute(GRAPH_TITLE + i, "");
            graphData.key = configuration.getAttribute(GRAPH_KEY + i, "");
            graphData.xSeries = configuration.getAttribute(GRAPH_X_SERIES + i, 0);
            graphData.graphID = configuration.getAttribute(GRAPH_ID + i, "");
            int ySeriesLength = configuration.getAttribute(GRAPH_Y_SERIES_LENGTH, 0);
            int[] ySeries = new int[ySeriesLength];
            int j = 0;
            while (j < ySeriesLength) {
                ySeries[j] = configuration.getAttribute(GRAPH_Y_SERIES + i + "_" + j, 0);
                ++j;
            }
            graphData.ySeries = ySeries;
            graphs.add(graphData);
            ++i;
        }
        return graphs;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.runWithChartCheckButton = new Button(top, 32);
        this.runWithChartCheckButton.setText(Messages.SystemTapScriptGraphOptionsTab_2);
        this.runWithChartCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.setGraphingEnabled(SystemTapScriptGraphOptionsTab.this.runWithChartCheckButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.setGraphingEnabled(SystemTapScriptGraphOptionsTab.this.runWithChartCheckButton.getSelection());
            }
        });
        this.runWithChartCheckButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_3);
        this.outputParsingGroup = new Group(top, 16);
        this.outputParsingGroup.setText(Messages.SystemTapScriptGraphOptionsTab_4);
        this.outputParsingGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createColumnSelector((Composite)this.outputParsingGroup);
        this.graphsGroup = new Group(top, 16);
        this.graphsGroup.setText(Messages.SystemTapScriptGraphOptionsTab_graphsTitle);
        this.graphsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGraphCreateArea((Composite)this.graphsGroup);
        this.setGraphingEnabled(false);
        this.runWithChartCheckButton.setSelection(false);
    }

    protected void createColumnSelector(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Composite numberOfColumnsComposite = new Composite(parent, 0);
        GridLayout twoColumns = new GridLayout();
        twoColumns.numColumns = 2;
        numberOfColumnsComposite.setLayout((Layout)twoColumns);
        Label lblSeries = new Label(numberOfColumnsComposite, 0);
        lblSeries.setText(Messages.ParsingWizardPage_NumberOfColumns);
        this.numberOfColumnsSpinner = new Spinner(numberOfColumnsComposite, 2048);
        this.numberOfColumnsSpinner.setMinimum(1);
        this.numberOfColumnsSpinner.setMaximum(24);
        this.numberOfColumnsSpinner.setSelection(3);
        this.numberOfColumnsSpinner.setIncrement(1);
        this.numberOfColumnsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptGraphOptionsTab.this.refreshRegexRows();
                SystemTapScriptGraphOptionsTab.this.refreshRegEx();
                SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridLayout threeColumnLayout = new GridLayout();
        threeColumnLayout.numColumns = 3;
        threeColumnLayout.makeColumnsEqualWidth = true;
        Composite expressionTableLabels = new Composite(parent, 0);
        expressionTableLabels.setLayout((Layout)threeColumnLayout);
        expressionTableLabels.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(expressionTableLabels, 0);
        label.setText(Messages.ParsingWizardPage_Title);
        label.setAlignment(0x1000000);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label = new Label(expressionTableLabels, 0);
        label.setText(Messages.ParsingWizardPage_RegularExpression);
        label.setAlignment(0x1000000);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label = new Label(expressionTableLabels, 0);
        label.setText(Messages.ParsingWizardPage_Delimiter);
        label.setAlignment(0x1000000);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.regexTextScrolledComposite = new ScrolledComposite(parent, 2816);
        this.regexTextScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textFieldsComposite = new Composite((Composite)this.regexTextScrolledComposite, 0);
        this.textFieldsComposite.setLayout((Layout)threeColumnLayout);
        this.textFieldsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.regexTextScrolledComposite.setContent((Control)this.textFieldsComposite);
        this.regexTextScrolledComposite.setExpandHorizontal(true);
        this.regexTextScrolledComposite.setExpandVertical(true);
        Composite regexSummaryComposite = new Composite(parent, 0);
        regexSummaryComposite.setLayout((Layout)twoColumns);
        Label lblRegExTitle = new Label(regexSummaryComposite, 0);
        lblRegExTitle.setText(String.valueOf(Messages.ParsingWizardPage_RegularExpression) + ":");
        this.lblRegEx = new Label(regexSummaryComposite, 0);
        this.lblRegEx.setLayoutData((Object)new GridData(4, 4, true, true));
        this.refreshRegexRows();
    }

    private IDataSet getDataset() {
        int n = this.numberOfColumnsSpinner.getSelection();
        ArrayList<String> labels = new ArrayList<String>(n);
        Control[] regExTexts = this.textFieldsComposite.getChildren();
        int i = 0;
        while (i < n * 3) {
            if (i % 3 == 0) {
                String text = ((Text)regExTexts[i]).getText();
                labels.add(text);
            }
            ++i;
        }
        return DataSetFactory.createDataSet((String)"org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.rowdataset", (String[])labels.toArray(new String[0]));
    }

    private void createGraphCreateArea(Composite comp) {
        GridLayout twoColumnsLayout = new GridLayout();
        comp.setLayout((Layout)twoColumnsLayout);
        twoColumnsLayout.numColumns = 2;
        this.graphsTable = new Table(comp, 2052);
        GridData layoutData = new GridData(4, 4, true, true);
        this.graphsTable.setLayoutData((Object)layoutData);
        Composite buttonComposite = new Composite(comp, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        buttonComposite.setLayout((Layout)gridLayout);
        this.addGraphButton = new Button(buttonComposite, 8);
        this.addGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_AddGraphButton);
        this.addGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_AddGraphButtonToolTip);
        this.addGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.duplicateGraphButton = new Button(buttonComposite, 8);
        this.duplicateGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_DuplicateGraphButton);
        this.duplicateGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_DuplicateGraphButtonToolTip);
        this.duplicateGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editGraphButton = new Button(buttonComposite, 8);
        this.editGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_EditGraphButton);
        this.editGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_EditGraphButtonToolTip);
        this.editGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.removeGraphButton = new Button(buttonComposite, 8);
        this.removeGraphButton.setText(Messages.SystemTapScriptGraphOptionsTab_RemoveGraphButton);
        this.removeGraphButton.setToolTipText(Messages.SystemTapScriptGraphOptionsTab_RemoveGraphButtonToolTip);
        this.removeGraphButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.graphsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.selectedTableItem = (TableItem)e.item;
                SystemTapScriptGraphOptionsTab.this.setSelectionControlsEnabled(true);
            }
        });
        this.addGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(SystemTapScriptGraphOptionsTab.this.getDataset(), null);
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    TableItem item = new TableItem(SystemTapScriptGraphOptionsTab.this.graphsTable, 0);
                    item.setText(String.valueOf(GraphFactory.getGraphName((String)gd.graphID)) + ":" + gd.title);
                    item.setData((Object)gd);
                    SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.duplicateGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphData gd = (GraphData)SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData();
                TableItem item = new TableItem(SystemTapScriptGraphOptionsTab.this.graphsTable, 0);
                item.setText(String.valueOf(GraphFactory.getGraphName((String)gd.graphID)) + ":" + gd.title);
                item.setData((Object)gd);
                SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.editGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(SystemTapScriptGraphOptionsTab.this.getDataset(), (GraphData)SystemTapScriptGraphOptionsTab.this.selectedTableItem.getData());
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    SystemTapScriptGraphOptionsTab.this.selectedTableItem.setText(String.valueOf(GraphFactory.getGraphName((String)gd.graphID)) + ":" + gd.title);
                    SystemTapScriptGraphOptionsTab.this.selectedTableItem.setData((Object)gd);
                    SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.removeGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemTapScriptGraphOptionsTab.this.selectedTableItem.dispose();
                SystemTapScriptGraphOptionsTab.this.setSelectionControlsEnabled(false);
                SystemTapScriptGraphOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void refreshRegexRows() {
        int numberOfColumns = this.numberOfColumnsSpinner.getSelection();
        int currentNumberOfColumns = this.textFieldsComposite.getChildren().length / 3;
        while (currentNumberOfColumns < numberOfColumns) {
            this.addColumn();
            ++currentNumberOfColumns;
        }
        while (currentNumberOfColumns > numberOfColumns) {
            this.removeColumn();
            --currentNumberOfColumns;
        }
        this.refreshRegEx();
    }

    private void addColumn() {
        Text text = new Text(this.textFieldsComposite, 2048);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.addModifyListener(this.regExListener);
        text = new Text(this.textFieldsComposite, 2048);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.setText("\\d+");
        text.addModifyListener(this.regExListener);
        text = new Text(this.textFieldsComposite, 2048);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        text.setText("\\D+");
        text.addModifyListener(this.regExListener);
        this.regexTextScrolledComposite.setMinSize(this.textFieldsComposite.computeSize(-1, -1));
        this.textFieldsComposite.layout();
    }

    private void removeColumn() {
        Control[] children = this.textFieldsComposite.getChildren();
        int i = children.length - 1;
        children[i--].dispose();
        children[i--].dispose();
        children[i--].dispose();
        this.regexTextScrolledComposite.setMinSize(this.textFieldsComposite.computeSize(-1, -1));
        this.textFieldsComposite.layout();
    }

    private void refreshRegEx() {
        int series = this.numberOfColumnsSpinner.getSelection();
        series *= 3;
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < series) {
            if (i % 3 != 0) {
                s.append(((Text)this.textFieldsComposite.getChildren()[i]).getText());
            }
            ++i;
        }
        this.lblRegEx.setText(s.toString());
        this.lblRegEx.getParent().pack();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(RUN_WITH_CHART, false);
        configuration.setAttribute(NUMBER_OF_COLUMNS, 3);
        configuration.setAttribute(NUMBER_OF_GRAPHS, 0);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean chart = configuration.getAttribute(RUN_WITH_CHART, false);
            this.setGraphingEnabled(chart);
            this.runWithChartCheckButton.setSelection(chart);
            int n = configuration.getAttribute(NUMBER_OF_COLUMNS, 0);
            this.numberOfColumnsSpinner.setSelection(n);
            Control[] textBoxes = this.textFieldsComposite.getChildren();
            int i = 0;
            while (i < textBoxes.length) {
                String text = configuration.getAttribute(REGEX_BOX + i, null);
                if (text != null) {
                    ((Text)textBoxes[i]).setText(text);
                }
                ++i;
            }
            this.graphsTable.removeAll();
            LinkedList<GraphData> graphs = SystemTapScriptGraphOptionsTab.createGraphsFromConfiguration(configuration);
            for (GraphData graphData : graphs) {
                TableItem item = new TableItem(this.graphsTable, 0);
                item.setText(String.valueOf(GraphFactory.getGraphName((String)graphData.graphID)) + ":" + graphData.title);
                item.setData((Object)graphData);
            }
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptGraphOptionsTab_5, (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(RUN_WITH_CHART, this.runWithChartCheckButton.getSelection());
        int n = this.numberOfColumnsSpinner.getSelection();
        configuration.setAttribute(NUMBER_OF_COLUMNS, n);
        Control[] textBoxes = this.textFieldsComposite.getChildren();
        int i = 0;
        while (i < textBoxes.length) {
            String text = ((Text)textBoxes[i]).getText();
            configuration.setAttribute(REGEX_BOX + i, text);
            ++i;
        }
        TableItem[] list = this.graphsTable.getItems();
        configuration.setAttribute(NUMBER_OF_GRAPHS, list.length);
        int i2 = 0;
        while (i2 < list.length) {
            GraphData graphData = (GraphData)list[i2].getData();
            configuration.setAttribute(GRAPH_TITLE + i2, graphData.title);
            configuration.setAttribute(GRAPH_KEY + i2, graphData.key);
            configuration.setAttribute(GRAPH_X_SERIES + i2, graphData.xSeries);
            configuration.setAttribute(GRAPH_ID + i2, graphData.graphID);
            configuration.setAttribute(GRAPH_Y_SERIES_LENGTH, graphData.ySeries.length);
            int j = 0;
            while (j < graphData.ySeries.length) {
                configuration.setAttribute(GRAPH_Y_SERIES + i2 + "_" + j, graphData.ySeries[j]);
                ++j;
            }
            ++i2;
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.runWithChartCheckButton.getSelection()) {
            return true;
        }
        int series = this.numberOfColumnsSpinner.getSelection();
        int i = 0;
        while (i < series * 3) {
            if (((Text)this.textFieldsComposite.getChildren()[i]).getText().isEmpty()) {
                this.setErrorMessage(Messages.SystemTapScriptGraphOptionsTab_6);
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return Messages.SystemTapScriptGraphOptionsTab_7;
    }

    public Image getImage() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.systemtap.ui.ide", (String)"icons/graphing_tab.gif").createImage();
    }

    private void setGraphingEnabled(boolean enabled) {
        this.setControlEnabled((Composite)this.outputParsingGroup, enabled);
        this.setControlEnabled((Composite)this.graphsGroup, enabled);
        this.setSelectionControlsEnabled(this.selectedTableItem != null);
        this.updateLaunchConfigurationDialog();
    }

    private void setControlEnabled(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            if (child instanceof Composite) {
                this.setControlEnabled((Composite)child, enabled);
            }
            ++n2;
        }
    }

    private void setSelectionControlsEnabled(boolean enabled) {
        this.duplicateGraphButton.setEnabled(enabled);
        this.editGraphButton.setEnabled(enabled);
        this.removeGraphButton.setEnabled(enabled);
    }
}

