/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptChartHandler;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptHandler;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.SystemTapScriptGraphOptionsTab;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;

public class SystemTapScriptLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    static final String CONFIGURATION_TYPE = "org.eclipse.linuxtools.systemtap.ui.ide.SystemTapLaunchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RunScriptHandler action;
        IPreferenceStore preferenceStore = ConsoleLogPlugin.getDefault().getPreferenceStore();
        boolean runWithChart = configuration.getAttribute("runWithChart", false);
        if (runWithChart) {
            IDataSet dataSet = SystemTapScriptGraphOptionsTab.createDataset(configuration);
            IDataSetParser parser = SystemTapScriptGraphOptionsTab.createDatasetParser(configuration);
            LinkedList<GraphData> graphs = SystemTapScriptGraphOptionsTab.createGraphsFromConfiguration(configuration);
            action = new RunScriptChartHandler(parser, dataSet, graphs);
        } else {
            action = new RunScriptHandler();
        }
        String path = configuration.getAttribute("ScriptPath", "");
        if (!path.isEmpty()) {
            action.setPath((IPath)new Path(path));
        }
        String userName = configuration.getAttribute("userName", "");
        preferenceStore.setValue("scpuser", userName);
        String password = configuration.getAttribute("userPassword", "");
        preferenceStore.setValue("scppassword", password);
        boolean runAsCurrentUser = configuration.getAttribute("executeAsCurrentUser", true);
        boolean runLocal = configuration.getAttribute("executeOnLocalHost", true);
        action.setLocalScript(runLocal && runAsCurrentUser);
        String hostName = configuration.getAttribute("hostName", "localhost");
        preferenceStore.setValue("host", hostName);
        String value = configuration.getAttribute(IDEPreferenceConstants.STAP_CMD_OPTION[2], "");
        if (!value.isEmpty()) {
            action.addComandLineOptions(String.valueOf(IDEPreferenceConstants.STAP_CMD_OPTION[0]) + " " + value);
        }
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            boolean flag = configuration.getAttribute(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false);
            if (flag) {
                action.addComandLineOptions(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][0]);
            }
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            value = configuration.getAttribute(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], "");
            if (!value.isEmpty()) {
                action.addComandLineOptions(String.valueOf(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][0]) + " " + value);
            }
            ++i;
        }
        value = configuration.getAttribute("MiscComandLineOptions", "");
        if (!value.isEmpty()) {
            action.addComandLineOptions(value);
        }
        action.execute(null);
    }
}

