/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;

public class SystemTapScriptLaunchShortcut
extends ProfileLaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        String path = "";
        path = editor.getEditorInput() instanceof PathEditorInput ? ((PathEditorInput)editor.getEditorInput()).getPath().toString() : ResourceUtil.getFile((IEditorInput)editor.getEditorInput()).getLocation().toString();
        this.searchAndLaunch(path);
    }

    public void launch(ISelection selection, String mode) {
        IPath path = ((IFile)((TreeSelection)selection).getFirstElement()).getLocation();
        this.searchAndLaunch(path.toOSString());
    }

    private void searchAndLaunch(String path) {
        ILaunchConfiguration configuration = this.findLaunchConfiguration(path);
        if (configuration == null) {
            return;
        }
        try {
            configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptLaunchShortcut_couldNotLaunchScript, (Exception)((Object)e));
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(String scriptPath) {
        ILaunchConfigurationWorkingCopy configuration = null;
        ArrayList<ILaunchConfiguration> candidateConfiguraions = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getLaunchConfigType());
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute("ScriptPath", "").equals(scriptPath)) {
                    candidateConfiguraions.add(config);
                }
                ++n2;
            }
            int candidateCount = candidateConfiguraions.size();
            if (candidateCount == 0) {
                ILaunchConfigurationType type = this.getLaunchConfigType();
                configuration = type.newInstance(null, "Default");
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                wc.setAttribute("ScriptPath", scriptPath);
                configuration = wc.doSave();
            } else {
                configuration = candidateCount == 1 ? (ILaunchConfiguration)candidateConfiguraions.get(0) : this.chooseConfiguration(candidateConfiguraions, "run");
            }
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptLaunchShortcut_couldNotFindConfig, (Exception)((Object)e));
        }
        return configuration;
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.linuxtools.systemtap.ui.ide.SystemTapLaunchConfigurationType");
    }

    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
    }
}

