/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.FunctionBrowserAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

public class FunctionBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.FunctionBrowserView";
    private FunctionBrowserAction doubleClickAction;
    private TreeNode functions;
    private TreeNode localFunctions;
    private Menu menu;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TapsetLibrary.init();
        TapsetLibrary.addFunctionListener(new BrowserView.ViewUpdater());
        this.refresh();
        this.makeActions();
    }

    @Override
    public void refresh() {
        this.functions = TapsetLibrary.getFunctions();
        if (this.functions != null) {
            this.addLocalFunctions(this.localFunctions);
        }
    }

    public void addLocalFunctions(TreeNode localFunctionTree) {
        if (this.functions.getChildCount() > 0) {
            TreeNode localFuncs = this.functions.getChildAt(0);
            if ("<local>".equals(localFuncs.toString())) {
                this.functions.remove(0);
            }
            if (this.localFunctions != null) {
                this.localFunctions = localFunctionTree;
                this.localFunctions.setDisplay("<local>");
                this.functions.addAt(this.localFunctions, 0);
            }
        }
        this.viewer.setInput((Object)this.functions);
    }

    private void makeActions() {
        this.doubleClickAction = new FunctionBrowserAction(this.getSite().getWorkbenchWindow(), this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.viewer != null) {
            this.viewer.removeDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        }
        if (this.doubleClickAction != null) {
            this.doubleClickAction.dispose();
        }
        this.doubleClickAction = null;
        if (this.localFunctions != null) {
            this.localFunctions.dispose();
        }
        this.localFunctions = null;
        if (this.functions != null) {
            this.functions.dispose();
        }
        this.functions = null;
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
        TapsetLibrary.stop();
    }
}

