/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.systemtapgui.SystemTapGUIPlugin;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences.PreferenceConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EnvironmentVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static StringFieldEditor[] envVariables;

    public EnvironmentVariablesPreferencePage() {
        this.setPreferenceStore(SystemTapGUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Environment Variables.");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite c = new Composite((Composite)sc, 0);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setContent((Control)c);
        envVariables = new StringFieldEditor[PreferenceConstants.P_ENV.length];
        int i = 0;
        while (i < envVariables.length) {
            EnvironmentVariablesPreferencePage.envVariables[i] = this.createStringFieldEditor(PreferenceConstants.P_ENV[i][0], PreferenceConstants.P_ENV[i][1], c);
            ++i;
        }
        return sc;
    }

    private StringFieldEditor createStringFieldEditor(String name, String lblText, Composite parent) {
        StringFieldEditor sfe = new StringFieldEditor(name, lblText, parent);
        sfe.setPage((DialogPage)this);
        sfe.setPreferenceStore(this.getPreferenceStore());
        sfe.load();
        return sfe;
    }

    protected void performDefaults() {
        StringFieldEditor[] stringFieldEditorArray = envVariables;
        int n = envVariables.length;
        int n2 = 0;
        while (n2 < n) {
            StringFieldEditor envVariable = stringFieldEditorArray[n2];
            envVariable.loadDefault();
            ++n2;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        StringFieldEditor[] stringFieldEditorArray = envVariables;
        int n = envVariables.length;
        int n2 = 0;
        while (n2 < n) {
            StringFieldEditor envVariable = stringFieldEditorArray[n2];
            envVariable.store();
            ++n2;
        }
        return true;
    }

    public static String[] getEnvironmentVariables() {
        ArrayList<String> vars = new ArrayList<String>();
        String[] envVars = null;
        if (SystemTapGUIPlugin.getDefault() == null || SystemTapGUIPlugin.getDefault().getPreferenceStore() == null) {
            return null;
        }
        IPreferenceStore p = SystemTapGUIPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PreferenceConstants.P_ENV.length) {
            String var = p.getString(PreferenceConstants.P_ENV[i][0]).trim();
            if (!var.equals("")) {
                vars.add(String.valueOf(PreferenceConstants.P_ENV[i][0]) + "=" + var);
            }
            ++i;
        }
        if (vars.size() > 0) {
            envVars = new String[vars.size()];
            i = 0;
            while (i < vars.size()) {
                envVars[i] = (String)vars.get(i);
                ++i;
            }
        }
        return envVars;
    }

    public void dispose() {
        super.dispose();
        int i = 0;
        while (i < envVariables.length) {
            envVariables[i].dispose();
            EnvironmentVariablesPreferencePage.envVariables[i] = null;
            ++i;
        }
        envVariables = null;
    }
}

