/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import java.io.IOException;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystem;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystemBuildRequest;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;

public class HistoryBuilder
extends TmfComponent {
    private final ITmfStateProvider sp;
    private final StateSystem ss;
    private final IStateHistoryBackend hb;
    private boolean started = true;

    public HistoryBuilder(ITmfStateProvider stateProvider, StateSystem ss, IStateHistoryBackend backend, boolean buildManually) {
        if (stateProvider == null || backend == null || ss == null) {
            throw new IllegalArgumentException();
        }
        if (stateProvider.getAssignedStateSystem() != ss) {
            throw new IllegalArgumentException();
        }
        this.sp = stateProvider;
        this.hb = backend;
        this.ss = ss;
        if (buildManually) {
            TmfSignalManager.deregister(this);
            this.buildManually();
        } else {
            this.started = false;
        }
    }

    public static ITmfStateSystemBuilder openExistingHistory(IStateHistoryBackend hb) throws IOException {
        return new StateSystem(hb, false);
    }

    public ITmfStateSystemBuilder getStateSystemBuilder() {
        return this.ss;
    }

    public ITmfStateSystem getStateSystemQuerier() {
        return this.ss;
    }

    private void buildManually() {
        StateSystemBuildRequest request = new StateSystemBuildRequest(this);
        this.sp.getTrace().sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        ITmfTrace sender = signal.getTrace();
        if (!this.signalIsForUs(sender)) {
            return;
        }
        if (!this.started) {
            this.started = true;
            StateSystemBuildRequest request = new StateSystemBuildRequest(this);
            sender.sendRequest(request);
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        ITmfTrace sender = signal.getTrace();
        if (this.signalIsForUs(sender) && !this.started) {
            this.close(true);
        }
    }

    private boolean signalIsForUs(ITmfTrace sender) {
        if (sender instanceof TmfExperiment) {
            TmfExperiment exp = (TmfExperiment)sender;
            ITmfTrace[] iTmfTraceArray = exp.getTraces();
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace childTrace = iTmfTraceArray[n2];
                if (childTrace == this.sp.getTrace()) {
                    return true;
                }
                ++n2;
            }
        } else if (sender == this.sp.getTrace()) {
            return true;
        }
        return false;
    }

    ITmfStateProvider getStateProvider() {
        return this.sp;
    }

    void close(boolean deleteFiles) {
        this.sp.dispose();
        if (deleteFiles) {
            this.hb.removeFiles();
        }
        this.dispose();
    }
}

