/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.valgrind.launch.ExportWizardConstants;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindExportWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ValgrindExportWizard
extends Wizard
implements IExportWizard {
    protected ValgrindExportWizardPage exportPage;

    public boolean performFinish() {
        final File[] logs = this.exportPage.getSelectedFiles();
        final IPath outputPath = this.exportPage.getOutputPath();
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (logs.length > 0) {
                        File outputDir = outputPath.toFile();
                        monitor.beginTask(NLS.bind((String)Messages.getString("ValgrindExportWizard.Export_task"), (Object)outputPath.toOSString()), logs.length);
                        AbstractInterruptibleChannel inChan = null;
                        AbstractInterruptibleChannel outChan = null;
                        try {
                            try {
                                File[] fileArray = logs;
                                int n = logs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File log = fileArray[n2];
                                    monitor.subTask(NLS.bind((String)Messages.getString("ValgrindExportWizard.Export_subtask"), (Object)log.getName()));
                                    File outLog = new File(outputDir, log.getName());
                                    inChan = new FileInputStream(log).getChannel();
                                    outChan = new FileOutputStream(outLog).getChannel();
                                    ((FileChannel)outChan).transferFrom((ReadableByteChannel)((Object)inChan), 0L, ((FileChannel)inChan).size());
                                    inChan.close();
                                    outChan.close();
                                    monitor.worked(1);
                                    ++n2;
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            try {
                                if (inChan != null && inChan.isOpen()) {
                                    inChan.close();
                                }
                                if (outChan != null && outChan.isOpen()) {
                                    outChan.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.linuxtools.valgrind.launch", Messages.getString("ValgrindExportWizard.Export_fail"), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)ExportWizardConstants.WIZARD_TITLE, null, (IStatus)status);
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ExportWizardConstants.WIZARD_WINDOW_TITLE);
        this.exportPage = this.getWizardPage();
        this.exportPage.setDescription(ExportWizardConstants.WIZARD_DESCRIPTION);
        this.addPage((IWizardPage)this.exportPage);
    }

    protected ValgrindExportWizardPage getWizardPage() {
        return new ValgrindExportWizardPage(Messages.getString("ValgrindExportWizard.Page_name"), ExportWizardConstants.WIZARD_TITLE, null);
    }
}

