/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.MavenMetadataCache;
import org.apache.maven.repository.DelegatingLocalArtifactRepository;
import org.apache.maven.repository.LocalArtifactRepository;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.ILocalRepositoryListener;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingResult;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.MarkerUtils;
import org.eclipse.m2e.core.internal.project.DependencyResolutionContext;
import org.eclipse.m2e.core.internal.project.IManagedCache;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.internal.project.registry.AbstractMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.Capability;
import org.eclipse.m2e.core.internal.project.registry.DefaultMavenDependencyResolver;
import org.eclipse.m2e.core.internal.project.registry.EclipseWorkspaceArtifactRepository;
import org.eclipse.m2e.core.internal.project.registry.ILifecycleMapping2;
import org.eclipse.m2e.core.internal.project.registry.IProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.MavenCapability;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.MavenRequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.MutableProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryReader;
import org.eclipse.m2e.core.internal.project.registry.RequiredCapability;
import org.eclipse.m2e.core.internal.project.registry.StaleMutableProjectRegistryException;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.repository.WorkspaceReader;

public class ProjectRegistryManager {
    static final Logger log = LoggerFactory.getLogger(ProjectRegistryManager.class);
    static final String ARTIFACT_TYPE_POM = "pom";
    static final String ARTIFACT_TYPE_JAR = "jar";
    public static final String ARTIFACT_TYPE_JAVA_SOURCE = "java-source";
    public static final String ARTIFACT_TYPE_JAVADOC = "javadoc";
    public static final String LIFECYCLE_DEFAULT = "deploy";
    public static final String LIFECYCLE_CLEAN = "clean";
    public static final String LIFECYCLE_SITE = "site";
    public static final List<? extends IPath> METADATA_PATH = Arrays.asList(new Path("pom.xml"), new Path(".project"), new Path(".classpath"), new Path(".settings/org.eclipse.m2e.core.prefs"));
    private final ProjectRegistry projectRegistry;
    final MavenImpl maven;
    final IMavenMarkerManager markerManager;
    private final ProjectRegistryReader stateReader;
    private final Set<IMavenProjectChangedListener> projectChangeListeners = new LinkedHashSet<IMavenProjectChangedListener>();
    private volatile Thread syncRefreshThread;

    public ProjectRegistryManager(MavenImpl maven, File stateLocationDir, boolean readState, IMavenMarkerManager mavenMarkerManager) {
        this.markerManager = mavenMarkerManager;
        this.maven = maven;
        this.stateReader = new ProjectRegistryReader(stateLocationDir);
        ProjectRegistry state = readState && this.stateReader != null ? this.stateReader.readWorkspaceState(this) : null;
        this.projectRegistry = state != null && state.isValid() ? state : new ProjectRegistry();
    }

    public MavenProjectFacade create(IProject project, IProgressMonitor monitor) {
        return this.create(this.getPom(project), false, monitor);
    }

    public MavenProjectFacade create(IFile pom, boolean load, IProgressMonitor monitor) {
        if (pom == null) {
            return null;
        }
        MavenProjectFacade projectFacade = this.projectRegistry.getProjectFacade(pom);
        if (projectFacade == null && load) {
            ResolverConfiguration configuration = ResolverConfigurationIO.readResolverConfiguration(pom.getProject());
            MavenExecutionResult executionResult = this.readProjectWithDependencies(this.projectRegistry, pom, configuration, monitor);
            MavenProject mavenProject = executionResult.getProject();
            if (mavenProject != null) {
                projectFacade = new MavenProjectFacade(this, pom, mavenProject, null, configuration);
            } else {
                List exceptions = executionResult.getExceptions();
                if (exceptions != null) {
                    for (Throwable ex : exceptions) {
                        String msg = "Failed to read Maven project: " + ex.getMessage();
                        log.error(msg, ex);
                    }
                }
            }
        }
        return projectFacade;
    }

    IFile getPom(IProject project) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        return project.getFile("pom.xml");
    }

    public Set<IFile> remove(MutableProjectRegistry state, Set<IFile> poms, boolean force) {
        LinkedHashSet<IFile> pomSet = new LinkedHashSet<IFile>();
        for (IFile pom : poms) {
            MavenProjectFacade facade = state.getProjectFacade(pom);
            if (!force && facade != null && !facade.isStale()) continue;
            pomSet.addAll(this.remove(state, pom));
        }
        return pomSet;
    }

    public Set<IFile> remove(MutableProjectRegistry state, IFile pom) {
        MavenProjectFacade facade = state.getProjectFacade(pom);
        ArtifactKey mavenProject = facade != null ? facade.getArtifactKey() : null;
        this.flushCaches(pom, facade);
        if (mavenProject == null) {
            state.removeProject(pom, null);
            return Collections.emptySet();
        }
        LinkedHashSet<IFile> pomSet = new LinkedHashSet<IFile>();
        pomSet.addAll(state.getDependents(MavenCapability.createMavenArtifact(mavenProject), false));
        pomSet.addAll(state.getDependents(MavenCapability.createMavenParent(mavenProject), false));
        state.removeProject(pom, mavenProject);
        pomSet.addAll(this.refreshWorkspaceModules(state, pom, mavenProject));
        pomSet.remove(pom);
        return pomSet;
    }

    private void flushCaches(IFile pom, MavenProjectFacade facade) {
        ArtifactKey key = null;
        MavenProject project = null;
        if (facade != null) {
            key = facade.getArtifactKey();
            project = facade.getMavenProject();
        }
        try {
            IManagedCache cache = (IManagedCache)this.maven.getPlexusContainer().lookup(MavenMetadataCache.class);
            cache.removeProject(pom, key);
        }
        catch (ComponentLookupException componentLookupException) {
        }
        catch (CoreException coreException) {}
        if (project != null) {
            ((MavenImpl)this.getMaven()).releaseExtensionsRealm(project);
        }
    }

    public void refresh(final MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        this.getMaven().execute(request.isOffline(), request.isForceDependencyUpdate(), new ICallable<Void>(){

            @Override
            public Void call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                ProjectRegistryManager.this.refresh(request.getPomFiles(), monitor);
                return null;
            }
        }, monitor);
    }

    public void refresh(Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectRegistryManager_task_refreshing, (int)100);
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        Job.getJobManager().beginRule((ISchedulingRule)rule, (IProgressMonitor)progress);
        try {
            this.syncRefreshThread = Thread.currentThread();
            MutableProjectRegistry newState = this.newMutableProjectRegistry();
            try {
                this.refresh(newState, pomFiles, (IProgressMonitor)progress.newChild(95));
                this.applyMutableProjectRegistry(newState, (IProgressMonitor)progress.newChild(5));
            }
            finally {
                newState.close();
            }
        }
        finally {
            this.syncRefreshThread = null;
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    void refresh(final MutableProjectRegistry newState, Collection<IFile> pomFiles, IProgressMonitor monitor) throws CoreException {
        log.debug("Refreshing: {}", pomFiles);
        final DependencyResolutionContext context = new DependencyResolutionContext(pomFiles);
        final HashSet installedArtifacts = new HashSet();
        ILocalRepositoryListener listener = new ILocalRepositoryListener(){

            @Override
            public void artifactInstalled(File repositoryBasedir, ArtifactKey baseArtifact, ArtifactKey artifact, File artifactFile) {
                if (artifactFile == null) {
                    return;
                }
                LinkedHashSet<IFile> refresh = new LinkedHashSet<IFile>();
                if (installedArtifacts.add(artifact)) {
                    refresh.addAll(newState.getDependents(MavenCapability.createMavenParent(artifact), true));
                    refresh.addAll(newState.getDependents(MavenCapability.createMavenArtifact(artifact), true));
                }
                if (installedArtifacts.add(baseArtifact)) {
                    refresh.addAll(newState.getDependents(MavenCapability.createMavenParent(baseArtifact), true));
                    refresh.addAll(newState.getDependents(MavenCapability.createMavenArtifact(baseArtifact), true));
                }
                if (!refresh.isEmpty()) {
                    log.debug("Automatic refresh. artifact={}/{}. projects={}", new Object[]{baseArtifact, artifact, refresh});
                    context.forcePomFiles(refresh);
                }
            }
        };
        this.maven.addLocalRepositoryListener(listener);
        try {
            this.refresh(newState, context, monitor);
        }
        finally {
            this.maven.removeLocalRepositoryListener(listener);
        }
        log.debug("Refreshed: {}", pomFiles);
    }

    private void refresh(final MutableProjectRegistry newState, final DependencyResolutionContext context, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<IFile> secondPhaseBacklog = new LinkedHashSet<IFile>();
        final HashMap<IFile, Set<Capability>> originalCapabilities = new HashMap<IFile, Set<Capability>>();
        final HashMap<IFile, Set<RequiredCapability>> originalRequirements = new HashMap<IFile, Set<RequiredCapability>>();
        while (!context.isEmpty()) {
            MavenCapability mavenParentCapability;
            MavenProjectFacade oldFacade;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (newState.isStale() || this.syncRefreshThread != null && this.syncRefreshThread != Thread.currentThread()) {
                throw new StaleMutableProjectRegistryException();
            }
            IFile pom = context.pop();
            monitor.subTask(NLS.bind((String)Messages.ProjectRegistryManager_task_project, (Object)pom.getProject().getName()));
            MavenProjectFacade newFacade = null;
            if (pom.isAccessible() && pom.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                oldFacade = newState.getProjectFacade(pom);
                this.flushCaches(pom, oldFacade);
                if (oldFacade != null) {
                    mavenParentCapability = MavenCapability.createMavenParent(oldFacade.getArtifactKey());
                    context.forcePomFiles(newState.getDependents(mavenParentCapability, true));
                }
                newFacade = this.readMavenProjectFacade(pom, context, newState, monitor);
            } else {
                oldFacade = newState.getProjectFacade(pom);
                if (oldFacade != null) {
                    mavenParentCapability = MavenCapability.createMavenParent(oldFacade.getArtifactKey());
                    context.forcePomFiles(newState.getDependents(mavenParentCapability, true));
                }
            }
            newState.setProject(pom, newFacade);
            if (newFacade != null) {
                MavenCapability mavenParentCapability2 = MavenCapability.createMavenParent(newFacade.getArtifactKey());
                context.forcePomFiles(newState.getDependents(mavenParentCapability2, true));
                LinkedHashSet<Capability> capabilities = new LinkedHashSet<Capability>();
                capabilities.add(mavenParentCapability2);
                capabilities.add(MavenCapability.createMavenArtifact(newFacade.getArtifactKey()));
                Set<Capability> oldCapabilities = newState.setCapabilities(pom, capabilities);
                if (!originalCapabilities.containsKey(pom)) {
                    originalCapabilities.put(pom, oldCapabilities);
                }
                LinkedHashSet<RequiredCapability> requirements = new LinkedHashSet<RequiredCapability>();
                DefaultMavenDependencyResolver.addParentRequirements(requirements, newFacade.getMavenProject());
                Set<RequiredCapability> oldRequirements = newState.setRequirements(pom, requirements);
                if (!originalRequirements.containsKey(pom)) {
                    originalRequirements.put(pom, oldRequirements);
                }
            }
            secondPhaseBacklog.add(pom);
        }
        context.forcePomFiles(secondPhaseBacklog);
        HashSet<IFile> secondPhaseProcessed = new HashSet<IFile>();
        while (!context.isEmpty()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (newState.isStale() || this.syncRefreshThread != null && this.syncRefreshThread != Thread.currentThread()) {
                throw new StaleMutableProjectRegistryException();
            }
            final IFile pom = context.pop();
            if (!secondPhaseProcessed.add(pom)) continue;
            MavenProjectFacade newFacade = null;
            if (pom.isAccessible() && pom.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
                newFacade = newState.getProjectFacade(pom);
            }
            if (newFacade != null) {
                newFacade = newFacade.getMavenProject() == null ? this.readMavenProjectFacade(pom, context, newState, monitor) : new MavenProjectFacade(newFacade);
            }
            if (newFacade != null) {
                final MavenProjectFacade _newFacade = newFacade;
                MavenProject mavenProject = newFacade.getMavenProject();
                ResolverConfiguration resolverConfiguration = _newFacade.getResolverConfiguration();
                ICallable<Void> callable = new ICallable<Void>(){

                    @Override
                    public Void call(IMavenExecutionContext executionContext, IProgressMonitor monitor) throws CoreException {
                        ProjectRegistryManager.this.refreshPhase2(newState, context, originalCapabilities, originalRequirements, pom, _newFacade, monitor);
                        return null;
                    }
                };
                this.createExecutionContext(newState, pom, resolverConfiguration).execute(mavenProject, callable, monitor);
            } else {
                this.refreshPhase2(newState, context, originalCapabilities, originalRequirements, pom, newFacade, monitor);
            }
            monitor.worked(1);
        }
    }

    void refreshPhase2(MutableProjectRegistry newState, DependencyResolutionContext context, Map<IFile, Set<Capability>> originalCapabilities, Map<IFile, Set<RequiredCapability>> originalRequirements, IFile pom, MavenProjectFacade newFacade, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<Capability> capabilities = null;
        HashSet requirements = null;
        if (newFacade != null) {
            monitor.subTask(NLS.bind((String)Messages.ProjectRegistryManager_task_project, (Object)newFacade.getProject().getName()));
            this.setupLifecycleMapping(newState, monitor, newFacade);
            capabilities = new LinkedHashSet<Capability>();
            requirements = new LinkedHashSet<RequiredCapability>();
            MavenCapability mavenParentCapability = MavenCapability.createMavenParent(newFacade.getArtifactKey());
            capabilities.add(MavenCapability.createMavenArtifact(newFacade.getArtifactKey()));
            capabilities.add(mavenParentCapability);
            DefaultMavenDependencyResolver.addParentRequirements(requirements, newFacade.getMavenProject());
            AbstractMavenDependencyResolver resolver = this.getMavenDependencyResolver(newFacade, monitor);
            resolver.setContextProjectRegistry(newState);
            try {
                resolver.resolveProjectDependencies(newFacade, this.maven.getExecutionContext().getExecutionRequest(), capabilities, requirements, monitor);
            }
            finally {
                resolver.setContextProjectRegistry(null);
            }
            newState.setProject(pom, newFacade);
            newFacade.setMavenProjectArtifacts();
        } else if (pom.isAccessible() && pom.getProject().hasNature("org.eclipse.m2e.core.maven2Nature")) {
            try {
                Parent parent;
                Model model = this.getMaven().readModel(pom.getLocation().toFile());
                if (model != null && model.getParent() != null && (parent = model.getParent()).getGroupId() != null && parent.getArtifactId() != null && parent.getVersion() != null) {
                    ArtifactKey parentKey = new ArtifactKey(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), null);
                    requirements = new HashSet();
                    requirements.add((RequiredCapability)MavenRequiredCapability.createMavenParent(parentKey));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Set<Capability> oldCapabilities = newState.setCapabilities(pom, capabilities);
        if (originalCapabilities.containsKey(pom)) {
            oldCapabilities = originalCapabilities.get(pom);
        }
        Set<Capability> changedCapabilities = ProjectRegistryManager.diff(oldCapabilities, capabilities);
        for (Capability capability : changedCapabilities) {
            context.forcePomFiles(newState.getDependents(capability, true));
        }
        Set<RequiredCapability> oldRequirements = newState.setRequirements(pom, requirements);
        if (originalRequirements.containsKey(pom)) {
            oldRequirements = originalRequirements.get(pom);
        }
        if (oldCapabilities != null && ProjectRegistryManager.hasDiff(oldRequirements, requirements)) {
            for (Capability capability : oldCapabilities) {
                context.forcePomFiles(newState.getDependents(capability.getVersionlessKey(), true));
            }
        }
    }

    private void setupLifecycleMapping(MutableProjectRegistry newState, IProgressMonitor monitor, MavenProjectFacade newFacade) throws CoreException {
        LifecycleMappingResult mappingResult = LifecycleMappingFactory.calculateLifecycleMapping(newFacade.getMavenProject(), newFacade.getMojoExecutions(), newFacade.getResolverConfiguration().getLifecycleMappingId(), monitor);
        newFacade.setLifecycleMappingId(mappingResult.getLifecycleMappingId());
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mojoExecutionMapping = mappingResult.getMojoExecutionMapping();
        if (mojoExecutionMapping != null) {
            this.detachMappingSources(mojoExecutionMapping);
        }
        newFacade.setMojoExecutionMapping(mojoExecutionMapping);
        newFacade.setSessionProperty(MavenProjectFacade.PROP_LIFECYCLE_MAPPING, mappingResult.getLifecycleMapping());
        newFacade.setSessionProperty(MavenProjectFacade.PROP_CONFIGURATORS, mappingResult.getProjectConfigurators());
        this.markerManager.deleteMarkers((IResource)newFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping");
        if (mappingResult.hasProblems()) {
            this.markerManager.addErrorMarkers((IResource)newFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.lifecycleMapping", mappingResult.getProblems());
        }
    }

    private void detachMappingSources(Map<MojoExecutionKey, List<IPluginExecutionMetadata>> mapping) {
        for (List<IPluginExecutionMetadata> executions : mapping.values()) {
            if (executions == null) continue;
            ListIterator<IPluginExecutionMetadata> iterator = executions.listIterator();
            while (iterator.hasNext()) {
                PluginExecutionMetadata execution = (PluginExecutionMetadata)iterator.next();
                execution = execution.clone();
                execution.setSource(null);
                iterator.set(execution);
            }
        }
    }

    static <T> Set<T> diff(Set<T> a, Set<T> b) {
        if (a == null || a.isEmpty()) {
            if (b == null || b.isEmpty()) {
                return Collections.emptySet();
            }
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        HashSet<T> result = new HashSet<T>();
        HashSet<T> t = new HashSet<T>(a);
        t.removeAll(b);
        result.addAll(t);
        t = new HashSet<T>(b);
        t.removeAll(a);
        result.addAll(t);
        return result;
    }

    static <T> boolean hasDiff(Set<T> a, Set<T> b) {
        if (a == null || a.isEmpty()) {
            return b != null && !b.isEmpty();
        }
        if (b == null || b.isEmpty()) {
            return true;
        }
        if (a.size() != b.size()) {
            return true;
        }
        Iterator<T> oldIter = a.iterator();
        Iterator<T> iter = b.iterator();
        while (oldIter.hasNext()) {
            T requirement;
            T oldRequirement = oldIter.next();
            if (oldRequirement.equals(requirement = iter.next())) continue;
            return true;
        }
        return false;
    }

    private AbstractMavenDependencyResolver getMavenDependencyResolver(MavenProjectFacade newFacade, IProgressMonitor monitor) throws CoreException {
        ILifecycleMapping lifecycleMapping = LifecycleMappingFactory.getLifecycleMapping(newFacade);
        if (lifecycleMapping instanceof ILifecycleMapping2) {
            AbstractMavenDependencyResolver resolver = ((ILifecycleMapping2)lifecycleMapping).getDependencyResolver(monitor);
            resolver.setManager(this);
            return resolver;
        }
        return new DefaultMavenDependencyResolver(this, this.markerManager);
    }

    private MavenProjectFacade readMavenProjectFacade(final IFile pom, DependencyResolutionContext context, MutableProjectRegistry state, IProgressMonitor monitor) throws CoreException {
        this.markerManager.deleteMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading");
        final ResolverConfiguration resolverConfiguration = ResolverConfigurationIO.readResolverConfiguration(pom.getProject());
        return this.execute(state, pom, resolverConfiguration, new ICallable<MavenProjectFacade>(){

            @Override
            public MavenProjectFacade call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                MavenProject mavenProject = null;
                MavenExecutionResult mavenResult = null;
                if (pom.isAccessible()) {
                    mavenResult = ProjectRegistryManager.this.getMaven().readMavenProject(pom.getLocation().toFile(), context.newProjectBuildingRequest());
                    mavenProject = mavenResult.getProject();
                }
                MarkerUtils.addEditorHintMarkers(ProjectRegistryManager.this.markerManager, pom, mavenProject, "org.eclipse.m2e.core.maven2Problem.pomloading");
                ProjectRegistryManager.this.markerManager.addMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading", mavenResult);
                if (mavenProject == null) {
                    return null;
                }
                ProjectRegistryManager.this.getMaven().detachFromSession(mavenProject);
                MavenSession mavenSession = context.getSession();
                MavenProject origCurrentProject = mavenSession.getCurrentProject();
                try {
                    MavenProjectFacade mavenProjectFacade;
                    mavenSession.setCurrentProject(mavenProject);
                    Map<String, List<MojoExecution>> executionPlans = ProjectRegistryManager.this.calculateExecutionPlans(pom, mavenProject, monitor);
                    MavenProjectFacade mavenProjectFacade2 = mavenProjectFacade = new MavenProjectFacade(ProjectRegistryManager.this, pom, mavenProject, executionPlans, resolverConfiguration);
                    return mavenProjectFacade2;
                }
                finally {
                    mavenSession.setCurrentProject(origCurrentProject);
                }
            }
        }, monitor);
    }

    Map<String, List<MojoExecution>> calculateExecutionPlans(IFile pom, MavenProject mavenProject, IProgressMonitor monitor) {
        LinkedHashMap<String, List<MojoExecution>> executionPlans = new LinkedHashMap<String, List<MojoExecution>>();
        executionPlans.put(LIFECYCLE_CLEAN, this.calculateExecutionPlan(pom, mavenProject, LIFECYCLE_CLEAN, monitor));
        executionPlans.put(LIFECYCLE_DEFAULT, this.calculateExecutionPlan(pom, mavenProject, LIFECYCLE_DEFAULT, monitor));
        executionPlans.put(LIFECYCLE_SITE, this.calculateExecutionPlan(pom, mavenProject, LIFECYCLE_SITE, monitor));
        return executionPlans;
    }

    private List<MojoExecution> calculateExecutionPlan(IFile pom, MavenProject mavenProject, String lifecycle, IProgressMonitor monitor) {
        List<MojoExecution> mojoExecutions = null;
        try {
            MavenExecutionPlan executionPlan = this.maven.calculateExecutionPlan(mavenProject, Arrays.asList(lifecycle), false, monitor);
            return executionPlan.getMojoExecutions();
        }
        catch (CoreException e) {
            this.markerManager.addErrorMarkers((IResource)pom, "org.eclipse.m2e.core.maven2Problem.pomloading", (Exception)((Object)e));
            return mojoExecutions;
        }
    }

    public IFile getModulePom(IFile pom, String moduleName) {
        return pom.getParent().getFile(new Path(moduleName).append("pom.xml"));
    }

    private Set<IFile> refreshWorkspaceModules(MutableProjectRegistry state, IFile pom, ArtifactKey mavenProject) {
        if (mavenProject == null) {
            return Collections.emptySet();
        }
        return state.removeWorkspaceModules(pom, mavenProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
        synchronized (set) {
            this.projectChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProjectChangedListener(IMavenProjectChangedListener listener) {
        if (listener == null) {
            return;
        }
        Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
        synchronized (set) {
            this.projectChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProjectChangeListeners(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        if (events.size() > 0) {
            MavenProjectChangedEvent[] eventsArray = events.toArray(new MavenProjectChangedEvent[events.size()]);
            ArrayList<IMavenProjectChangedListener> listeners = new ArrayList<IMavenProjectChangedListener>();
            Set<IMavenProjectChangedListener> set = this.projectChangeListeners;
            synchronized (set) {
                listeners.addAll(this.projectChangeListeners);
            }
            listeners.addAll(ExtensionReader.readProjectChangedEventListenerExtentions());
            for (IMavenProjectChangedListener listener : listeners) {
                listener.mavenProjectChanged(eventsArray, monitor);
            }
        }
    }

    public MavenProjectFacade getMavenProject(String groupId, String artifactId, String version) {
        return this.projectRegistry.getProjectFacade(groupId, artifactId, version);
    }

    MavenExecutionResult readProjectWithDependencies(IFile pomFile, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) {
        return this.readProjectWithDependencies(this.projectRegistry, pomFile, resolverConfiguration, monitor);
    }

    private MavenExecutionResult readProjectWithDependencies(IProjectRegistry state, final IFile pomFile, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) {
        try {
            return this.execute(state, pomFile, resolverConfiguration, new ICallable<MavenExecutionResult>(){

                @Override
                public MavenExecutionResult call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                    ProjectBuildingRequest configuration = context.newProjectBuildingRequest();
                    configuration.setResolveDependencies(true);
                    return ProjectRegistryManager.this.getMaven().readMavenProject(pomFile.getLocation().toFile(), configuration);
                }
            }, monitor);
        }
        catch (CoreException ex) {
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            result.addException((Throwable)ex);
            return result;
        }
    }

    public IMavenProjectFacade[] getProjects() {
        return this.projectRegistry.getProjects();
    }

    public IMavenProjectFacade getProject(IProject project) {
        return this.projectRegistry.getProjectFacade(this.getPom(project));
    }

    public MavenExecutionRequest createExecutionRequest(IFile pom, ResolverConfiguration resolverConfiguration, IProgressMonitor monitor) throws CoreException {
        MavenExecutionRequest request = this.getMaven().createExecutionRequest(monitor);
        this.configureExecutionRequest(request, this.projectRegistry, pom, resolverConfiguration);
        MavenExecutionContext.populateSystemProperties(request);
        return request;
    }

    MavenExecutionRequest configureExecutionRequest(MavenExecutionRequest request, IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration) throws CoreException {
        request.setPom(pom.getLocation().toFile());
        request.addActiveProfiles(resolverConfiguration.getActiveProfileList());
        request.addInactiveProfiles(resolverConfiguration.getInactiveProfileList());
        request.setLocalRepository(this.getMaven().getLocalRepository());
        request.setWorkspaceReader((WorkspaceReader)this.getWorkspaceReader(state, pom, resolverConfiguration));
        return request;
    }

    private EclipseWorkspaceArtifactRepository getWorkspaceReader(IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration) {
        Context context = new Context(state, resolverConfiguration, pom);
        EclipseWorkspaceArtifactRepository workspaceReader = new EclipseWorkspaceArtifactRepository(context);
        return workspaceReader;
    }

    public MavenArtifactRepository getWorkspaceLocalRepository() throws CoreException {
        ResolverConfiguration resolverConfiguration = new ResolverConfiguration();
        resolverConfiguration.setResolveWorkspaceProjects(true);
        EclipseWorkspaceArtifactRepository workspaceReader = this.getWorkspaceReader(this.projectRegistry, null, resolverConfiguration);
        DelegatingLocalArtifactRepository localRepo = new DelegatingLocalArtifactRepository(this.getMaven().getLocalRepository());
        localRepo.setIdeWorkspace((LocalArtifactRepository)workspaceReader);
        return localRepo;
    }

    MutableProjectRegistry newMutableProjectRegistry() {
        return new MutableProjectRegistry(this.projectRegistry);
    }

    void applyMutableProjectRegistry(MutableProjectRegistry newState, IProgressMonitor monitor) {
        List<MavenProjectChangedEvent> events = this.projectRegistry.apply(newState);
        this.notifyProjectChangeListeners(events, monitor);
    }

    public void writeWorkspaceState() {
        if (this.stateReader != null && this.projectRegistry != null) {
            this.stateReader.writeWorkspaceState(this.projectRegistry);
        }
    }

    IMaven getMaven() {
        return this.maven;
    }

    public MojoExecution setupMojoExecution(MavenProjectFacade projectFacade, MojoExecution mojoExecution, IProgressMonitor monitor) throws CoreException {
        return this.maven.setupMojoExecution(projectFacade.getMavenProject(), mojoExecution, monitor);
    }

    public Map<String, List<MojoExecution>> calculateExecutionPlans(final MavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        return this.execute(this.projectRegistry, projectFacade.getPom(), projectFacade.getResolverConfiguration(), new ICallable<Map<String, List<MojoExecution>>>(){

            @Override
            public Map<String, List<MojoExecution>> call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                return ProjectRegistryManager.this.calculateExecutionPlans(projectFacade.getPom(), projectFacade.getMavenProject(monitor), monitor);
            }
        }, monitor);
    }

    private <V> V execute(IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        return this.createExecutionContext(state, pom, resolverConfiguration).execute(callable, monitor);
    }

    private MavenExecutionContext createExecutionContext(IProjectRegistry state, IFile pom, ResolverConfiguration resolverConfiguration) throws CoreException {
        MavenExecutionContext context = this.maven.createExecutionContext();
        this.configureExecutionRequest(context.getExecutionRequest(), state, pom, resolverConfiguration);
        return context;
    }

    public MavenExecutionContext createExecutionContext(IFile pom, ResolverConfiguration resolverConfiguration) throws CoreException {
        return this.createExecutionContext(this.projectRegistry, pom, resolverConfiguration);
    }

    static class Context {
        final IProjectRegistry state;
        final ResolverConfiguration resolverConfiguration;
        final IFile pom;

        Context(IProjectRegistry state, ResolverConfiguration resolverConfiguration, IFile pom) {
            this.state = state;
            this.resolverConfiguration = resolverConfiguration;
            this.pom = pom;
        }
    }
}

