/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.internal.launch.IMavenLaunchParticipant;
import org.eclipse.m2e.internal.launch.LaunchingUtils;
import org.eclipse.m2e.internal.launch.MavenLaunchParticipantInfo;
import org.eclipse.m2e.internal.launch.MavenLaunchUtils;
import org.eclipse.m2e.internal.launch.MavenRuntimeLaunchSupport;
import org.eclipse.m2e.internal.launch.MavenSourceLocator;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchDelegate
extends JavaLaunchDelegate
implements MavenLaunchConstants {
    static final Logger log = LoggerFactory.getLogger(MavenLaunchDelegate.class);
    private static final String LAUNCHER_TYPE = "org.codehaus.classworlds.Launcher";
    private static final String LAUNCHER_TYPE3 = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private ILaunch launch;
    private IProgressMonitor monitor;
    private List<IMavenLaunchParticipant> participants;
    private String programArguments;
    private MavenRuntimeLaunchSupport launchSupport;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.monitor = monitor;
        this.participants = this.getParticipants(configuration, launch);
        this.programArguments = null;
        log.info("" + this.getWorkingDirectory(configuration));
        log.info(" mvn" + this.getProgramArguments(configuration));
        try {
            this.launchSupport = MavenRuntimeLaunchSupport.create(configuration, launch, monitor);
            if (launch.getSourceLocator() instanceof MavenSourceLocator) {
                MavenSourceLocator sourceLocator = (MavenSourceLocator)launch.getSourceLocator();
                for (IMavenLaunchParticipant participant : this.participants) {
                    List<ISourceLookupParticipant> sourceLookupParticipants = participant.getSourceLookupParticipants(configuration, launch, monitor);
                    if (sourceLookupParticipants == null || sourceLookupParticipants.isEmpty()) continue;
                    sourceLocator.addParticipants(sourceLookupParticipants.toArray(new ISourceLookupParticipant[sourceLookupParticipants.size()]));
                }
                sourceLocator.addParticipants(new ISourceLookupParticipant[]{new JavaSourceLookupParticipant()});
            } else {
                log.warn(NLS.bind((String)Messages.MavenLaynchDelegate_unsupported_source_locator, (Object)launch.getSourceLocator().getClass().getCanonicalName()));
            }
            super.launch(configuration, mode, launch, monitor);
        }
        finally {
            this.launch = null;
            this.monitor = null;
        }
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.launchSupport.decorateVMRunner(super.getVMRunner(configuration, mode));
    }

    public String getMainTypeName(ILaunchConfiguration configuration) {
        return this.launchSupport.getVersion().startsWith("3.0") ? LAUNCHER_TYPE3 : LAUNCHER_TYPE;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) {
        List<String> cp = this.launchSupport.getBootClasspath();
        return cp.toArray(new String[cp.size()]);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        if (this.programArguments == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getProperties(configuration));
            sb.append(" ").append(this.getPreferences(configuration));
            sb.append(" ").append(this.getGoals(configuration));
            for (IMavenLaunchParticipant participant : this.participants) {
                String programArguments = participant.getProgramArguments(configuration, this.launch, this.monitor);
                if (programArguments == null) continue;
                sb.append(" ").append(programArguments);
            }
            this.programArguments = sb.toString();
        }
        return this.programArguments;
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        MavenRuntimeLaunchSupport.VMArguments arguments = this.launchSupport.getVMArguments();
        arguments.append(super.getVMArguments(configuration));
        for (IMavenLaunchParticipant participant : this.participants) {
            arguments.append(participant.getVMArguments(configuration, this.launch, this.monitor));
        }
        return arguments.toString();
    }

    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("M2_GOALS", "");
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return false;
    }

    private String getProperties(ILaunchConfiguration configuration) {
        String msg;
        StringBuffer sb = new StringBuffer();
        try {
            List properties = configuration.getAttribute("M2_PROPERTIES", Collections.EMPTY_LIST);
            for (String property : properties) {
                int n = property.indexOf(61);
                String name = property;
                String value = null;
                if (n > -1) {
                    name = property.substring(0, n);
                    if (n > 1) {
                        value = LaunchingUtils.substituteVar(property.substring(n + 1));
                    }
                }
                sb.append(" -D").append(name);
                if (value == null) continue;
                sb.append('=').append(MavenLaunchUtils.quote(value));
            }
        }
        catch (CoreException e) {
            msg = "Exception while getting configuration attribute M2_PROPERTIES";
            log.error(msg, (Throwable)e);
        }
        try {
            String profiles = configuration.getAttribute("M2_PROFILES", null);
            if (profiles != null && profiles.trim().length() > 0) {
                sb.append(" -P").append(profiles.replaceAll("\\s+", ","));
            }
        }
        catch (CoreException ex) {
            msg = "Exception while getting configuration attribute M2_PROFILES";
            log.error(msg, (Throwable)ex);
        }
        return sb.toString();
    }

    private String getPreferences(ILaunchConfiguration configuration) throws CoreException {
        String settings;
        int threads;
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        StringBuffer sb = new StringBuffer();
        sb.append(" -B");
        if (configuration.getAttribute("M2_DEBUG_OUTPUT", mavenConfiguration.isDebugOutput())) {
            sb.append(" -X").append(" -e");
        }
        if (configuration.getAttribute("M2_OFFLINE", mavenConfiguration.isOffline())) {
            sb.append(" -o");
        }
        if (configuration.getAttribute("M2_UPDATE_SNAPSHOTS", false)) {
            sb.append(" -U");
        }
        if (configuration.getAttribute("M2_NON_RECURSIVE", false)) {
            sb.append(" -N");
        }
        if (configuration.getAttribute("M2_SKIP_TESTS", false)) {
            sb.append(" -Dmaven.test.skip=true");
        }
        if ((threads = configuration.getAttribute("M2_THREADS", 1)) > 1) {
            sb.append(" --threads ").append(threads);
        }
        if (!((settings = configuration.getAttribute("M2_USER_SETTINGS", null)) != null && settings.trim().length() > 0 || (settings = mavenConfiguration.getUserSettingsFile()) == null || settings.trim().length() <= 0 || new File(settings.trim()).exists())) {
            settings = null;
        }
        if (settings != null && settings.trim().length() > 0) {
            sb.append(" -s ").append(MavenLaunchUtils.quote(settings));
        }
        return sb.toString();
    }

    static void removeTempFiles(ILaunch launch) {
        MavenRuntimeLaunchSupport.removeTempFiles(launch);
    }

    private List<IMavenLaunchParticipant> getParticipants(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        Set disabledExtensions = configuration.getAttribute("M2_DISABLED_EXTENSIONS", Collections.EMPTY_SET);
        ArrayList<IMavenLaunchParticipant> participants = new ArrayList<IMavenLaunchParticipant>();
        for (MavenLaunchParticipantInfo info : MavenLaunchParticipantInfo.readParticipantsInfo()) {
            if (disabledExtensions.contains(info.getId()) || !info.getModes().contains(launch.getLaunchMode())) continue;
            try {
                participants.add(info.createParticipant());
            }
            catch (CoreException e) {
                log.debug("Problem with external extension point", (Throwable)e);
            }
        }
        return participants;
    }
}

