/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessageEx;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.BrowseInterpretedTransformationDialog;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.IUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.MdaLaunchTab;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.OptionalFileGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.project.QvtEngine;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ITransformationMaker;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.TransformationSignatureLaunchControl;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.QvtCompiledTransformationLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class QvtLauncherTab
extends MdaLaunchTab {
    private final ModifyListener QVT_FILE_MODIFY_LISTENER = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            QvtLauncherTab.this.validateQvtFile();
            QvtLauncherTab.this.myTransfSignatureControl.setTransformation(QvtLauncherTab.this.myTransformation, QvtLauncherTab.this.myUriListeners);
            QvtLauncherTab.this.myTraceNameNonChanged = QvtLauncherTab.this.myTraceFile.getText().equals(QvtLauncherTab.this.getTraceFileName());
            QvtLauncherTab.this.updateLaunchConfigurationDialog();
        }
    };
    private final ISetMessage SET_MESSAGE = new ISetMessageEx(){

        public void setErrorMessage(String message) {
            QvtLauncherTab.this.setErrorMessage(message);
            QvtLauncherTab.this.getLaunchConfigurationDialog().updateMessage();
        }

        public void setMessage(String message) {
            QvtLauncherTab.this.setMessage(message);
            QvtLauncherTab.this.getLaunchConfigurationDialog().updateMessage();
        }

        public void setWarningMessage(String message) {
            QvtLauncherTab.this.setWarningMessage(message);
            QvtLauncherTab.this.getLaunchConfigurationDialog().updateMessage();
        }
    };
    private final ITransformationMaker myTransformationMaker;
    private Text myQvtFile;
    private QvtTransformation myTransformation;
    private OptionalFileGroup myTraceFile;
    private boolean myTraceNameNonChanged;
    private TransformationSignatureLaunchControl myTransfSignatureControl;
    private final List<IUriGroup.IModifyListener> myUriListeners;

    public QvtLauncherTab(ITransformationMaker transformationMaker, ResourceSet validationRS) {
        this.myTransformationMaker = transformationMaker;
        this.myUriListeners = new ArrayList<IUriGroup.IModifyListener>(1);
        this.myUriListeners.add(new IUriGroup.IModifyListener(){

            public void modified() {
                QvtLauncherTab.this.initTraceFileText();
                QvtLauncherTab.this.updateLaunchConfigurationDialog();
            }

            public void performValidation(boolean isLightweight) {
                QvtLauncherTab.this.validateTab(isLightweight ? QvtValidator.ValidationType.LIGHTWEIGHT_VALIDATION : QvtValidator.ValidationType.FULL_VALIDATION);
            }
        });
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml._transformation");
    }

    public void dispose() {
        super.dispose();
        try {
            if (this.myTransformation != null) {
                this.myTransformation.cleanup();
            }
        }
        catch (MdaException mdaException) {
            // empty catch block
        }
    }

    protected void createTransformationSection(Composite parent) {
        TransformationControls.createLabel((Composite)parent, (String)Messages.QvtLauncherTab_ModuleLabel, (int)2);
        this.myQvtFile = TransformationControls.createText((Composite)parent, (int)1);
        this.myQvtFile.addModifyListener(this.QVT_FILE_MODIFY_LISTENER);
        Button button = TransformationControls.createButton((Composite)parent, (String)Messages.QvtLauncherTab_BrowseButtonLabel);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI selectedUri;
                UniSelectTransformationControl.IResourceFilter resourceFilter = new UniSelectTransformationControl.IResourceFilter(){

                    public boolean accept(IResource resource) {
                        return resource instanceof IFile && "qvto".equalsIgnoreCase(resource.getFileExtension());
                    }
                };
                BrowseInterpretedTransformationDialog.ISelectionListener selectionListener = new BrowseInterpretedTransformationDialog.ISelectionListener(){

                    public IStatus selectionChanged(URI selectedUri) {
                        String transfName = "";
                        try {
                            if (selectedUri == null) {
                                return TransformationControls.makeStatus((int)4, (String)Messages.QvtLauncherTab_NoTransformationModule);
                            }
                            QvtInterpretedTransformation transformation = new QvtInterpretedTransformation(TransformationUtil.getQvtModule((URI)selectedUri));
                            List parameters = transformation.getParameters();
                            if (parameters.isEmpty()) {
                                return TransformationControls.makeStatus((int)4, (String)Messages.QvtLauncherTab_EmptyTransformation);
                            }
                            transfName = transformation.getModuleName();
                        }
                        catch (Exception e) {
                            return TransformationControls.makeStatus((int)4, (String)e.getMessage());
                        }
                        return TransformationControls.makeStatus((int)0, (String)NLS.bind((String)Messages.QvtLauncherTab_TransformationSelected, (Object)transfName));
                    }
                };
                BrowseInterpretedTransformationDialog dialog = new BrowseInterpretedTransformationDialog(QvtLauncherTab.this.getShell(), resourceFilter, (ILabelProvider)new QvtCompiledTransformationLabelProvider(), (TransformationRegistry)QvtTransformationRegistry.getInstance(), QvtLauncherTab.this.myQvtFile.getText(), selectionListener);
                dialog.create();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.m2m.qvt.oml._transformation");
                if (dialog.open() == 0 && (selectedUri = dialog.getSelectedUri()) != null) {
                    QvtLauncherTab.this.myQvtFile.setText(selectedUri.toString());
                }
            }
        });
        this.myTraceFile = new OptionalFileGroup(parent, Messages.QvtLauncherTab_TraceFile);
        this.myTraceFile.addModifyListener(new OptionalFileGroup.IModifyListener(){

            public void modified() {
                QvtLauncherTab.this.myTraceNameNonChanged = QvtLauncherTab.this.myTraceFile.getText().equals(QvtLauncherTab.this.getTraceFileName());
                QvtLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        TransformationControls.createLabel((Composite)parent, (String)Messages.QvtLauncherTab_ParametersLabel, (int)2);
        this.myTransfSignatureControl = new TransformationSignatureLaunchControl(parent, 2048);
    }

    private void initTraceFileText() {
        if (this.myTraceNameNonChanged || this.myTraceFile.getText().length() == 0) {
            String traceFileName = this.getTraceFileName();
            this.myTraceFile.setText(traceFileName);
            this.myTraceFile.setUseFileFlag(traceFileName != null);
            if (traceFileName != null) {
                IPath path = Path.fromOSString((String)traceFileName);
                this.myTraceFile.update(path.lastSegment().replaceAll(".qvtotrace", ""), "qvtotrace");
            }
        }
    }

    private String getTraceFileName() {
        URI targetUri = URI.createURI((String)this.myTransfSignatureControl.getTraceName());
        return QvtLaunchUtil.getTraceFileName((URI)targetUri);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IFile file = QvtLauncherTab.getFileContext();
        if (file == null) {
            return;
        }
        try {
            Module module;
            ImperativeOperation mainOperation;
            URI uri = URIUtils.getResourceURI((IResource)file);
            UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getFactory((Object)file).findUnit(uri);
            if (unit == null) {
                return;
            }
            CompiledUnit compiledUnit = QvtEngine.getInstance((IResource)file).compileUnit(unit, null);
            if (compiledUnit != null && compiledUnit.getModules().size() == 1 && (mainOperation = QvtOperationalParserUtil.getMainOperation((Module)(module = (Module)compiledUnit.getModules().get(0)))) != null) {
                this.initializeName(configuration, compiledUnit.getName());
                URI transfUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
                configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", transfUri.toString());
            }
        }
        catch (MdaException e) {
            Logger.getLogger().log(Logger.INFO, e.getMessage(), e);
        }
    }

    private void initializeName(ILaunchConfigurationWorkingCopy config, String name) {
        if (name == null) {
            name = "";
        }
        if (name.length() > 0) {
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.myQvtFile.setText(configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", ""));
        }
        catch (CoreException e) {
            this.myQvtFile.setText("");
        }
        try {
            this.myTransfSignatureControl.initializeFrom(configuration);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.myTraceFile.setText(configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", ""));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.myTraceFile.setUseFileFlag(configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", this.myQvtFile.getText());
        this.myTransfSignatureControl.performApply(configuration);
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", this.myTraceFile.getText());
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", this.myTraceFile.getUseFileFlag());
    }

    public boolean isValid(ILaunchConfiguration unused) {
        return this.validateTab(QvtValidator.ValidationType.LIGHTWEIGHT_VALIDATION);
    }

    private boolean validateTab(QvtValidator.ValidationType validationType) {
        String moduleName;
        if (this.myTransformation == null) {
            return false;
        }
        this.setMessage(null);
        this.setWarningMessage(null);
        this.setErrorMessage(null);
        try {
            moduleName = this.myTransformation.getModuleName();
        }
        catch (MdaException e) {
            IStatus status = StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)((Object)e));
            return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
        }
        if (this.myTraceFile.getText().length() == 0) {
            this.myTraceFile.update(moduleName, "qvtotrace");
        }
        IStatus status = this.myTransfSignatureControl.validate(moduleName, this.getShell(), this.myTraceFile.getText(), this.myTraceFile.getUseFileFlag(), validationType);
        return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
    }

    private boolean validateQvtFile() {
        String fileName;
        if (this.myTransformation != null) {
            try {
                this.myTransformation.cleanup();
            }
            catch (MdaException mdaException) {
                // empty catch block
            }
            this.myTransformation = null;
        }
        if ((fileName = this.myQvtFile.getText()) == null || fileName.length() == 0) {
            this.setErrorMessage(NLS.bind((String)Messages.QvtLauncherTab_NoTransformationModule, null));
            return false;
        }
        URI uri = EmfUtil.makeUri((String)fileName);
        if (uri == null) {
            this.setErrorMessage(NLS.bind((String)Messages.QvtLauncherTab_InvalidTransformationUri, (Object)fileName));
            return false;
        }
        try {
            this.myTransformation = this.myTransformationMaker.makeTransformation(fileName);
        }
        catch (MdaException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }
}

