/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtTransitionReachedException;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QvtIterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> myEvalVisitor;
    private EvaluationEnvironment<C, O, P, CLS, E> myEvalEnv;
    private boolean done = false;

    protected QvtIterationTemplate(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v) {
        this.myEvalVisitor = v;
        this.myEvalEnv = v.getEvaluationEnvironment();
    }

    public EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEvaluationVisitor() {
        return this.myEvalVisitor;
    }

    public EvaluationEnvironment<C, O, P, CLS, E> getEvalEnvironment() {
        return this.myEvalEnv;
    }

    public final void setDone(boolean done) {
        this.done = done;
    }

    public final boolean isDone() {
        return this.done;
    }

    protected abstract Object evaluateResultTemplate(List<Variable<C, PM>> var1, Variable<EClassifier, EParameter> var2, String var3, OCLExpression<C> var4, OCLExpression<C> var5, boolean var6);

    public Object evaluate(Collection<?> coll, List<Variable<C, PM>> iterators, Variable<EClassifier, EParameter> target, OCLExpression<C> condition, OCLExpression<C> body, String resultName, boolean isOne) {
        if (coll.isEmpty()) {
            return this.myEvalEnv.getValueOf(resultName);
        }
        int numIters = iterators.size();
        Iterator[] javaIters = new Iterator[numIters];
        this.initializeIterators(iterators, javaIters, coll);
        while (true) {
            int curr;
            Object resultVal = null;
            boolean isUpdateResultVal = true;
            try {
                resultVal = this.evaluateResultTemplate(iterators, target, resultName, condition, body, isOne);
            }
            catch (QvtTransitionReachedException ex) {
                if (ex.getReason() == 1) {
                    this.setDone(true);
                }
                ex.getReason();
                isUpdateResultVal = false;
            }
            if (isUpdateResultVal) {
                this.myEvalEnv.replace(resultName, resultVal);
            }
            if (!this.moreToGo(curr = this.getNextUnfinishedIterator(javaIters), numIters)) {
                this.removeIterators(iterators);
                this.removeTarget(target);
                return this.myEvalEnv.getValueOf(resultName);
            }
            this.advanceIterators(iterators, javaIters, coll, curr);
        }
    }

    protected void initializeIterators(List<Variable<C, PM>> iterators, Iterator<?>[] javaIters, Collection<?> c) {
        int i = 0;
        int n = javaIters.length;
        while (i < n) {
            javaIters[i] = c.iterator();
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = (String)iterDecl.accept(this.myEvalVisitor);
            Object value = javaIters[i].next();
            this.myEvalEnv.replace(iterName, value);
            ++i;
        }
    }

    protected int getNextUnfinishedIterator(Iterator<?>[] javaIters) {
        int numIters = javaIters.length;
        int curr = 0;
        while (curr < numIters) {
            if (javaIters[curr].hasNext()) break;
            ++curr;
        }
        return curr;
    }

    protected void advanceIterators(List<Variable<C, PM>> iterators, Iterator<?>[] javaIters, Collection<?> c, int curr) {
        int i = 0;
        int n = curr;
        while (i <= n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = iterDecl.getName();
            if (i != curr) {
                javaIters[i] = c.iterator();
            }
            Object value = javaIters[i].next();
            this.myEvalEnv.replace(iterName, value);
            ++i;
        }
    }

    protected void removeIterators(List<Variable<C, PM>> iterators) {
        int i = 0;
        int n = iterators.size();
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = iterDecl.getName();
            this.myEvalEnv.remove(iterName);
            ++i;
        }
    }

    protected boolean moreToGo(int curr, int numIters) {
        if (this.done) {
            return false;
        }
        return curr < numIters;
    }

    protected void advanceTarget(Variable<EClassifier, EParameter> target, Object bodyVal) {
        if (target != null) {
            String varName = target.getName();
            this.myEvalEnv.replace(varName, bodyVal);
        }
    }

    protected void removeTarget(Variable<EClassifier, EParameter> target) {
        if (target != null) {
            String varName = target.getName();
            this.myEvalEnv.remove(varName);
        }
    }

    protected OCLStandardLibrary<C> getOCLStandardLibrary() {
        return this.myEvalVisitor.getEnvironment().getOCLStandardLibrary();
    }

    protected Object getInvalid() {
        return this.getOCLStandardLibrary().getInvalid();
    }
}

