/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ResourceTestUtil {
    public static void deleteProject(IProject project) throws CoreException {
        if (project.exists() && !project.isOpen()) {
            project.open(null);
        }
        ResourceTestUtil.deleteResource((IResource)project);
    }

    public static void deleteResource(IResource resource) throws CoreException {
        CoreException lastException = null;
        try {
            resource.delete(true, null);
        }
        catch (CoreException e) {
            lastException = e;
            System.out.println("(CoreException): " + e.getMessage() + ", resource " + resource.getFullPath());
        }
        catch (IllegalArgumentException iae) {
            System.out.println("(IllegalArgumentException): " + iae.getMessage() + ", resource " + resource.getFullPath());
        }
        int retryCount = 60;
        while (resource.isAccessible() && --retryCount >= 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                lastException = e;
                System.out.println("(CoreException) Retry " + retryCount + ": " + e.getMessage() + ", resource " + resource.getFullPath());
            }
            catch (IllegalArgumentException iae) {
                System.out.println("(IllegalArgumentException) Retry " + retryCount + ": " + iae.getMessage() + ", resource " + resource.getFullPath());
            }
        }
        if (!resource.isAccessible()) {
            return;
        }
        System.err.println("Failed to delete " + resource.getFullPath());
        if (lastException != null) {
            throw lastException;
        }
    }
}

