/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.AuthType;
import com.google.gerrit.reviewdb.PatchSetApproval;
import com.google.gerrit.reviewdb.Project;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gwtjsonrpc.server.JsonServlet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;

public class JSonSupport {
    private Gson gson;

    public JSonSupport() {
        TypeToken<Map<ApprovalCategory.Id, PatchSetApproval>> approvalMapType = new TypeToken<Map<ApprovalCategory.Id, PatchSetApproval>>(){};
        ExclusionStrategy exclustionStrategy = new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                if (f.getDeclaredClass() == List.class && f.getName().equals("commentLinks") && f.getDeclaringClass() == GerritConfig.class) {
                    return true;
                }
                if (f.getDeclaredClass() == Map.class) {
                    f.getName().equals("given");
                }
                return f.getDeclaringClass() == Project.class && f.getName().equals("submitType");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        };
        this.gson = JsonServlet.defaultGsonBuilder().registerTypeAdapter(JSonResponse.class, (Object)new JSonResponseDeserializer()).registerTypeAdapter(Edit.class, (Object)new JsonDeserializer<Edit>(){

            public Edit deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray array;
                if (json.isJsonArray() && (array = json.getAsJsonArray()).size() == 4) {
                    return new Edit(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt(), array.get(3).getAsInt());
                }
                return new Edit(0, 0);
            }
        }).registerTypeAdapter(AuthType.class, (Object)new JsonDeserializer<AuthType>(){

            public AuthType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                String jsonString = json.getAsString();
                if (jsonString != null) {
                    try {
                        return AuthType.valueOf((String)jsonString);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                return null;
            }
        }).registerTypeAdapter(approvalMapType.getType(), (Object)new JsonDeserializer<Map<ApprovalCategory.Id, PatchSetApproval>>(){

            public Map<ApprovalCategory.Id, PatchSetApproval> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                HashMap<ApprovalCategory.Id, PatchSetApproval> map = new HashMap<ApprovalCategory.Id, PatchSetApproval>();
                if (json.isJsonArray()) {
                    JsonArray array = json.getAsJsonArray();
                    Iterator it = array.iterator();
                    while (it.hasNext()) {
                        JsonElement element = (JsonElement)it.next();
                        ApprovalCategory.Id key = (ApprovalCategory.Id)context.deserialize(element, ApprovalCategory.Id.class);
                        if (key.get() != null) {
                            element = (JsonElement)it.next();
                        }
                        PatchSetApproval value = (PatchSetApproval)context.deserialize(element, PatchSetApproval.class);
                        if (key.get() == null) {
                            key = value.getCategoryId();
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }
        }).setExclusionStrategies(new ExclusionStrategy[]{exclustionStrategy}).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    String createRequest(int id, String xsrfKey, String methodName, Collection<Object> args) {
        JsonRequest msg = new JsonRequest();
        msg.method = methodName;
        if (args != null) {
            for (Object arg : args) {
                msg.params.add(arg);
            }
        }
        msg.id = id;
        msg.xsrfKey = xsrfKey;
        return this.gson.toJson((Object)msg, msg.getClass());
    }

    <T> T parseJsonResponse(String responseMessage, Type resultType) throws GerritException {
        JSonResponse response = (JSonResponse)this.parseResponse(responseMessage, (Type)((Object)JSonResponse.class));
        if (response.error != null) {
            JSonError error = (JSonError)this.gson.fromJson(response.error, JSonError.class);
            throw new GerritException(error.message, error.code);
        }
        return (T)this.gson.fromJson(response.result, resultType);
    }

    public <T> T parseResponse(String responseMessage, Type resultType) {
        Assert.isLegal((responseMessage != null ? 1 : 0) != 0);
        Assert.isLegal((!responseMessage.isEmpty() ? 1 : 0) != 0);
        if (responseMessage.startsWith(")]}'\n")) {
            responseMessage = responseMessage.substring(5);
        }
        return (T)this.gson.fromJson(responseMessage, resultType);
    }

    static class JSonError {
        int code;
        String message;

        JSonError() {
        }
    }

    static class JSonResponse {
        JsonElement error;
        int id;
        String jsonrpc;
        JsonElement result;

        JSonResponse() {
        }
    }

    private class JSonResponseDeserializer
    implements JsonDeserializer<JSonResponse> {
        private JSonResponseDeserializer() {
        }

        public JSonResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            JSonResponse response = new JSonResponse();
            response.jsonrpc = object.get("jsonrpc").getAsString();
            response.id = object.get("id").getAsInt();
            response.result = object.get("result");
            response.error = object.get("error");
            return response;
        }
    }

    static class JsonRequest {
        int id;
        final String jsonrpc = "2.0";
        String method;
        final List<Object> params = new ArrayList<Object>();
        String xsrfKey;

        JsonRequest() {
        }
    }
}

