/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.HashMap;
import java.util.Map;

public class PatchSetContent {
    private final PatchSet base;
    private PatchSet target;
    private PatchSetDetail targetDetail;
    Map<Patch.Key, PatchScript> patchScriptByPatchKey;

    public PatchSetContent(PatchSet base, PatchSetDetail targetDetail) {
        this.base = base;
        this.targetDetail = targetDetail;
        this.patchScriptByPatchKey = new HashMap<Patch.Key, PatchScript>();
    }

    public PatchSetContent(PatchSet base, PatchSet target) {
        this.base = base;
        this.target = target;
        this.patchScriptByPatchKey = new HashMap<Patch.Key, PatchScript>();
    }

    public PatchSet getBase() {
        return this.base;
    }

    public PatchSet getTarget() {
        if (this.targetDetail != null) {
            return this.targetDetail.getPatchSet();
        }
        return this.target;
    }

    public PatchSetDetail getTargetDetail() {
        return this.targetDetail;
    }

    public void setTargetDetail(PatchSetDetail targetDetail) {
        this.targetDetail = targetDetail;
    }

    void putPatchScriptByPatchKey(Patch.Key key, PatchScript script) {
        this.patchScriptByPatchKey.put(key, script);
    }

    public PatchScript getPatchScript(Patch.Key key) {
        return this.patchScriptByPatchKey.get(key);
    }

    public String getId() {
        String id = "";
        if (this.getBase() != null) {
            id = String.valueOf(id) + this.getBase().getId() + "-";
        }
        if (this.getTarget() != null) {
            id = String.valueOf(id) + this.getTarget().getId();
        }
        return id;
    }
}

