/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.reviews.core.model.IApprovalType;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.eclipse.mylyn.reviews.core.model.IRequirementEntry;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewerEntry;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.model.RequirementStatus;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewSection;
import org.eclipse.mylyn.reviews.ui.spi.factories.AbstractUiFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class ReviewDetailSection
extends AbstractReviewSection {
    public ReviewDetailSection() {
        this.setPartName("Review");
    }

    @Override
    protected Control createContent(FormToolkit toolkit, Composite parent) {
        Control content = super.createContent(toolkit, parent);
        this.createReviewersSubSection(this.composite);
        this.createDependenciesSubSection(toolkit, this.composite, "Depends On", this.getReview().getParents());
        this.createDependenciesSubSection(toolkit, this.composite, "Needed By", this.getReview().getChildren());
        return content;
    }

    /*
     * WARNING - void declaration
     */
    protected void createReviewersSubSection(Composite parent) {
        if (this.getReview().getReviewerApprovals().isEmpty() && !this.canAddReviewers()) {
            return;
        }
        int style = 8274;
        Section subSection = this.toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setTitleBarForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        subSection.setText("Reviewers");
        Composite composite = this.toolkit.createComposite((Composite)subSection);
        List approvalTypes = this.getModelRepository().getApprovalTypes();
        ArrayList<IApprovalType> approvalTypesWithLabel = new ArrayList<IApprovalType>(approvalTypes.size());
        for (IApprovalType approvalType : approvalTypes) {
            if (approvalType.getKey().equals(approvalType.getName())) continue;
            approvalTypesWithLabel.add(approvalType);
        }
        int numColumns = approvalTypesWithLabel.size() + 1;
        GridLayoutFactory.fillDefaults().numColumns(numColumns).extendedMargins(0, 0, 0, 5).equalWidth(true).spacing(4, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        if (!approvalTypesWithLabel.isEmpty()) {
            void var11_18;
            StringBuilder names = new StringBuilder();
            Label headerLabel = new Label(composite, 0);
            headerLabel.setText(" ");
            StringBuilder needs = new StringBuilder();
            for (IApprovalType iApprovalType : approvalTypesWithLabel) {
                IRequirementEntry requirementEntry = (IRequirementEntry)this.getReview().getRequirements().get(iApprovalType);
                Composite headerContainer = new Composite(composite, 0);
                headerContainer.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo(headerContainer);
                GridDataFactory.fillDefaults().align(0x1000000, 4).applyTo((Control)headerContainer);
                CLabel approvalHeaderLabel = new CLabel(headerContainer, 0);
                approvalHeaderLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                approvalHeaderLabel.setText(iApprovalType.getName());
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)approvalHeaderLabel);
                RequirementStatus status = null;
                if (requirementEntry != null) {
                    status = requirementEntry.getStatus();
                    switch (status) {
                        case SATISFIED: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.APPROVED));
                            break;
                        }
                        case NOT_SATISFIED: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.UNKNOWN));
                            break;
                        }
                        case REJECTED: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.REJECTED));
                            break;
                        }
                        default: {
                            approvalHeaderLabel.setImage(CommonImages.getImage((ImageDescriptor)ReviewsImages.BLANK));
                        }
                    }
                }
                if (status == null || status != RequirementStatus.UNKNOWN && status != RequirementStatus.REJECTED) continue;
                if (needs.length() > 0) {
                    needs.append(", ");
                }
                needs.append(iApprovalType.getName());
            }
            for (Map.Entry entry : this.getReview().getReviewerApprovals().entrySet()) {
                Label reviewerRowLabel = new Label(composite, 0);
                reviewerRowLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                reviewerRowLabel.setText(((IUser)entry.getKey()).getDisplayName());
                for (IApprovalType approvalType : approvalTypesWithLabel) {
                    Integer value = (Integer)((IReviewerEntry)entry.getValue()).getApprovals().get(approvalType);
                    Label approvalValueLabel = new Label(composite, 0);
                    GridDataFactory.fillDefaults().align(0x1000000, 4).applyTo((Control)approvalValueLabel);
                    String rankingText = " ";
                    if (value != null && value != 0) {
                        if (value > 0) {
                            rankingText = String.valueOf(rankingText) + "+";
                            approvalValueLabel.setForeground(Display.getCurrent().getSystemColor(6));
                        } else if (value < 0) {
                            approvalValueLabel.setForeground(Display.getCurrent().getSystemColor(3));
                        }
                        rankingText = String.valueOf(rankingText) + value;
                        approvalValueLabel.setToolTipText(value + "  " + approvalType.getName());
                    }
                    approvalValueLabel.setText(rankingText);
                }
                if (names.length() > 0) {
                    names.append(", ");
                }
                names.append(((IUser)entry.getKey()).getDisplayName());
            }
            String string = names.toString();
            if (needs.length() > 0) {
                String string2 = String.valueOf(string) + " (needs " + needs.toString() + ")";
            }
            if (var11_18.length() > 0) {
                this.addTextClient(this.toolkit, subSection, (String)var11_18);
            }
        }
        if (this.getUiFactoryProvider() != null) {
            Composite actionComposite = this.getUiFactoryProvider().createControls(this, composite, this.getToolkit(), this.getReview());
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)actionComposite);
        }
    }

    protected boolean canAddReviewers() {
        return true;
    }

    protected void createDependenciesSubSection(FormToolkit toolkit, Composite parent, String title, List<IChange> changes) {
        if (changes.isEmpty()) {
            return;
        }
        int style = 18;
        Section subSection = toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setTitleBarForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        subSection.setText(title);
        Composite composite = toolkit.createComposite((Composite)subSection);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        for (final IChange change : changes) {
            Link link = new Link(composite, 0);
            String changeStatus = change.getState() != null ? NLS.bind((String)" ({0})", (Object)String.valueOf(change.getState().getName())) : " ";
            String ownerName = change.getOwner().getDisplayName();
            link.setText(NLS.bind((String)"<a>{0}</a>: {1} {3} by {2}", (Object[])new String[]{StringUtils.left((String)change.getKey(), (int)9), change.getSubject(), ownerName, changeStatus}));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TasksUiUtil.openTask((TaskRepository)ReviewDetailSection.this.getTaskEditorPage().getTaskRepository(), (String)String.valueOf(change.getId()));
                }
            });
        }
    }

    protected abstract AbstractUiFactoryProvider<IReview> getUiFactoryProvider();

    protected boolean shouldExpandOnCreate() {
        return true;
    }
}

