/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.net4j.util.properties.IPropertyProvider;
import org.eclipse.net4j.util.properties.Property;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertySource<RECEIVER>
implements IPropertySource {
    private List<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
    private RECEIVER receiver;

    public DefaultPropertySource(RECEIVER receiver) {
        this.receiver = receiver;
    }

    public DefaultPropertySource(RECEIVER object, IPropertyProvider<RECEIVER> provider) {
        this(object);
        this.addDescriptors(provider);
    }

    public RECEIVER getReceiver() {
        return this.receiver;
    }

    public PropertyDescriptor addDescriptor(String category, Object id, String displayName, String description) {
        PropertyDescriptor descriptor = new PropertyDescriptor(id, displayName);
        descriptor.setCategory(category);
        descriptor.setDescription(description);
        this.descriptors.add((IPropertyDescriptor)descriptor);
        return descriptor;
    }

    public void addDescriptors(IPropertyProvider<RECEIVER> provider) {
        for (Property property : provider.getProperties()) {
            if (property.getLabel() == null) continue;
            this.descriptors.add(new DelegatingPropertyDescriptor(property));
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors.toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    public IPropertyDescriptor getPropertyDescriptor(Object id) {
        IPropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
        int i = 0;
        while (i < propertyDescriptors.length) {
            IPropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (propertyDescriptor.getId().equals(id)) {
                return propertyDescriptor;
            }
            ++i;
        }
        return null;
    }

    public Property<RECEIVER> getProperty(Object id) {
        IPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(id);
        if (propertyDescriptor instanceof DelegatingPropertyDescriptor) {
            DelegatingPropertyDescriptor delegating = (DelegatingPropertyDescriptor)propertyDescriptor;
            return delegating.getProperty();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        Property<RECEIVER> property = this.getProperty(id);
        if (property != null) {
            return property.getValue(this.receiver);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getEditableValue() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DelegatingPropertyDescriptor<RECEIVER>
    implements IPropertyDescriptor {
        private final Property<RECEIVER> property;
        private ILabelProvider labelProvider;

        public DelegatingPropertyDescriptor(Property<RECEIVER> property) {
            this.property = property;
        }

        public Property<RECEIVER> getProperty() {
            return this.property;
        }

        public String getCategory() {
            return this.property.getCategory();
        }

        public String getId() {
            return this.property.getName();
        }

        public String getDisplayName() {
            return this.property.getLabel();
        }

        public String getDescription() {
            return this.property.getDescription();
        }

        public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
            return anotherProperty.getCategory().equals(this.getCategory()) && anotherProperty.getId().equals(this.getId());
        }

        public ILabelProvider getLabelProvider() {
            if (this.labelProvider != null) {
                return this.labelProvider;
            }
            return new LabelProvider();
        }

        public void setLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Object getHelpContextIds() {
            return null;
        }

        public String[] getFilterFlags() {
            return null;
        }

        public CellEditor createPropertyEditor(Composite parent) {
            return null;
        }
    }
}

