/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.debug.adaptor.launching;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class OTEquinoxDebugAgent {
    static boolean DUMP = System.getProperty("otequinox.dump.redefine") != null;

    public static void premain(String options, Instrumentation inst) {
        inst.addTransformer(new OTEquinoxTransformerDelegate());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OTEquinoxTransformerDelegate
    implements ClassFileTransformer {
        private Class<?> dclClass;
        private Method getBundle;
        private Method getBundleData;
        private Method getAdaptor;
        private Method getHookRegistry;
        private Method getClassLoadingHooks;
        private Method getClasspathManager;
        private Method processClass;

        OTEquinoxTransformerDelegate() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (classBeingRedefined == null) {
                return null;
            }
            try {
                if (this.isDefaultClassLoader(loader)) {
                    String classNameDot = className.replace('/', '.');
                    boolean modified = false;
                    Object[] objectArray = this.getClassLoadingHooks(loader);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object hook = objectArray[n2];
                        byte[] newBytes = this.processClass(hook, classNameDot, classfileBuffer, null, null, this.getClasspathManager(loader));
                        if (newBytes != null) {
                            if (DUMP) {
                                this.dumpBytes(className, newBytes);
                            }
                            classfileBuffer = newBytes;
                            modified = true;
                        }
                        ++n2;
                    }
                    if (modified) {
                        return classfileBuffer;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return null;
        }

        private void dumpBytes(String className, byte[] newBytes) throws FileNotFoundException, IOException {
            String fileName = String.valueOf(className) + ".class";
            int lastSlash = fileName.lastIndexOf(47);
            if (lastSlash != -1) {
                new File(fileName.substring(0, lastSlash)).mkdirs();
            }
            File dumpFile = new File(fileName);
            FileOutputStream dumpStream = new FileOutputStream(dumpFile);
            dumpStream.write(newBytes);
            dumpStream.close();
        }

        private boolean isDefaultClassLoader(ClassLoader loader) {
            Class<?> clazz = loader.getClass();
            if (this.dclClass != null) {
                return this.dclClass == clazz;
            }
            if (clazz.getName().equals("org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader")) {
                this.dclClass = clazz;
                return true;
            }
            return false;
        }

        private Object[] getClassLoadingHooks(ClassLoader loader) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.getBundle == null) {
                this.getBundle = this.dclClass.getMethod("getBundle", null);
            }
            Object bundle = this.getBundle.invoke((Object)loader, null);
            if (this.getBundleData == null) {
                this.getBundleData = bundle.getClass().getMethod("getBundleData", null);
            }
            Object bundleData = this.getBundleData.invoke(bundle, null);
            if (this.getAdaptor == null) {
                this.getAdaptor = bundleData.getClass().getMethod("getAdaptor", null);
            }
            Object adaptor = this.getAdaptor.invoke(bundleData, null);
            if (this.getHookRegistry == null) {
                this.getHookRegistry = adaptor.getClass().getMethod("getHookRegistry", null);
            }
            Object hookRegistry = this.getHookRegistry.invoke(adaptor, null);
            if (this.getClassLoadingHooks == null) {
                this.getClassLoadingHooks = hookRegistry.getClass().getMethod("getClassLoadingHooks", null);
            }
            return (Object[])this.getClassLoadingHooks.invoke(hookRegistry, null);
        }

        private Object getClasspathManager(ClassLoader loader) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
            if (this.getClasspathManager == null) {
                this.getClasspathManager = this.dclClass.getMethod("getClasspathManager", null);
            }
            return this.getClasspathManager.invoke((Object)loader, null);
        }

        private byte[] processClass(Object hook, String className, byte[] classfileBuffer, Object classpathEntry, Object entry, Object classpathManager) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            block5: {
                Class<?>[] classArray;
                if (!hook.getClass().getName().equals("org.eclipse.objectteams.otequinox.internal.hook.TransformerHook")) {
                    return null;
                }
                if (this.processClass == null && (classArray = hook.getClass().getInterfaces()).length != 0) {
                    Class<?> superIfc = classArray[0];
                    if (superIfc.getName().equals("org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook")) {
                        Method[] methodArray = superIfc.getMethods();
                        int n = methodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Method m = methodArray[n2];
                            if (m.getName().equals("processClass")) {
                                this.processClass = m;
                                break block5;
                            }
                            ++n2;
                        }
                    }
                    throw new NoSuchMethodError("processClass");
                }
            }
            return (byte[])this.processClass.invoke(hook, className, classfileBuffer, classpathEntry, entry, classpathManager);
        }
    }
}

