/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.DebugWorkingCopyManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.OTBreakpointLocationVerifierJob;
import org.eclipse.objectteams.otdt.debug.ui.internal.actions.OTValidBreakpointLocationLocator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class OTToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    private static final String EMPTY_STRING = "";

    public OTToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected void report(final String message, final IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return type;
    }

    protected IType getType(IJavaElement element) {
        switch (element.getElementType()) {
            case 8: {
                return ((IField)element).getDeclaringType();
            }
            case 9: {
                return ((IMethod)element).getDeclaringType();
            }
            case 7: {
                return (IType)element;
            }
        }
        return null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = OTToggleBreakpointAdapter.this.getTextEditor(part);
                if (editor != null && selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        IDocument document;
                        HashMap attributes;
                        int lnumber;
                        IResource resource;
                        String tname;
                        IType type;
                        OTToggleBreakpointAdapter.this.report(null, part);
                        ISelection sel = selection;
                        if (!(selection instanceof IStructuredSelection)) {
                            sel = OTToggleBreakpointAdapter.this.translateToMembers(part, selection);
                        }
                        if (OTToggleBreakpointAdapter.this.isInterface(sel, part)) {
                            OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_6, part);
                            return Status.OK_STATUS;
                        }
                        if (sel instanceof IStructuredSelection) {
                            IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                            type = null;
                            type = member instanceof IType ? (IType)member : member.getDeclaringType();
                            tname = OTToggleBreakpointAdapter.createQualifiedTypeName(type);
                            resource = BreakpointUtils.getBreakpointResource((IMember)type);
                            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)tname, (int)(lnumber = ((ITextSelection)selection).getStartLine() + 1));
                            if (existingBreakpoint != null) {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            attributes = new HashMap(10);
                            IDocumentProvider documentProvider = editor.getDocumentProvider();
                            if (documentProvider == null) {
                                return Status.CANCEL_STATUS;
                            }
                            document = documentProvider.getDocument((Object)editor.getEditorInput());
                            try {
                                IRegion line = document.getLineInformation(lnumber - 1);
                                int start = line.getOffset();
                                int end = start + line.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, (int)start, (int)end);
                            }
                            catch (BadLocationException ble) {
                                JDIDebugUIPlugin.log((Throwable)ble);
                            }
                        } else {
                            OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_3, part);
                            return Status.OK_STATUS;
                        }
                        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)tname, (int)lnumber, (int)-1, (int)-1, (int)0, (boolean)true, attributes);
                        new OTBreakpointLocationVerifierJob(document, breakpoint, lnumber, bestMatch, tname, type, resource, (IEditorPart)editor).schedule();
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                block14: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        OTToggleBreakpointAdapter.this.report(null, part);
                        ISelection selection = finalSelection;
                        if (!(selection instanceof IStructuredSelection)) {
                            selection = OTToggleBreakpointAdapter.this.translateToMembers(part, selection);
                        }
                        if (OTToggleBreakpointAdapter.this.isInterface(selection, part)) {
                            OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_7, part);
                            return Status.OK_STATUS;
                        }
                        if (selection instanceof IStructuredSelection) {
                            IMethod[] members = OTToggleBreakpointAdapter.this.getMethods((IStructuredSelection)selection);
                            if (members.length == 0) {
                                OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_9, part);
                                return Status.OK_STATUS;
                            }
                            IJavaBreakpoint breakpoint = null;
                            ISourceRange range = null;
                            HashMap attributes = null;
                            IType type = null;
                            String signature = null;
                            String mname = null;
                            int i = 0;
                            int length = members.length;
                            while (i < length) {
                                breakpoint = OTToggleBreakpointAdapter.this.getMethodBreakpoint((IMember)members[i]);
                                if (breakpoint == null) {
                                    int start = -1;
                                    int end = -1;
                                    range = members[i].getNameRange();
                                    if (range != null) {
                                        start = range.getOffset();
                                        end = start + range.getLength();
                                    }
                                    attributes = new HashMap(10);
                                    BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)members[i]);
                                    type = members[i].getDeclaringType();
                                    signature = members[i].getSignature();
                                    mname = members[i].getElementName();
                                    if (members[i].isConstructor()) {
                                        mname = "<init>";
                                        if (type.isEnum()) {
                                            signature = "(Ljava.lang.String;I" + signature.substring(1);
                                        }
                                    }
                                    if (!type.isBinary() && (signature = OTToggleBreakpointAdapter.resolveMethodSignature(members[i])) == null) {
                                        OTToggleBreakpointAdapter.this.report(ActionMessages.ManageMethodBreakpointActionDelegate_methodNonAvailable, part);
                                        return Status.OK_STATUS;
                                    }
                                    JDIDebugModel.createMethodBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)members[i]), (String)OTToggleBreakpointAdapter.createQualifiedTypeName(type), (String)mname, (String)signature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                                } else {
                                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                                }
                                ++i;
                            }
                            break block14;
                        }
                        OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_4, part);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void toggleClassBreakpoints(final IWorkbenchPart part, final ISelection selection) {
        Job job = new Job("Toggle Class Load Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                block9: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        OTToggleBreakpointAdapter.this.report(null, part);
                        ISelection sel = selection;
                        if (!(selection instanceof IStructuredSelection)) {
                            sel = OTToggleBreakpointAdapter.this.translateToMembers(part, selection);
                        }
                        if (OTToggleBreakpointAdapter.this.isInterface(sel, part)) {
                            OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_1, part);
                            return Status.OK_STATUS;
                        }
                        if (sel instanceof IStructuredSelection) {
                            IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                            IType type = (IType)member;
                            IBreakpoint existing = OTToggleBreakpointAdapter.this.getClassLoadBreakpoint(type);
                            if (existing != null) {
                                existing.delete();
                            } else {
                                HashMap map = new HashMap(10);
                                BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)type);
                                ISourceRange range = type.getNameRange();
                                int start = -1;
                                int end = -1;
                                if (range != null) {
                                    start = range.getOffset();
                                    end = start + range.getLength();
                                }
                                JDIDebugModel.createClassPrepareBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)member), (String)OTToggleBreakpointAdapter.createQualifiedTypeName(type), (int)0, (int)start, (int)end, (boolean)true, map);
                            }
                            break block9;
                        }
                        OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_0, part);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected IBreakpoint getClassLoadBreakpoint(IType type) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
        IJavaBreakpoint existing = null;
        IJavaBreakpoint breakpoint = null;
        int i = 0;
        while (i < breakpoints.length) {
            breakpoint = (IJavaBreakpoint)breakpoints[i];
            if (breakpoint instanceof IJavaClassPrepareBreakpoint && OTToggleBreakpointAdapter.createQualifiedTypeName(type).equals(breakpoint.getTypeName())) {
                existing = breakpoint;
                break;
            }
            ++i;
        }
        return existing;
    }

    public static String createQualifiedTypeName(IType type) {
        String tname = OTToggleBreakpointAdapter.pruneAnonymous(type);
        try {
            String packName = null;
            if (type.isBinary()) {
                packName = type.getPackageFragment().getElementName();
            } else {
                IPackageDeclaration[] pd = type.getCompilationUnit().getPackageDeclarations();
                if (pd.length > 0) {
                    packName = pd[0].getElementName();
                }
            }
            if (packName != null && !packName.equals(EMPTY_STRING)) {
                tname = tname.startsWith("__OT__") ? String.valueOf(packName) + '$' + tname : String.valueOf(packName) + "." + tname;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return tname;
    }

    private static String pruneAnonymous(IType type) {
        StringBuffer buffer = new StringBuffer();
        IType parent = type;
        while (parent != null) {
            if (parent.getElementType() == 7) {
                IType atype = parent;
                try {
                    if (!atype.isAnonymous()) {
                        if (buffer.length() > 0) {
                            buffer.insert(0, '$');
                        }
                        buffer.insert(0, OTToggleBreakpointAdapter.getSimpleTypeName(atype));
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            parent = parent.getParent();
        }
        return buffer.toString();
    }

    private static String getSimpleTypeName(IType type) {
        String name = type.getElementName();
        if (name.startsWith("__OT__")) {
            return name;
        }
        boolean isRole = false;
        if (type.getElementType() == 101) {
            isRole = true;
        } else if (OTModelManager.hasOTElementFor((IType)type)) {
            IOTType otType = OTModelManager.getOTElement((IType)type);
            isRole = otType.isRole();
        }
        if (isRole) {
            return "__OT__" + name;
        }
        return name;
    }

    private IJavaElement getJavaElement(IEditorInput input) {
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return DebugWorkingCopyManager.getWorkingCopy((IEditorInput)input, (boolean)false);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss).length > 0;
        }
        return selection instanceof ITextSelection && this.isMethod((ITextSelection)selection, part);
    }

    protected boolean isRemote(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IMember) {
            IMember member = (IMember)element;
            return !member.getJavaProject().getProject().exists();
        }
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Object adapter = Platform.getAdapterManager().getAdapter((Object)input, "org.eclipse.team.core.history.IFileRevision");
            return adapter != null;
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    protected IMethod[] getMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                IMethod method;
                if (!(thing instanceof IMethod) || Flags.isAbstract((int)(method = (IMethod)thing).getFlags())) continue;
                methods.add(method);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    private boolean isMethod(ITextSelection selection, IWorkbenchPart part) {
        IJavaElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ICompilationUnit) {
                    element = ((ICompilationUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 9;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    protected List getFields(IStructuredSelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList fields = new ArrayList(selection.size());
        for (Object thing : selection) {
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IJavaFieldVariable)) continue;
            IField field = this.getField((IJavaFieldVariable)thing);
            if (field == null) {
                fields.add(thing);
                continue;
            }
            fields.add(field);
        }
        return fields;
    }

    private boolean isInterface(ISelection selection, IWorkbenchPart part) {
        try {
            ISelection sel = selection;
            if (!(sel instanceof IStructuredSelection)) {
                sel = this.translateToMembers(part, selection);
            }
            if (sel instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)sel).getFirstElement();
                if (obj instanceof IMember) {
                    IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
                    if (member.getElementType() == 7) {
                        return ((IType)member).isInterface();
                    }
                    return member.getDeclaringType().isInterface();
                }
                if (obj instanceof IJavaFieldVariable) {
                    IJavaFieldVariable var = (IJavaFieldVariable)obj;
                    IType type = JavaDebugUtils.resolveType((IJavaType)var.getDeclaringType());
                    return type != null && type.isInterface();
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private boolean isField(ITextSelection selection, IWorkbenchPart part) {
        IJavaElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ICompilationUnit) {
                    element = ((ICompilationUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 8;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isFields(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            try {
                for (Object thing : selection) {
                    if (thing instanceof IField) {
                        int flags = ((IField)thing).getFlags();
                        return !Flags.isFinal((int)flags) & !(Flags.isFinal((int)flags) & Flags.isStatic((int)flags));
                    }
                    if (!(thing instanceof IJavaFieldVariable)) continue;
                    IJavaFieldVariable fv = (IJavaFieldVariable)thing;
                    return !fv.isFinal() & !(fv.isFinal() & fv.isStatic());
                }
            }
            catch (JavaModelException e) {
                return false;
            }
            catch (DebugException de) {
                return false;
            }
        }
        return false;
    }

    public void toggleWatchpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Watchpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                block16: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        OTToggleBreakpointAdapter.this.report(null, part);
                        ISelection selection = finalSelection;
                        if (!(selection instanceof IStructuredSelection)) {
                            selection = OTToggleBreakpointAdapter.this.translateToMembers(part, finalSelection);
                        }
                        if (OTToggleBreakpointAdapter.this.isInterface(selection, part)) {
                            OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_5, part);
                            return Status.OK_STATUS;
                        }
                        boolean allowed = false;
                        if (selection instanceof IStructuredSelection) {
                            List fields = OTToggleBreakpointAdapter.this.getFields((IStructuredSelection)selection);
                            if (fields.isEmpty()) {
                                OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_10, part);
                                return Status.OK_STATUS;
                            }
                            Iterator theFields = fields.iterator();
                            IField javaField = null;
                            IWorkspaceRoot resource = null;
                            String typeName = null;
                            String fieldName = null;
                            Object element = null;
                            HashMap attributes = null;
                            IJavaWatchpoint breakpoint = null;
                            while (theFields.hasNext()) {
                                element = theFields.next();
                                if (element instanceof IField) {
                                    javaField = element;
                                    IType type = javaField.getDeclaringType();
                                    typeName = OTToggleBreakpointAdapter.createQualifiedTypeName(type);
                                    fieldName = javaField.getElementName();
                                    int f = javaField.getFlags();
                                    boolean fin = Flags.isFinal((int)f);
                                    allowed = !fin & !(Flags.isStatic((int)f) & fin);
                                } else if (element instanceof IJavaFieldVariable) {
                                    IJavaFieldVariable var = element;
                                    typeName = var.getDeclaringType().getName();
                                    fieldName = var.getName();
                                    boolean fin = var.isFinal();
                                    allowed = !fin & !(var.isStatic() & fin);
                                }
                                breakpoint = OTToggleBreakpointAdapter.this.getWatchpoint(typeName, fieldName);
                                if (breakpoint == null) {
                                    if (!allowed) {
                                        OTToggleBreakpointAdapter.this.toggleLineBreakpoints(part, finalSelection);
                                        return Status.OK_STATUS;
                                    }
                                    int start = -1;
                                    int end = -1;
                                    attributes = new HashMap(10);
                                    if (javaField == null) {
                                        resource = ResourcesPlugin.getWorkspace().getRoot();
                                    } else {
                                        IType type = javaField.getDeclaringType();
                                        ISourceRange range = javaField.getNameRange();
                                        if (range != null) {
                                            start = range.getOffset();
                                            end = start + range.getLength();
                                        }
                                        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)javaField);
                                        resource = BreakpointUtils.getBreakpointResource((IMember)type);
                                    }
                                    JDIDebugModel.createWatchpoint((IResource)resource, (String)typeName, (String)fieldName, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                                    continue;
                                }
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                            }
                            break block16;
                        }
                        OTToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_2, part);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private IJavaWatchpoint getWatchpoint(String typeName, String fieldName) throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaWatchpoint watchpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaWatchpoint && typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) && fieldName.equals(watchpoint.getFieldName())) {
                return watchpoint;
            }
            ++i;
        }
        return null;
    }

    public static String resolveMethodSignature(IMethod method) throws JavaModelException {
        String signature = method.getSignature();
        String[] parameterTypes = Signature.getParameterTypes((String)signature);
        int length = parameterTypes.length;
        String[] resolvedParameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            resolvedParameterTypes[i] = OTToggleBreakpointAdapter.resolveTypeSignature(method, parameterTypes[i]);
            if (resolvedParameterTypes[i] == null) {
                return null;
            }
            ++i;
        }
        String resolvedReturnType = OTToggleBreakpointAdapter.resolveTypeSignature(method, Signature.getReturnType((String)signature));
        if (resolvedReturnType == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])resolvedParameterTypes, (String)resolvedReturnType);
    }

    private static String resolveTypeSignature(IMethod method, String typeSignature) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        IType type = method.getDeclaringType();
        String[][] resolvedElementTypeNames = type.resolveType(elementTypeName);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            ITypeParameter typeParameter = method.getTypeParameter(elementTypeName);
            if (!typeParameter.exists()) {
                typeParameter = type.getTypeParameter(elementTypeName);
            }
            if (typeParameter.exists()) {
                String[] bounds = typeParameter.getBounds();
                if (bounds.length == 0) {
                    return "Ljava/lang/Object;";
                }
                String bound = Signature.createTypeSignature((String)bounds[0], (boolean)false);
                return OTToggleBreakpointAdapter.resolveTypeSignature(method, bound);
            }
            return null;
        }
        String[] types = resolvedElementTypeNames[0];
        types[1] = types[1].replace('.', '$');
        String resolvedElementTypeName = Signature.toQualifiedName((String[])types);
        String resolvedElementTypeSignature = EMPTY_STRING;
        if (types[0].equals(EMPTY_STRING)) {
            resolvedElementTypeName = resolvedElementTypeName.substring(1);
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true);
        } else {
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        }
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    protected IMethod getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IJavaElement element = (IJavaElement)editorPart.getEditorInput().getAdapter(IJavaElement.class);
        IType type = null;
        if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].getFullyQualifiedName().equals(typeName)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getMethod(methodName, sigs);
        }
        return null;
    }

    protected IJavaBreakpoint getMethodBreakpoint(IMember element) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    IMember container = null;
                    try {
                        container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log((Throwable)e);
                        return null;
                    }
                    if (container == null) {
                        try {
                            if (method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && methodBreakpoint.getMethodSignature().equals(OTToggleBreakpointAdapter.resolveMethodSignature(method))) {
                                return methodBreakpoint;
                            }
                        }
                        catch (CoreException e) {
                            JDIDebugUIPlugin.log((Throwable)e);
                        }
                    } else if (container instanceof IMethod && method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method.isSimilar((IMethod)container)) {
                        return methodBreakpoint;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor editor) {
        ITypeRoot root = this.getTypeRoot(editor.getEditorInput());
        if (root != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(root);
            return (CompilationUnit)parser.createAST(null);
        }
        return null;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection && this.isField((ITextSelection)selection, part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null && selection instanceof ITextSelection) {
            IJavaElement e;
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            int offset = textSelection.getOffset();
            if (document != null) {
                try {
                    IRegion region = document.getLineInformationOfOffset(offset);
                    int end = region.getOffset() + region.getLength();
                    while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                        ++offset;
                    }
                }
                catch (BadLocationException region) {
                    // empty catch block
                }
            }
            IMember m = null;
            ITypeRoot root = this.getTypeRoot(editorInput);
            if (root instanceof ICompilationUnit) {
                ICompilationUnit unit;
                ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)root;
                synchronized (iCompilationUnit) {
                    unit.reconcile(0, false, null, null);
                }
            }
            if (root != null && (e = root.getElementAt(offset)) instanceof IMember) {
                m = (IMember)e;
            }
            if (m != null) {
                return new StructuredSelection(m);
            }
        }
        return selection;
    }

    private ITypeRoot getTypeRoot(IEditorInput input) {
        ITypeRoot root = (ITypeRoot)input.getAdapter(IClassFile.class);
        if (root == null) {
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            root = manager.getWorkingCopy(input);
        }
        if (root == null) {
            root = DebugWorkingCopyManager.getWorkingCopy((IEditorInput)input, (boolean)false);
        }
        return root;
    }

    private IField getField(IJavaFieldVariable variable) throws CoreException {
        IField field;
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log((Throwable)x);
            return null;
        }
        IJavaType declaringType = variable.getDeclaringType();
        IType type = JavaDebugUtils.resolveType((IJavaType)declaringType);
        if (type != null && (field = type.getField(varName)).exists()) {
            return field;
        }
        return null;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ISelection sel = this.translateToMembers(part, selection);
        if (sel instanceof IStructuredSelection) {
            IMember member = (IMember)((IStructuredSelection)sel).getFirstElement();
            int mtype = member.getElementType();
            if (mtype == 8 || mtype == 9) {
                if (selection instanceof ITextSelection) {
                    ITextSelection ts = (ITextSelection)selection;
                    IType declaringType = member.getDeclaringType();
                    IResource resource = BreakpointUtils.getBreakpointResource((IMember)declaringType);
                    IJavaLineBreakpoint breakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)OTToggleBreakpointAdapter.createQualifiedTypeName(declaringType), (int)(ts.getStartLine() + 1));
                    if (breakpoint != null) {
                        breakpoint.delete();
                        return;
                    }
                    CompilationUnit unit = this.parseCompilationUnit(this.getTextEditor(part));
                    OTValidBreakpointLocationLocator loc = new OTValidBreakpointLocationLocator(unit, ts.getStartLine() + 1, true, true);
                    unit.accept((ASTVisitor)loc);
                    if (loc.getLocationType() == 2) {
                        this.toggleMethodBreakpoints(part, sel);
                    } else if (loc.getLocationType() == 3) {
                        this.toggleWatchpoints(part, (ISelection)ts);
                    } else if (loc.getLocationType() == 1) {
                        this.toggleLineBreakpoints(part, (ISelection)ts);
                    }
                }
            } else if (member.getElementType() == 7) {
                this.toggleClassBreakpoints(part, sel);
            } else {
                this.toggleLineBreakpoints(part, selection, true);
            }
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return this.canToggleLineBreakpoints(part, selection);
    }
}

