/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.ext.IMarkableJavaElement;
import org.eclipse.objectteams.otdt.core.ext.MarkableFactory;
import org.eclipse.objectteams.otdt.core.search.OTSearchEngine;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.AnnotationHelper;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarker;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarkerJob;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarkerRemover;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.JavaEditorActivationListener;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.JobListener;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.MySubProgressMonitor;
import org.eclipse.objectteams.otdt.internal.ui.preferences.GeneralPreferences;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallinMarkerCreator2
extends JavaEditorActivationListener {
    protected CallinMarkerJob _currentJob;
    private Map<IJavaElement, IType> m_cachedBaseForRole = new HashMap<IJavaElement, IType>();
    private Set<IResource> m_cachedMarkersForResources = new HashSet<IResource>();
    private Set<IJavaElement> m_cachedMarkersForJavaElements = new HashSet<IJavaElement>();
    private boolean m_enabled = false;
    protected AnnotationHelper annotationHelper;
    private boolean isInitialized = false;

    public CallinMarkerCreator2() {
        IPreferenceStore store = OTDTUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (GeneralPreferences.CALLIN_MARKER_ENABLED_BOOL.equals(event.getProperty())) {
                    boolean newValue = (Boolean)event.getNewValue();
                    CallinMarkerCreator2.this.setEnabled(newValue);
                }
            }
        });
        this.setEnabled(store.getBoolean(GeneralPreferences.CALLIN_MARKER_ENABLED_BOOL));
    }

    public void setEnabled(boolean enable) {
        if (this.m_enabled == enable) {
            return;
        }
        if (enable) {
            this.installListener();
        } else {
            this.uninstallListener();
        }
        this.m_enabled = enable;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void updateCallinMarker(final IMember member, IStatusLineManager statusLine) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isCached(member.getResource()) && !this.isCreatingMarkersFor(member.getResource())) {
            return;
        }
        final IMarkableJavaElement target = MarkableFactory.createMarkable((IResource)member.getResource());
        CallinMarkerJob job = new CallinMarkerJob(target){

            protected void updateMarkers(IProgressMonitor monitor) throws Exception {
                CallinMarkerCreator2.this.updateCallinMarker(target, member, monitor);
            }
        };
        this.schedule(job, statusLine);
    }

    public void invalidateRole(IType roleType, IType baseClass) {
        IType cachedBaseClass;
        if (baseClass != null) {
            this.invalidateBase((IJavaElement)baseClass);
        }
        if ((cachedBaseClass = this.m_cachedBaseForRole.get(roleType)) != null && !cachedBaseClass.equals(baseClass)) {
            this.m_cachedBaseForRole.remove(roleType);
            this.invalidateBase((IJavaElement)cachedBaseClass);
        }
    }

    public void invalidateBase(IJavaElement baseClass) {
        IMarkableJavaElement baseMarkable = MarkableFactory.createMarkable((IJavaElement)baseClass);
        IEditorPart editor = (IEditorPart)this.fActiveEditor;
        if (baseMarkable.isBinary()) {
            IClassFile editorClassFile;
            IJavaElement baseJavaElement = baseMarkable.getJavaElement();
            this.m_cachedMarkersForJavaElements.remove(baseJavaElement);
            if (this.fActiveEditor != null && this.fActiveEditor instanceof IEditorPart && editor.getEditorInput() instanceof IClassFileEditorInput && (editorClassFile = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile()) != null && !this.isCreatingMarkersFor((IJavaElement)editorClassFile) && editorClassFile.equals(baseJavaElement)) {
                this.updateForBaseMarkable(baseMarkable, editor);
            }
        } else {
            IFile editorResource;
            IResource baseResource = baseMarkable.getResource();
            this.m_cachedMarkersForResources.remove(baseResource);
            if (this.fActiveEditor != null && this.fActiveEditor instanceof IEditorPart && editor.getEditorInput() instanceof IFileEditorInput && (editorResource = ((IFileEditorInput)editor.getEditorInput()).getFile()) != null && !this.isCreatingMarkersFor((IResource)editorResource) && editorResource.equals((Object)baseResource)) {
                this.updateForBaseMarkable(baseMarkable, editor);
            }
        }
    }

    private void updateForBaseMarkable(IMarkableJavaElement baseMarkable, IEditorPart editor) {
        IStatusLineManager statusLine = editor.getEditorSite().getActionBars().getStatusLineManager();
        this.updateCallinMarkers(baseMarkable, statusLine);
    }

    @Override
    protected void activeJavaEditorChanged(IWorkbenchPart editor) {
        if (!(editor instanceof IEditorPart)) {
            if (editor == null) {
                this.annotationHelper = null;
                this.fActiveEditor = null;
            }
            return;
        }
        IEditorPart targetEditor = (IEditorPart)editor;
        IEditorInput editorInput = targetEditor.getEditorInput();
        IStatusLineManager statusLine = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
        this.fActiveEditor = editor;
        this.annotationHelper = new AnnotationHelper(targetEditor, editorInput);
        IMarkableJavaElement target = null;
        if (editorInput instanceof IFileEditorInput) {
            IFile resource = ((IFileEditorInput)editorInput).getFile();
            if (resource == null || this.isCached((IResource)resource) || this.isCreatingMarkersFor((IResource)resource)) {
                return;
            }
            target = MarkableFactory.createMarkable((IResource)resource);
        } else if (editorInput instanceof IClassFileEditorInput) {
            IClassFile element = ((IClassFileEditorInput)editorInput).getClassFile();
            if (element == null || this.isCached((IJavaElement)element) || this.isCreatingMarkersFor((IJavaElement)element)) {
                return;
            }
            target = MarkableFactory.createMarkable((IJavaElement)element);
        } else {
            return;
        }
        if (target.exists()) {
            this.updateCallinMarkers(target, statusLine);
        }
    }

    public void updateCallinMarkers(final IMarkableJavaElement target, IStatusLineManager statusLine) {
        CallinMarkerJob job = new CallinMarkerJob(target){

            protected void updateMarkers(IProgressMonitor monitor) throws Exception {
                CallinMarkerCreator2.this.updateCallinMarkers(target, monitor);
            }
        };
        this.setCurrentJob(job);
        this.schedule(job, statusLine);
    }

    private void updateCallinMarkers(IMarkableJavaElement target, IProgressMonitor monitor) throws CoreException {
        try {
            if (target == null || !target.exists()) {
                return;
            }
            monitor.beginTask(NLS.bind((String)OTDTUIPlugin.getResourceString("CallinMarkerCreator2.updating_for_resource_message"), (Object[])new Object[]{target.getName()}), 62);
            target.removeMarkers(CallinMarker.CALLIN_MARKER_IDS);
            monitor.worked(2);
            IJavaProject[] projects = target.getProjects();
            Set allTypes = target.getAllTypes(projects, monitor);
            Map<IMember, Set<IType>> playedByMap = this.searchPlayedByBindings(allTypes, projects, new MySubProgressMonitor(monitor, 20));
            if (playedByMap == null || playedByMap.size() == 0) {
                return;
            }
            this.createMarkersFor(target, playedByMap, "org.eclipse.objectteams.otdt.ui.playedByMarker", new MySubProgressMonitor(monitor, 5));
            IMember[] allRoleTypes = this.collectRolesAndSubroles(playedByMap, (IProgressMonitor)new MySubProgressMonitor(monitor, 10));
            if (monitor.isCanceled()) {
                return;
            }
            Set<IMember> allMembers = this.getAllMethodsAndFields(target.getJavaElement());
            monitor.worked(5);
            this.updateMethodMarkers(target, allRoleTypes, allMembers, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
    }

    private IMember[] collectRolesAndSubroles(Map<IMember, Set<IType>> playedByMap, IProgressMonitor submon) throws JavaModelException {
        HashSet<IType> collectedRoleTypes = new HashSet<IType>();
        submon.beginTask("Finding sub roles", playedByMap.size());
        for (Set<IType> value : playedByMap.values()) {
            collectedRoleTypes.addAll(value);
            for (IType member : value) {
                if (submon.isCanceled()) {
                    return null;
                }
                if (member.exists() && OTModelManager.isRole((IType)member)) {
                    IType[] subtypes;
                    IType[] iTypeArray = subtypes = member.newTypeHierarchy(submon).getAllSubtypes(member);
                    int n = subtypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType subtype = iTypeArray[n2];
                        collectedRoleTypes.add(subtype);
                        ++n2;
                    }
                }
                submon.worked(1);
            }
        }
        IMember[] allRoleTypes = collectedRoleTypes.toArray(new IMember[collectedRoleTypes.size()]);
        submon.done();
        return allRoleTypes;
    }

    private void updateCallinMarker(IMarkableJavaElement target, IMember member, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NLS.bind((String)OTDTUIPlugin.getResourceString("CallinMarkerCreator2.updating_for_method_message"), (Object[])new Object[]{member.getElementName()}), 45);
            IResource resource = member.getResource();
            if (resource != null) {
                CallinMarkerRemover.removeCallinMarker(member, resource);
                monitor.worked(5);
                ArrayList<IType> allTypes = new ArrayList<IType>(1);
                allTypes.add((IType)member.getAncestor(7));
                Map<IMember, Set<IType>> playedByMap = this.searchPlayedByBindings(allTypes, new IJavaProject[]{member.getJavaProject()}, new MySubProgressMonitor(monitor, 20));
                if (playedByMap == null || playedByMap.isEmpty()) {
                    return;
                }
                IMember[] allRoleTypes = this.collectRolesAndSubroles(playedByMap, (IProgressMonitor)new MySubProgressMonitor(monitor, 10));
                if (monitor.isCanceled()) {
                    return;
                }
                ArrayList<IMember> memberSet = new ArrayList<IMember>(1);
                memberSet.add(member);
                this.updateMethodMarkers(target, allRoleTypes, memberSet, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateMethodMarkers(IMarkableJavaElement target, IMember[] allRoleTypes, Collection<IMember> memberSet, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 40);
            HashMap callinMap = new HashMap();
            HashMap calloutMap = new HashMap();
            this.searchMemberBindings(memberSet, allRoleTypes, callinMap, calloutMap, new MySubProgressMonitor(monitor, 20));
            if (monitor.isCanceled()) {
                return;
            }
            this.createMarkersFor(target, callinMap, "org.eclipse.objectteams.otdt.ui.callinMarker", new MySubProgressMonitor(monitor, 10));
            this.createMarkersFor(target, calloutMap, "org.eclipse.objectteams.otdt.ui.calloutMarker", new MySubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentJob(CallinMarkerJob job) {
        CallinMarkerCreator2 callinMarkerCreator2 = this;
        synchronized (callinMarkerCreator2) {
            if (this._currentJob != null) {
                this._currentJob.cancel();
            }
            this._currentJob = job;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCreatingMarkersFor(IResource resource) {
        CallinMarkerCreator2 callinMarkerCreator2 = this;
        synchronized (callinMarkerCreator2) {
            block4: {
                if (this._currentJob != null) break block4;
                return false;
            }
            IResource jobResource = this._currentJob.getResource();
            return jobResource != null && jobResource.equals((Object)resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCreatingMarkersFor(IJavaElement element) {
        CallinMarkerCreator2 callinMarkerCreator2 = this;
        synchronized (callinMarkerCreator2) {
            block4: {
                if (this._currentJob != null) break block4;
                return false;
            }
            IJavaElement javaElement = this._currentJob.getJavaElement();
            return javaElement != null && javaElement.equals(element);
        }
    }

    private boolean isCached(IResource resource) {
        return this.m_cachedMarkersForResources.contains(resource);
    }

    private boolean isCached(IJavaElement element) {
        return this.m_cachedMarkersForJavaElements.contains(element);
    }

    private void setCached(IResource resource) {
        this.m_cachedMarkersForResources.add(resource);
    }

    private void setCached(IJavaElement element) {
        this.m_cachedMarkersForJavaElements.add(element);
    }

    private void removeFromCache(IResource resource) {
        this.m_cachedMarkersForResources.remove(resource);
    }

    private void removeFromCache(IJavaElement element) {
        this.m_cachedMarkersForJavaElements.remove(element);
    }

    private void removeFromCache(IWorkbenchPartReference ref) {
        IEditorInput input;
        IWorkbenchPart part = ref.getPart(false);
        if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            this.removeFromCache((IResource)((IFileEditorInput)input).getFile());
        }
    }

    @Override
    public void partClosed(IWorkbenchPartReference ref) {
        this.removeFromCache(ref);
        super.partClosed(ref);
    }

    private Set<IMember> getAllMethodsAndFields(IJavaElement javaElement) {
        if (javaElement == null) {
            return new HashSet<IMember>(0);
        }
        HashSet<IMember> members = new HashSet<IMember>(13);
        switch (javaElement.getElementType()) {
            case 5: {
                ICompilationUnit unit = (ICompilationUnit)javaElement;
                try {
                    IType[] types = unit.getTypes();
                    int idx = 0;
                    while (idx < types.length) {
                        members.addAll(this.getAllMethodsAndFields((IJavaElement)types[idx]));
                        ++idx;
                    }
                }
                catch (JavaModelException idx) {}
                break;
            }
            case 6: {
                IClassFile classFile = (IClassFile)javaElement;
                members.addAll(this.getAllMethodsAndFields((IJavaElement)classFile.getType()));
                break;
            }
            case 7: {
                IType type = (IType)javaElement;
                try {
                    members.addAll(Arrays.asList(type.getMethods()));
                    members.addAll(Arrays.asList(type.getFields()));
                    IOTType otType = OTModelManager.getOTElement((IType)type);
                    if (otType != null && otType.isRole()) {
                        IMethodMapping[] iMethodMappingArray = ((IRoleType)otType).getMethodMappings(2);
                        int n = iMethodMappingArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethodMapping mapping = iMethodMappingArray[n2];
                            members.add((IMember)mapping);
                            ++n2;
                        }
                    }
                    IType[] memberTypes = type.getTypes();
                    int idx = 0;
                    while (idx < memberTypes.length) {
                        members.addAll(this.getAllMethodsAndFields((IJavaElement)memberTypes[idx]));
                        ++idx;
                    }
                }
                catch (JavaModelException javaModelException) {}
                break;
            }
        }
        return members;
    }

    private Map<IMember, Set<IType>> searchPlayedByBindings(Collection<IType> baseTypes, IJavaProject[] projects, MySubProgressMonitor monitor) {
        if (baseTypes == null || baseTypes.size() == 0) {
            monitor.doneNothing();
            return null;
        }
        OTSearchEngine engine = new OTSearchEngine();
        IJavaSearchScope searchScope = OTSearchEngine.createOTSearchScope((IJavaElement[])projects, (boolean)false);
        final HashMap<IMember, Set<IType>> resultMap = new HashMap<IMember, Set<IType>>();
        try {
            monitor.beginTask(OTDTUIPlugin.getResourceString("searching role types"), baseTypes.size());
            for (final IType baseType : baseTypes) {
                if (monitor.isCanceled()) {
                    return null;
                }
                try {
                    SubProgressMonitor searchMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
                    if (!baseType.exists() || baseType.isEnum() || baseType.isAnnotation()) continue;
                    SearchPattern pattern = SearchPattern.createPattern((IJavaElement)baseType, (int)6);
                    if (pattern == null) {
                        OTDTUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", "Error creating pattern"));
                        continue;
                    }
                    engine.search(pattern, searchScope, new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            Object element = match.getElement();
                            if (element instanceof IType) {
                                IType mapping = (IType)element;
                                CallinMarkerCreator2.this.addToMapOfSets(resultMap, (IMember)baseType, (IMember)mapping);
                            }
                        }
                    }, (IProgressMonitor)searchMonitor);
                }
                catch (CoreException ex) {
                    OTDTUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", "Error finding playedBy bindings", (Throwable)ex));
                }
            }
        }
        finally {
            monitor.done();
        }
        return resultMap;
    }

    private void searchMemberBindings(Collection<IMember> baseMembers, IMember[] allRoleTypes, Map<IMember, Set<IMember>> callinMap, Map<IMember, Set<IMember>> calloutMap, MySubProgressMonitor monitor) {
        if (baseMembers == null || baseMembers.size() == 0) {
            monitor.doneNothing();
            return;
        }
        IMember[] iMemberArray = allRoleTypes;
        int n = allRoleTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IMember roleMember = iMemberArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            IOTType otType = OTModelManager.getOTElement((IType)((IType)roleMember));
            if (otType != null && otType.isRole()) {
                IRoleType roleType = (IRoleType)otType;
                IMethodMapping[] iMethodMappingArray = roleType.getMethodMappings();
                int n3 = iMethodMappingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethodMapping mapping = iMethodMappingArray[n4];
                    try {
                        IField baseField;
                        ICalloutMapping calloutMapping;
                        IMethod baseMethod;
                        if (mapping.getElementType() == 102) {
                            ICallinMapping callinMapping = (ICallinMapping)mapping;
                            IMethod[] iMethodArray = callinMapping.getBoundBaseMethods();
                            int n5 = iMethodArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                baseMethod = iMethodArray[n6];
                                if (baseMembers.contains(baseMethod)) {
                                    this.addToMapOfSets(callinMap, (IMember)baseMethod, mapping);
                                }
                                ++n6;
                            }
                        } else if (mapping.getElementType() == 103) {
                            calloutMapping = (ICalloutMapping)mapping;
                            baseMethod = calloutMapping.getBoundBaseMethod();
                            if (baseMembers.contains(baseMethod) && !this.isVisibleFor((IMember)baseMethod, (IType)roleType)) {
                                this.addToMapOfSets(calloutMap, (IMember)baseMethod, mapping);
                            }
                        } else if (mapping.getElementType() == 104 && baseMembers.contains(baseField = (calloutMapping = (ICalloutToFieldMapping)mapping).getBoundBaseField()) && !this.isVisibleFor((IMember)baseField, (IType)roleType)) {
                            this.addToMapOfSets(calloutMap, (IMember)baseField, mapping);
                        }
                    }
                    catch (JavaModelException ex) {
                        OTDTUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", "Error checking callin/callout binding", (Throwable)ex));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    boolean isVisibleFor(IMember baseMember, IType roleType) throws JavaModelException {
        int flags = baseMember.getFlags();
        if (Flags.isPrivate((int)flags)) {
            return false;
        }
        if (Flags.isPublic((int)flags)) {
            return true;
        }
        String rolePackage = roleType.getPackageFragment().getElementName();
        return baseMember.getDeclaringType().getPackageFragment().getElementName().equals(rolePackage);
    }

    private <M extends IMember> void addToMapOfSets(Map<IMember, Set<M>> mapOfSets, IMember key, M value) {
        Set<M> setForType = mapOfSets.get(key);
        if (setForType == null) {
            setForType = new HashSet<M>();
            mapOfSets.put(key, setForType);
        }
        setForType.add(value);
    }

    private <M extends IMember> void createMarkersFor(final IMarkableJavaElement target, final Map<IMember, Set<M>> bindingMap, final String markerKind, MySubProgressMonitor monitor) {
        if (bindingMap == null) {
            monitor.doneNothing();
            return;
        }
        final Set<IMember> baseElements = bindingMap.keySet();
        if (baseElements == null || baseElements.size() == 0) {
            monitor.doneNothing();
            return;
        }
        final AnnotationHelper myAnnotationHelper = this.annotationHelper;
        if (myAnnotationHelper == null) {
            if (monitor != null) {
                monitor.setCanceled(true);
            }
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(OTDTUIPlugin.getResourceString("CallinMarkerCreator2.creating_markers_message"), baseElements.size());
                try {
                    DefaultLineTracker lineTracker = null;
                    ICompilationUnit compilationUnit = ((IMember)baseElements.iterator().next()).getCompilationUnit();
                    if (compilationUnit != null) {
                        lineTracker = new DefaultLineTracker();
                        lineTracker.set(compilationUnit.getSource());
                    }
                    CallinMarker marker = new CallinMarker(markerKind);
                    for (IMember baseElement : baseElements) {
                        if (baseElement instanceof IType && !target.containsElement((IJavaElement)baseElement)) continue;
                        Set bindings = (Set)bindingMap.get(baseElement);
                        if (bindings != null && bindings.size() != 0) {
                            if (markerKind == "org.eclipse.objectteams.otdt.ui.playedByMarker") {
                                for (IMember binding : bindings) {
                                    CallinMarkerCreator2.this.m_cachedBaseForRole.put(binding, (IType)baseElement);
                                }
                            }
                            try {
                                ISourceRange nameRange = baseElement.getNameRange();
                                if (nameRange.getOffset() >= 0 && nameRange.getLength() >= 0) {
                                    if (lineTracker != null) {
                                        int line = lineTracker.getLineNumberOfOffset(nameRange.getOffset()) + 1;
                                        marker.setLineNumber(line);
                                    } else {
                                        marker.setNameRange(nameRange);
                                    }
                                    if (markerKind.equals("org.eclipse.objectteams.otdt.ui.calloutMarker")) {
                                        myAnnotationHelper.removeSomeWarnings(target.getResource(), nameRange);
                                    }
                                } else if (!baseElement.isBinary()) {
                                    if (nameRange.getOffset() < 0) {
                                        throw new BadLocationException("Offset must be >= 0, is " + nameRange.getOffset());
                                    }
                                    if (nameRange.getLength() < 0) {
                                        throw new BadLocationException("Length must be >= 0, is " + nameRange.getLength());
                                    }
                                }
                            }
                            catch (BadLocationException ex) {
                                OTDTUIPlugin.logException(OTDTUIPlugin.getResourceString("CallinMarkerCreator2.line_number_error_message"), ex);
                            }
                            marker.setBaseElement(baseElement);
                            marker.setRoleElement(bindings);
                            marker.create(target);
                        }
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 1, (IProgressMonitor)monitor);
        }
        catch (CoreException ex) {
            OTDTUIPlugin.logException("Error creating markers", ex);
        }
    }

    protected synchronized void schedule(final CallinMarkerJob job, final IStatusLineManager statusLine) {
        if (this.isInitialized) {
            this.doSchedule(job, statusLine);
            return;
        }
        this.isInitialized = true;
        Job waitForIndex = new Job(OTDTUIPlugin.getResourceString("CallinMarkerCreator2.wait_for_index_message")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        new SearchEngine().searchAllTypeNames(null, 0, "!@$#!@".toCharArray(), 10, 5, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(){

                            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                            }
                        }, 3, null);
                    }
                    catch (CoreException coreException) {
                        CallinMarkerCreator2.this.doSchedule(job, statusLine);
                    }
                }
                finally {
                    CallinMarkerCreator2.this.doSchedule(job, statusLine);
                }
                return Status.OK_STATUS;
            }
        };
        waitForIndex.setPriority(50);
        waitForIndex.schedule(100L);
    }

    protected void doSchedule(final CallinMarkerJob job, IStatusLineManager statusLine) {
        job.addJobChangeListener((IJobChangeListener)new JobListener(statusLine){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void jobFinished(int status) {
                CallinMarkerCreator2 callinMarkerCreator2 = CallinMarkerCreator2.this;
                synchronized (callinMarkerCreator2) {
                    IResource resource;
                    if (CallinMarkerCreator2.this._currentJob == job) {
                        CallinMarkerCreator2.this._currentJob = null;
                    }
                    if ((resource = job.getResource()) != null) {
                        if (status == 0) {
                            CallinMarkerCreator2.this.setCached(resource);
                        } else {
                            CallinMarkerCreator2.this.removeFromCache(resource);
                        }
                    } else {
                        IJavaElement element = job.getJavaElement();
                        if (status == 0) {
                            CallinMarkerCreator2.this.setCached(element);
                        } else {
                            CallinMarkerCreator2.this.removeFromCache(element);
                        }
                    }
                }
            }
        });
        job.setPriority(50);
        job.schedule(100L);
    }
}

