/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.wizards.OTNewWizardMessages;
import org.eclipse.objectteams.otdt.internal.ui.wizards.listeners.NewTypeWizardPageListener;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contentassist.ContentAssistHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewTypeWizardPage
extends org.eclipse.jdt.ui.wizards.NewTypeWizardPage {
    public static final int PUBLIC_INDEX = 0;
    public static final int DEFAULT_INDEX = 1;
    public static final int PRIVATE_INDEX = 2;
    public static final int PROTECTED_INDEX = 3;
    public static final int ABSTRACT_INDEX = 0;
    public static final int FINAL_INDEX = 1;
    public static final int STATIC_INDEX = 2;
    private StringButtonStatusDialogField _packageDialogField;
    private SelectionButtonDialogField _enclosingTypeSelection;
    private StringButtonDialogField _enclosingTypeDialogField;
    private SelectionButtonDialogFieldGroup _accessModifierButtons;
    private SelectionButtonDialogFieldGroup _otherModifierButtons;
    private StringButtonDialogField _superTypeDialogField;
    private StringDialogField _typeNameDialogField;
    private ListDialogField<Object> _superInterfacesDialogField;
    private SelectionButtonDialogFieldGroup _methodStubsButtons;
    private SelectionButtonDialogFieldGroup _bindingEditorButtons;
    private SelectionButtonDialogField _inlineSelectionDialogField;
    private JavaPackageCompletionProcessor _currPackageCompletionProcessor;
    private JavaTypeCompletionProcessor _enclosingTypeCompletionProcessor;
    private NewTypeWizardPageListener _listener = this.createPageListener();
    private IPackageFragment _currentPackage;
    private IType _enclosingType;
    private IType _superType;
    private IType _currentType;
    private boolean _canModifyPackage;
    private boolean _canModifyEnclosingType;
    private StubTypeContext _superClassStubTypeContext;
    private StubTypeContext _superInterfaceStubTypeContext;

    public NewTypeWizardPage(String pageName) {
        super(1, pageName);
        this._packageDialogField = this.createPackageDialogField(this._listener);
        this._enclosingTypeSelection = new SelectionButtonDialogField(32);
        this._enclosingTypeSelection.setDialogFieldListener((IDialogFieldListener)this._listener);
        this._enclosingTypeSelection.setLabelText(this.getEnclosingTypeLabel());
        this._enclosingTypeDialogField = this.createEnclosingTypeDialogField(this._listener);
        this._typeNameDialogField = this.createTypeNameDialogField(this._listener);
        this._superTypeDialogField = this.createSuperClassDialogField(this._listener);
        this._superInterfacesDialogField = this.createSuperInterfacesDialogField(this._listener, this._listener);
        this._accessModifierButtons = this.createAccessModifierButtons(this._listener);
        this._otherModifierButtons = this.createOtherModifierButtons(this._listener);
        this._methodStubsButtons = this.createMethodStubsButtons();
        this._bindingEditorButtons = this.createBindingEditorButtons();
        this._inlineSelectionDialogField = this.createInlineSelectionDialogField(this._listener);
        this._currPackageCompletionProcessor = new JavaPackageCompletionProcessor();
        this._enclosingTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this._canModifyPackage = true;
        this._canModifyEnclosingType = true;
        this.updateEnableState();
    }

    protected abstract NewTypeWizardPageListener createPageListener();

    protected SelectionButtonDialogFieldGroup createOtherModifierButtons(NewTypeWizardPageListener listener) {
        String[] buttonNames = new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_abstract, NewWizardMessages.NewTypeWizardPage_modifiers_final, NewWizardMessages.NewTypeWizardPage_modifiers_static};
        SelectionButtonDialogFieldGroup result = new SelectionButtonDialogFieldGroup(32, buttonNames, 4);
        result.setDialogFieldListener((IDialogFieldListener)listener);
        return result;
    }

    protected SelectionButtonDialogFieldGroup createAccessModifierButtons(NewTypeWizardPageListener listener) {
        String[] buttonNames = new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_public, NewWizardMessages.NewTypeWizardPage_modifiers_default, NewWizardMessages.NewTypeWizardPage_modifiers_private, NewWizardMessages.NewTypeWizardPage_modifiers_protected};
        SelectionButtonDialogFieldGroup result = new SelectionButtonDialogFieldGroup(16, buttonNames, 4);
        result.setDialogFieldListener((IDialogFieldListener)listener);
        result.setLabelText(NewWizardMessages.NewTypeWizardPage_modifiers_acc_label);
        result.setSelection(0, true);
        return result;
    }

    protected ListDialogField<Object> createSuperInterfacesDialogField(IListAdapter<Object> listlistener, IDialogFieldListener fieldlistener) {
        ListDialogField result = null;
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPage_interfaces_add;
        stringArray[2] = NewWizardMessages.NewTypeWizardPage_interfaces_remove;
        String[] buttonNames = stringArray;
        result = new ListDialogField(listlistener, buttonNames, (ILabelProvider)new InterfacesListLabelProvider());
        result.setDialogFieldListener(fieldlistener);
        String interfaceLabel = NewWizardMessages.NewTypeWizardPage_interfaces_class_label;
        result.setLabelText(interfaceLabel);
        result.setRemoveButtonIndex(2);
        return result;
    }

    protected StringButtonDialogField createSuperClassDialogField(NewTypeWizardPageListener listener) {
        StringButtonDialogField result = new StringButtonDialogField((IStringButtonAdapter)listener);
        result.setDialogFieldListener((IDialogFieldListener)listener);
        result.setLabelText(NewWizardMessages.NewTypeWizardPage_superclass_label);
        result.setButtonLabel(NewWizardMessages.NewTypeWizardPage_superclass_button);
        return result;
    }

    protected StringDialogField createTypeNameDialogField(NewTypeWizardPageListener listener) {
        StringDialogField result = new StringDialogField();
        result.setDialogFieldListener((IDialogFieldListener)listener);
        result.setLabelText(NewWizardMessages.NewTypeWizardPage_typename_label);
        return result;
    }

    protected StringButtonDialogField createEnclosingTypeDialogField(NewTypeWizardPageListener listener) {
        StringButtonDialogField result = new StringButtonDialogField((IStringButtonAdapter)listener);
        result.setDialogFieldListener((IDialogFieldListener)listener);
        result.setButtonLabel(NewWizardMessages.NewTypeWizardPage_enclosing_button);
        return result;
    }

    protected StringButtonStatusDialogField createPackageDialogField(NewTypeWizardPageListener listener) {
        StringButtonStatusDialogField result = new StringButtonStatusDialogField((IStringButtonAdapter)listener);
        result.setDialogFieldListener((IDialogFieldListener)listener);
        result.setLabelText(NewWizardMessages.NewTypeWizardPage_package_label);
        result.setButtonLabel(NewWizardMessages.NewTypeWizardPage_package_button);
        result.setStatusWidthHint(NewWizardMessages.NewTypeWizardPage_default);
        return result;
    }

    protected SelectionButtonDialogField createInlineSelectionDialogField(NewTypeWizardPageListener listener) {
        SelectionButtonDialogField result = new SelectionButtonDialogField(32);
        result.setDialogFieldListener((IDialogFieldListener)listener);
        result.setLabelText(OTNewWizardMessages.NewRoleWizardPage_inlined_checkbox_label);
        return result;
    }

    protected abstract SelectionButtonDialogFieldGroup createMethodStubsButtons();

    protected abstract SelectionButtonDialogFieldGroup createBindingEditorButtons();

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createInlineSelectionControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createInheritanceControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createBindingEditorControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.setAddComments(StubUtility.doAddComments((IJavaProject)this.getJavaProject()), true);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createInheritanceControls(Composite composite, int nColumns) {
        this.createSuperTypeControls(composite, nColumns);
    }

    protected void createInlineSelectionControls(Composite composite, int nColumns) {
        DialogField.createEmptySpace((Composite)composite);
        this._inlineSelectionDialogField.doFillIntoGrid(composite, nColumns - 1);
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this._packageDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this._packageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this._currPackageCompletionProcessor);
        TextFieldNavigationHandler.install((Text)text);
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this._enclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text text = this._enclosingTypeDialogField.getTextControl(composite);
        text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NewWizardMessages.NewTypeWizardPage_enclosing_field_description;
            }
        });
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        Button button = this._enclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        button.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this._enclosingTypeCompletionProcessor);
        TextFieldNavigationHandler.install((Text)text);
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this._typeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this._typeNameDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this._accessModifierButtons.getLabelControl(composite), (int)1);
        Composite control = this._accessModifierButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace((Composite)composite);
        DialogField.createEmptySpace((Composite)composite);
        control = this._otherModifierButtons.getSelectionButtonsGroup(composite);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace((Composite)composite);
    }

    protected void createSuperTypeControls(Composite composite, int nColumns) {
        this._superTypeDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this._superTypeDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        JavaTypeCompletionProcessor superClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        superClassCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewTypeWizardPage.this.getSuperClassStubTypeContext();
            }
        });
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)superClassCompletionProcessor);
        TextFieldNavigationHandler.install((Text)text);
    }

    StubTypeContext getSuperClassStubTypeContext() {
        if (this._superClassStubTypeContext == null) {
            String typeName = this._currentType != null ? this.getTypeName() : "$$__$$";
            this._superClassStubTypeContext = TypeContextChecker.createSuperClassStubTypeContext((String)typeName, (IType)this.getEnclosingType(), (IPackageFragment)this.getPackageFragment());
        }
        return this._superClassStubTypeContext;
    }

    protected IStatus typeNameChanged() {
        IPackageFragmentRoot root;
        super.typeNameChanged();
        StatusInfo status = new StatusInfo();
        this._currentType = null;
        String typeNameWithParameters = this.getTypeName();
        if (typeNameWithParameters.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
            return status;
        }
        String typeName = this.getTypeNameWithoutParameters();
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_QualifiedName);
            return status;
        }
        IStatus val = NewTypeWizardPage.validateJavaTypeName(typeName, this.getJavaProject());
        if (val.getSeverity() == 4) {
            status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, (Object)val.getMessage()));
        }
        if (!this.isEnclosingTypeSelected()) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack != null) {
                ICompilationUnit cu = pack.getCompilationUnit(this.getCompilationUnitName(typeName));
                this._currentType = cu.getType(typeName);
                IResource resource = cu.getResource();
                if (resource.exists()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                    return status;
                }
                URI location = resource.getLocationURI();
                if (location != null) {
                    try {
                        IFileStore store = EFS.getStore((URI)location);
                        if (store.fetchInfo().exists()) {
                            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExistsDifferentCase);
                            return status;
                        }
                    }
                    catch (CoreException e) {
                        status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_uri_location_unkown, (Object)Resources.getLocationString((IResource)resource)));
                    }
                }
            }
        } else {
            IType type = this.getEnclosingType();
            if (type != null) {
                this._currentType = type.getType(typeName);
                if (this._currentType.exists()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                    return status;
                }
            }
        }
        if (typeNameWithParameters != typeName && (root = this.getPackageFragmentRoot()) != null) {
            if (!JavaModelUtil.is50OrHigher((IJavaProject)root.getJavaProject())) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeParameters);
                return status;
            }
            String typeDeclaration = "class " + typeNameWithParameters + " {}";
            ASTParser parser = ASTParser.newParser((int)4);
            parser.setSource(typeDeclaration.toCharArray());
            parser.setProject(root.getJavaProject());
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
            IProblem[] problems = compilationUnit.getProblems();
            if (problems.length > 0) {
                status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)problems[0].getMessage()));
                return status;
            }
        }
        return status;
    }

    private String getTypeNameWithoutParameters() {
        String typeNameWithParameters = this.getTypeName();
        int angleBracketOffset = typeNameWithParameters.indexOf(60);
        if (angleBracketOffset == -1) {
            return typeNameWithParameters;
        }
        return typeNameWithParameters.substring(0, angleBracketOffset);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        String INTERFACE = "interface";
        this._superInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        final TableViewer tableViewer = this._superInterfacesDialogField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"interface"});
        TableTextCellEditor cellEditor = new TableTextCellEditor(tableViewer, 0){

            protected void doSetFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                    this.text.setSelection(this.text.getText().length());
                    this.checkSelection();
                    this.checkDeleteable();
                    this.checkSelectable();
                }
            }
        };
        JavaTypeCompletionProcessor superInterfaceCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        superInterfaceCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewTypeWizardPage.this.getSuperInterfacesStubTypeContext();
            }
        });
        SubjectControlContentAssistant contentAssistant = ControlContentAssistHelper.createJavaContentAssistant((IContentAssistProcessor)superInterfaceCompletionProcessor);
        Text cellEditorText = cellEditor.getText();
        ContentAssistHandler.createHandlerForText((Text)cellEditorText, (SubjectControlContentAssistant)contentAssistant);
        TextFieldNavigationHandler.install((Text)cellEditorText);
        cellEditor.setContentAssistant(contentAssistant);
        tableViewer.setCellEditors(new CellEditor[]{cellEditor});
        tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                ((InterfaceWrapper)element).interfaceName = (String)value;
                NewTypeWizardPage.this._superInterfacesDialogField.elementChanged(element);
            }

            public Object getValue(Object element, String property) {
                return ((InterfaceWrapper)element).interfaceName;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B && event.stateMask == 0) {
                    ISelection selection = tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                }
            }
        });
        GridData gd = (GridData)this._superInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(3);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    private StubTypeContext getSuperInterfacesStubTypeContext() {
        if (this._superInterfaceStubTypeContext == null) {
            String typeName = this._currentType != null ? this.getTypeName() : "$$__$$";
            this._superInterfaceStubTypeContext = TypeContextChecker.createSuperInterfaceStubTypeContext((String)typeName, (IType)this.getEnclosingType(), (IPackageFragment)this.getPackageFragment());
        }
        return this._superInterfaceStubTypeContext;
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this._methodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this._methodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
    }

    protected void createBindingEditorControls(Composite composite, int nColumns) {
        if (this._bindingEditorButtons != null) {
            DialogField.createEmptySpace((Composite)composite);
            Label labelControl = this._bindingEditorButtons.getLabelControl(composite);
            LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
            DialogField.createEmptySpace((Composite)composite);
            Composite buttonGroup = this._bindingEditorButtons.getSelectionButtonsGroup(composite);
            LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
        }
    }

    protected void createBaseClassControls(Composite composite, int nColumns) {
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
    }

    protected IJavaElement getInitialJavaElement(IStructuredSelection structuredSelection) {
        ISelection selection;
        IWorkbenchWindow window;
        IJavaElement element = super.getInitialJavaElement(structuredSelection);
        if (element != null && element.getElementType() == 5 && (window = JavaPlugin.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            try {
                IJavaElement selected = ((ICompilationUnit)element).getElementAt(textSelection.getOffset());
                if (selected != null && (selected = selected.getAncestor(7)) != null) {
                    if (((IType)selected).isLocal()) {
                        selected = ((IType)selected).getDeclaringType();
                    }
                    return selected;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return element;
    }

    protected void initTypePage(IJavaElement elem) {
        this.getInlineSelectionDialogField().setEnabled(false);
        this.initAccessModifierButtons();
        this.initOtherModifierButtons();
        this.initMethodStubButtons();
        this.initBindingEditorButtons();
        IJavaProject project = null;
        if (elem != null) {
            project = elem.getJavaProject();
            this.initPackageAndEnclosingType(elem);
        }
        this.setTypeName("");
        this.setSuperInterfaces(new ArrayList<Object>(5));
        this.setAddComments(StubUtility.doAddComments((IJavaProject)project), true);
    }

    protected void initPackageAndEnclosingType(IJavaElement initialSelectedElem) {
        IPackageFragment packageFragment;
        IType potentialEnclosingType = null;
        IType typeInCU = (IType)initialSelectedElem.getAncestor(7);
        if (typeInCU != null) {
            if (typeInCU.getCompilationUnit() != null) {
                potentialEnclosingType = typeInCU;
            }
        } else {
            ICompilationUnit cu = (ICompilationUnit)initialSelectedElem.getAncestor(5);
            if (cu != null) {
                potentialEnclosingType = cu.findPrimaryType();
            }
        }
        String packName = (packageFragment = (IPackageFragment)initialSelectedElem.getAncestor(4)) == null ? "" : packageFragment.getElementName();
        this.setPackageFragmentName(packName);
        this.setEnclosingTypeName("");
        if (potentialEnclosingType != null) {
            if (OTModelManager.hasOTElementFor((IType)potentialEnclosingType)) {
                IOTType potentialEnclosingOTType = OTModelManager.getOTElement((IType)potentialEnclosingType);
                boolean hasChanges = false;
                if (potentialEnclosingOTType.isTeam()) {
                    this.handleTeamSelected(potentialEnclosingOTType);
                    hasChanges = true;
                } else {
                    this.handleRoleSelected(potentialEnclosingOTType);
                    hasChanges = true;
                }
            } else {
                try {
                    if (potentialEnclosingType.isClass()) {
                        this.handleClassSelected(potentialEnclosingType);
                    }
                }
                catch (JavaModelException ex) {
                    OTDTUIPlugin.logException("", ex);
                }
            }
        }
    }

    private void handleTeamSelected(IOTType potentialEnclosingTeam) {
        IType enclosingTeam = null;
        IPackageFragment packageFragment = null;
        if (potentialEnclosingTeam != null) {
            enclosingTeam = (IType)potentialEnclosingTeam.getCorrespondingJavaElement();
            packageFragment = enclosingTeam.getPackageFragment();
        }
        String enclosingTeamName = enclosingTeam == null ? "" : enclosingTeam.getFullyQualifiedName('.');
        this.setEnclosingTypeName(enclosingTeamName);
        String packName = packageFragment == null ? "" : packageFragment.getElementName();
        this.setPackageFragmentName(packName);
    }

    private void handleRoleSelected(IOTType potentialEnclosingRole) {
        IType enclosingTeam = null;
        IPackageFragment packageFragment = null;
        if (potentialEnclosingRole != null) {
            IJavaElement parent;
            if (potentialEnclosingRole.isRole() && (parent = potentialEnclosingRole.getParent()) instanceof IOTType) {
                enclosingTeam = (IType)((IOTType)parent).getCorrespondingJavaElement();
                packageFragment = enclosingTeam.getPackageFragment();
            }
            if (packageFragment == null) {
                packageFragment = potentialEnclosingRole.getPackageFragment();
            }
        }
        String enclosingTeamName = enclosingTeam == null ? "" : enclosingTeam.getFullyQualifiedName('.');
        this.setEnclosingTypeName(enclosingTeamName);
        String packName = packageFragment == null ? "" : packageFragment.getElementName();
        this.setPackageFragmentName(packName);
    }

    private void handleClassSelected(IType potentialEnclosingType) {
        this.setEnclosingTypeName("");
        IPackageFragment pack = potentialEnclosingType.getPackageFragment();
        String packName = pack == null ? "" : pack.getElementName();
        this.setPackageFragmentName(packName);
    }

    protected abstract void initAccessModifierButtons();

    protected void initOtherModifierButtons() {
        this._otherModifierButtons.enableSelectionButton(2, false);
        this._otherModifierButtons.enableSelectionButton(1, true);
    }

    protected abstract void initMethodStubButtons();

    protected abstract void initBindingEditorButtons();

    public void setEnclosingType(IType type, boolean canBeModified) {
        super.setEnclosingType(type, canBeModified);
        this._enclosingType = type;
        this._canModifyEnclosingType = canBeModified;
        this.updateEnableState();
    }

    public void setEnclosingTypeName(String qualifiedName) {
        this.getEnclosingTypeDialogField().setText(qualifiedName);
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this._currentPackage = pack;
        this._canModifyPackage = canBeModified;
        this.updateEnableState();
    }

    public void setPackageFragmentName(String packageName) {
        if (this.getPackageDialogField() != null) {
            this.getPackageDialogField().setText(packageName);
        }
    }

    public void setTypeName(String name) {
        this._typeNameDialogField.setText(name);
        this._typeNameDialogField.setEnabled(true);
    }

    public void setSuperInterfaces(List<Object> interfacesNames) {
        this._superInterfacesDialogField.setElements(interfacesNames);
        this._superInterfacesDialogField.setEnabled(true);
    }

    public void setSuperType(IType type) {
        this._superType = type;
    }

    public void setSuperTypeName(String name) {
        this.getSuperTypeDialogField().setText(name);
        this.getSuperTypeDialogField().setEnabled(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
            IStatus status = StatusUtil.getMostSevere((IStatus[])this._listener.getRelevantStates(true));
            if (!status.isOK()) {
                StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
            }
        }
    }

    protected void setFocus() {
        this._typeNameDialogField.setFocus();
    }

    public SelectionButtonDialogFieldGroup getAccessModifierButtons() {
        return this._accessModifierButtons;
    }

    public SelectionButtonDialogFieldGroup getOtherModifierButtons() {
        return this._otherModifierButtons;
    }

    public SelectionButtonDialogFieldGroup getMethodStubsButtons() {
        return this._methodStubsButtons;
    }

    public abstract boolean isCreateMainSelected();

    public abstract boolean isCreateInheritedSelected();

    public abstract boolean isCreateConstructorsSelected();

    public SelectionButtonDialogFieldGroup getBindingEditorButtons() {
        return this._bindingEditorButtons;
    }

    public abstract boolean isOpenBindingEditorSelected();

    public NewTypeWizardPageListener getListener() {
        return this._listener;
    }

    public StringButtonStatusDialogField getPackageDialogField() {
        return this._packageDialogField;
    }

    public StringDialogField getTypeNameDialogField() {
        return this._typeNameDialogField;
    }

    public StringButtonDialogField getEnclosingTypeDialogField() {
        return this._enclosingTypeDialogField;
    }

    public StringButtonDialogField getSuperTypeDialogField() {
        return this._superTypeDialogField;
    }

    public SelectionButtonDialogField getInlineSelectionDialogField() {
        return this._inlineSelectionDialogField;
    }

    public ListDialogField<Object> getSuperInterfacesDialogField() {
        return this._superInterfacesDialogField;
    }

    public SelectionButtonDialogField getEnclosingTypeSelectionField() {
        return this._enclosingTypeSelection;
    }

    public String getTypeName() {
        return this.getTypeNameDialogField().getText();
    }

    public IPackageFragment getPackageFragment() {
        return this._currentPackage;
    }

    public String getPackageName() {
        if (this._packageDialogField != null) {
            return this._packageDialogField.getText();
        }
        return "";
    }

    public IType getEnclosingType() {
        return this._enclosingType;
    }

    public String getEnclosingTypeName() {
        return this.getEnclosingTypeDialogField().getText();
    }

    public boolean isInlineTypeSelected() {
        return this.getInlineSelectionDialogField().isSelected();
    }

    public IType getSuperType() {
        return this._superType;
    }

    public String getSuperTypeName() {
        return this.getSuperTypeDialogField().getText();
    }

    public List<String> getSuperInterfaces() {
        List interfaces = this._superInterfacesDialogField.getElements();
        ArrayList<String> result = new ArrayList<String>(interfaces.size());
        for (InterfaceWrapper wrapper : interfaces) {
            result.add(wrapper.interfaceName);
        }
        return result;
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this._superInterfacesDialogField.enableButton(0, root != null);
        if (root != null) {
            List elements = this._superInterfacesDialogField.getElements();
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                String intfname = ((InterfaceWrapper)elements.get((int)i)).interfaceName;
                Type type = TypeContextChecker.parseSuperInterface((String)intfname);
                if (type == null) {
                    status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidSuperInterfaceName, (Object)intfname));
                    return status;
                }
                if (type instanceof ParameterizedType && !JavaModelUtil.is50OrHigher((IJavaProject)root.getJavaProject())) {
                    status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_SuperInterfaceNotParameterized, (Object)intfname));
                    return status;
                }
                ++i;
            }
        }
        return status;
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        ArrayList<InterfaceWrapper> interfaces = new ArrayList<InterfaceWrapper>(interfacesNames.size());
        Iterator iter = interfacesNames.iterator();
        while (iter.hasNext()) {
            interfaces.add(new InterfaceWrapper((String)iter.next()));
        }
        this._superInterfacesDialogField.setElements(interfaces);
        this._superInterfacesDialogField.setEnabled(canBeModified);
    }

    public boolean addSuperInterface(String superInterface) {
        return this._superInterfacesDialogField.addElement((Object)new InterfaceWrapper(superInterface));
    }

    public int getModifiers() {
        int mdf = 0;
        if (this.getAccessModifierButtons().isSelected(0)) {
            ++mdf;
        } else if (this.getAccessModifierButtons().isSelected(2)) {
            mdf += 2;
        } else if (this.getAccessModifierButtons().isSelected(3)) {
            mdf += 4;
        }
        if (this.getOtherModifierButtons().isSelected(0)) {
            mdf += 1024;
        }
        if (this.getOtherModifierButtons().isSelected(1)) {
            mdf += 16;
        }
        if (this.getOtherModifierButtons().isSelected(2)) {
            mdf += 8;
        }
        return mdf;
    }

    public IStatus getContainerStatus() {
        return this.fContainerStatus;
    }

    public void updateStatus(IStatus[] status) {
        super.updateStatus(status);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.getListener().handleContainerChanged();
        }
    }

    public IStatus publicTypeNameChanged() {
        return this.typeNameChanged();
    }

    public boolean isEnclosingTypeSelected() {
        if (this._enclosingTypeSelection == null) {
            return super.isEnclosingTypeSelected();
        }
        return this._enclosingTypeSelection.isSelected();
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        super.setEnclosingTypeSelection(isSelected, canBeModified);
        this._enclosingTypeSelection.setSelection(isSelected);
        this._enclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnableState();
    }

    public void updateEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        if (this._packageDialogField != null) {
            this._packageDialogField.setEnabled(this._canModifyPackage && !enclosing);
        }
        this._enclosingTypeDialogField.setEnabled(this._canModifyEnclosingType && enclosing);
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        this._currPackageCompletionProcessor.setPackageFragmentRoot(this.getPackageFragmentRoot());
        if (this.getPackageFragmentRoot() != null) {
            this._enclosingTypeCompletionProcessor.setPackageFragment(this.getPackageFragmentRoot().getPackageFragment(""));
        }
        return status;
    }

    protected String getEnclosingTypeLabel() {
        return NewWizardMessages.NewTypeWizardPage_enclosing_selection_label;
    }

    IType getCurrentType() {
        return this._currentType;
    }

    public IType chooseEnclosingType() {
        return super.chooseEnclosingType();
    }

    public static IStatus validateJavaTypeName(String typeName, IJavaProject javaProject) {
        String sourceLevel = "1.5";
        String complianceLevel = "1.5";
        if (javaProject != null) {
            sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        return JavaConventions.validateJavaTypeName((String)typeName, (String)sourceLevel, (String)complianceLevel);
    }

    public static IStatus validatePackageName(String packageName, IJavaProject javaProject) {
        String sourceLevel = "1.5";
        String complianceLevel = "1.5";
        if (javaProject != null) {
            sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        return JavaConventions.validatePackageName((String)packageName, (String)sourceLevel, (String)complianceLevel);
    }

    public static class InterfaceWrapper {
        public String interfaceName;

        public InterfaceWrapper(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public int hashCode() {
            return this.interfaceName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && ((InterfaceWrapper)obj).interfaceName.equals(this.interfaceName);
        }
    }

    private static class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");

        public String getText(Object element) {
            return ((InterfaceWrapper)element).interfaceName;
        }

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }
}

