/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.objectteams.otdt.core.ext.OTDTPlugin;
import org.eclipse.objectteams.otdt.core.ext.OTREContainer;
import org.eclipse.objectteams.otdt.internal.ui.wizards.OTNewWizardMessages;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class OTNewProjectWizard
extends BasicNewProjectResourceWizard
implements IExecutableExtension {
    private IConfigurationElement _configElement;
    private JavaCapabilityConfigurationPage _javaPage;
    private WizardNewProjectCreationPage _mainPage;
    private IWorkbench _workbench;

    public OTNewProjectWizard() {
        this.setDefaultPageImageDescriptor(OTDTUIPlugin.getDefault().getImageRegistry().getDescriptor("wizard/newotjprj_wiz.png"));
        this.setDialogSettings(OTDTUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(OTDTUIPlugin.getResourceString("NewOTProjectCreationWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._workbench = workbench;
    }

    public void addPages() {
        this._mainPage = new WizardNewProjectCreationPage("NewOTProjectCreationWizard");
        this._mainPage.setTitle(OTDTUIPlugin.getResourceString("NewOTProjectCreationWizard.MainPage.title"));
        this._mainPage.setDescription(OTDTUIPlugin.getResourceString("NewOTProjectCreationWizard.MainPage.description"));
        this.addPage((IWizardPage)this._mainPage);
        this._javaPage = new JavaCapabilityConfigurationPage(){

            public void setVisible(boolean visible) {
                OTNewProjectWizard.this.updateJavaPage();
                super.setVisible(visible);
            }
        };
        this.addPage((IWizardPage)this._javaPage);
    }

    private void updateJavaPage() {
        IJavaProject jproject = JavaCore.create((IProject)this._mainPage.getProjectHandle());
        if (!jproject.equals(this._javaPage.getJavaProject())) {
            IClasspathEntry[] buildPath = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)jproject.getPath().append("src")), JavaRuntime.getDefaultJREContainerEntry()};
            IPath outputLocation = jproject.getPath().append("bin");
            this._javaPage.init(jproject, outputLocation, buildPath, false);
        }
    }

    private void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(OTNewWizardMessages.NewProjectWizard_task_title, 4);
            IProject project = this._mainPage.getProjectHandle();
            IPath locationPath = this._mainPage.getLocationPath();
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            if (!this._mainPage.useDefaults()) {
                desc.setLocation(locationPath);
            }
            desc.setNatureIds(OTDTPlugin.createProjectNatures((IProjectDescription)desc));
            desc.setBuildSpec(OTDTPlugin.createProjectBuildCommands((IProjectDescription)desc));
            project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.updateJavaPage();
            this._javaPage.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            OTREContainer.initializeOTJProject((IProject)project);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this._configElement);
            BasicNewResourceWizard.selectAndReveal((IResource)project, (IWorkbenchWindow)this._workbench.getActiveWorkbenchWindow());
        }
        finally {
            monitor.done();
        }
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                OTNewProjectWizard.this.finishPage(monitor);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof CoreException) {
                CoreException core = (CoreException)ex.getTargetException();
                ErrorDialog.openError((Shell)this.getShell(), (String)OTNewWizardMessages.NewProjectWizard_error_title, (String)core.getMessage(), (IStatus)core.getStatus());
            }
            String title = OTNewWizardMessages.NewProjectWizard_wizard_creation_failure_title;
            String message = OTNewWizardMessages.NewProjectWizard_wizard_creation_failure_message;
            OTDTUIPlugin.logException("Wizard title" + title + ": " + message, ex);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this._configElement = cfig;
    }
}

