/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal.hook;

import java.util.HashMap;
import org.eclipse.objectteams.otequinox.hook.ClassScanner;
import org.eclipse.objectteams.otequinox.hook.IAspectRegistry;
import org.eclipse.objectteams.otequinox.hook.ITeamLoader;
import org.eclipse.objectteams.otequinox.internal.hook.AspectBundleRole;
import org.eclipse.objectteams.otequinox.internal.hook.BaseBundleRole;
import org.osgi.framework.Bundle;

public class BundleRegistry {
    HashMap<String, BaseBundleRole> adaptedBaseBundles = new HashMap();
    HashMap<String, AspectBundleRole> aspectBundles = new HashMap();

    public boolean isAdaptedBaseBundle(String symbolicName) {
        return this.adaptedBaseBundles.containsKey(symbolicName);
    }

    void createAspectRole(String symbolicName) {
        this.aspectBundles.put(symbolicName, new AspectBundleRole(true));
    }

    void resetLoading(String[] aspects) {
        String[] stringArray = aspects;
        int n = aspects.length;
        int n2 = 0;
        while (n2 < n) {
            String aspect = stringArray[n2];
            this.aspectBundles.get((Object)aspect).isLoading = false;
            ++n2;
        }
    }

    BaseBundleRole createWaitingBase(Bundle baseBundle) {
        String symbolicName = baseBundle.getSymbolicName();
        BaseBundleRole baseRole = this.adaptedBaseBundles.get(symbolicName);
        if (baseRole == null) {
            baseRole = new BaseBundleRole(baseBundle);
            this.adaptedBaseBundles.put(symbolicName, baseRole);
        }
        baseRole.setup(baseBundle, BaseBundleRole.State.WAIT_FOR_TEAM);
        return baseRole;
    }

    void checkLoadTeams(Bundle baseBundle, IAspectRegistry registry, ITeamLoader loader, ClassScanner scanner) {
        String[] aspectBundleNames = registry.getAdaptingAspectPlugins(baseBundle);
        if (aspectBundleNames.length == 0) {
            return;
        }
        try {
            String[] stringArray = aspectBundleNames;
            int n = aspectBundleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String aspect = stringArray[n2];
                this.createAspectRole(aspect);
                ++n2;
            }
            BaseBundleRole baseRole = this.createWaitingBase(baseBundle);
            baseRole.loadTeams(loader, scanner);
        }
        finally {
            this.resetLoading(aspectBundleNames);
        }
    }
}

