/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;

public class OCL2JavaFileObject
extends SimpleJavaFileObject {
    private static JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static StandardJavaFileManager stdFileManager = compiler.getStandardFileManager(null, Locale.getDefault(), null);
    private static List<String> compilationOptions = Arrays.asList("-d", "bin", "-source", "1.5", "-target", "1.5", "-g");
    private String javaCode;

    public static Class<?> loadClass(String qualifiedName, String javaCodeSource) throws Exception {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        List<OCL2JavaFileObject> compilationUnits = Collections.singletonList(new OCL2JavaFileObject(qualifiedName, javaCodeSource));
        JavaCompiler.CompilationTask compilerTask = compiler.getTask(null, stdFileManager, diagnostics, compilationOptions, null, compilationUnits);
        if (!compilerTask.call().booleanValue()) {
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                s.append("\n" + diagnostic);
            }
            if (s.length() > 0) {
                throw new IOException("Failed to compile " + qualifiedName + s.toString());
            }
            System.out.println("Compilation of " + qualifiedName + " returned false but no diagnostics");
        }
        stdFileManager.close();
        Class<?> testClass = Class.forName(qualifiedName);
        return testClass;
    }

    public static LibraryOperation loadLibraryOperationClass(String qualifiedName, String javaCodeSource) throws Exception {
        Class<?> testClass = OCL2JavaFileObject.loadClass(qualifiedName, javaCodeSource);
        Field testField = testClass.getField("INSTANCE");
        return (LibraryOperation)testField.get(null);
    }

    public OCL2JavaFileObject(String qualifiedName, String javaCode) {
        super(URI.create("string:///" + qualifiedName.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this.javaCode = javaCode;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.javaCode;
    }
}

