/**
 * <copyright>
 * 
 * Copyright (c) 2013 CEA LIST and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   E.D.Willink(CEA LIST) - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.ocl.examples.codegen.cgmodel.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePartCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.CGModelVisitor;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CG Tuple Part Call Exp</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.ocl.examples.codegen.cgmodel.impl.CGTuplePartCallExpImpl#getPivotTuplePartId <em>Pivot Tuple Part Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CGTuplePartCallExpImpl extends CGPropertyCallExpImpl implements CGTuplePartCallExp {
	/**
	 * The default value of the '{@link #getPivotTuplePartId() <em>Pivot Tuple Part Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPivotTuplePartId()
	 * @generated
	 * @ordered
	 */
	protected static final TuplePartId PIVOT_TUPLE_PART_ID_EDEFAULT = null;
	/**
	 * The cached value of the '{@link #getPivotTuplePartId() <em>Pivot Tuple Part Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPivotTuplePartId()
	 * @generated
	 * @ordered
	 */
	protected TuplePartId pivotTuplePartId = PIVOT_TUPLE_PART_ID_EDEFAULT;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CGTuplePartCallExpImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return CGModelPackage.Literals.CG_TUPLE_PART_CALL_EXP;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TuplePartId getPivotTuplePartId() {
		return pivotTuplePartId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPivotTuplePartId(TuplePartId newPivotTuplePartId) {
		TuplePartId oldPivotTuplePartId = pivotTuplePartId;
		pivotTuplePartId = newPivotTuplePartId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CGModelPackage.CG_TUPLE_PART_CALL_EXP__PIVOT_TUPLE_PART_ID, oldPivotTuplePartId, pivotTuplePartId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case CGModelPackage.CG_TUPLE_PART_CALL_EXP__PIVOT_TUPLE_PART_ID:
				return getPivotTuplePartId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case CGModelPackage.CG_TUPLE_PART_CALL_EXP__PIVOT_TUPLE_PART_ID:
				setPivotTuplePartId((TuplePartId)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case CGModelPackage.CG_TUPLE_PART_CALL_EXP__PIVOT_TUPLE_PART_ID:
				setPivotTuplePartId(PIVOT_TUPLE_PART_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case CGModelPackage.CG_TUPLE_PART_CALL_EXP__PIVOT_TUPLE_PART_ID:
				return PIVOT_TUPLE_PART_ID_EDEFAULT == null ? pivotTuplePartId != null : !PIVOT_TUPLE_PART_ID_EDEFAULT.equals(pivotTuplePartId);
		}
		return super.eIsSet(featureID);
	}

	@Override
	public <R> R accept(@NonNull CGModelVisitor<R> visitor) {
		return visitor.visitCGTuplePartCallExp(this);
	}

	@Override
	public boolean isBoxed() {
		return true;
	}

	@Override
	public boolean isInvalid() {
		return false;
	}

	@Override
	public boolean isNonInvalid() {
		return true;
	}

	@Override
	public boolean isUnboxed() {
		return false;
	}

	@Override
	public String toString() {
		return super.toString();
	}
} //CGTuplePartCallExpImpl
