/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.analyzer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;

public class CGUtils {
    @NonNull
    public static CGParameter createCGParameter(@NonNull String name, @NonNull CGTypeId typeId) {
        CGParameter cgParameter = CGModelFactory.eINSTANCE.createCGParameter();
        cgParameter.setName(name);
        cgParameter.setTypeId(typeId);
        return cgParameter;
    }

    @Nullable
    public static CGClass getContainingClass(@NonNull CGElement cgExpression) {
        CGElement cgElement = cgExpression;
        while (cgElement != null) {
            if (cgElement instanceof CGClass) {
                return (CGClass)cgElement;
            }
            cgElement = cgElement.getParent();
        }
        return null;
    }

    public static boolean isInlineableId(@NonNull ElementId elementId) {
        return elementId instanceof PrimitiveTypeId || elementId instanceof OclVoidTypeId || elementId instanceof TemplateParameterId;
    }

    @NonNull
    public static CGValuedElement replace(@NonNull CGValuedElement oldElement, @NonNull CGValuedElement newElement) {
        EcoreUtil.replace((EObject)oldElement, (EObject)newElement);
        return oldElement;
    }

    public static void wrap(@NonNull CGCallExp wrapExp, @NonNull CGValuedElement wrappedExp) {
        wrapExp.setTypeId(wrappedExp.getTypeId());
        wrapExp.setPivot(wrappedExp.getPivot());
        CGUtils.replace(wrappedExp, wrapExp);
        wrapExp.setSource(wrappedExp);
    }
}

