/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.generator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.generator.CodeGenOptions;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.FinalAnalysis;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public abstract class AbstractCodeGenerator
implements CodeGenerator {
    @NonNull
    public static final String ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL = "org.eclipse.jdt.annotation.NonNull";
    @NonNull
    public static final String ORG_ECLIPSE_JDT_ANNOTATION_NULLABLE = "org.eclipse.jdt.annotation.Nullable";
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final NameManager nameManager;
    @NonNull
    protected final GenModelHelper genModelHelper;
    private CodeGenOptions options = null;
    private List<Exception> problems = null;
    @NonNull
    private String defaultIndent = "    ";

    protected AbstractCodeGenerator(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
        this.nameManager = this.createNameManager();
        this.genModelHelper = this.createGenModelHelper();
    }

    protected AbstractCodeGenerator(@NonNull MetaModelManager metaModelManager, @NonNull NameManager nameManager, @NonNull GenModelHelper genModelHelper) {
        this.metaModelManager = metaModelManager;
        this.nameManager = nameManager;
        this.genModelHelper = genModelHelper;
    }

    public void addProblem(@NonNull Exception problem) {
        List<Exception> problems2 = this.problems;
        if (problems2 == null) {
            this.problems = problems2 = new ArrayList<Exception>();
        }
        problems2.add(problem);
    }

    @NonNull
    public AnalysisVisitor createAnalysisVisitor() {
        return new AnalysisVisitor(this.getAnalyzer());
    }

    @NonNull
    protected abstract GenModelHelper createGenModelHelper();

    @NonNull
    protected abstract NameManager createNameManager();

    @NonNull
    protected CodeGenOptions createOptions() {
        return new CodeGenOptions();
    }

    @NonNull
    public String getDefaultIndent() {
        return this.defaultIndent;
    }

    @NonNull
    public GenModelHelper getGenModelHelper() {
        return this.genModelHelper;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public NameManager getNameManager() {
        return this.nameManager;
    }

    @NonNull
    public CodeGenOptions getOptions() {
        CodeGenOptions options2 = this.options;
        if (options2 == null) {
            this.options = options2 = this.createOptions();
        }
        return options2;
    }

    @Nullable
    public DomainOperation isFinal(@NonNull Operation anOperation, @NonNull Type staticType) {
        FinalAnalysis finalAnalysis = this.metaModelManager.getPackageManager().getFinalAnalysis();
        return finalAnalysis.isFinal((DomainOperation)anOperation, this.metaModelManager.getInheritance((DomainType)staticType));
    }
}

