/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreClassConstructorExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorCompositionProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorNavigationProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositeProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGText;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.java.types.JavaTypeId;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibrarySimpleOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUntypedOperation;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CG2JavaPreVisitor
extends AbstractExtendingCGModelVisitor<Object, JavaGlobalContext> {
    @NonNull
    protected final JavaCodeGenerator codeGenerator;
    @NonNull
    protected final GenModelHelper genModelHelper;
    @NonNull
    protected final CodeGenAnalyzer analyzer;
    protected JavaLocalContext localContext;

    public CG2JavaPreVisitor(@NonNull JavaGlobalContext javaContext) {
        super(javaContext);
        this.codeGenerator = javaContext.getCodeGenerator();
        this.analyzer = this.codeGenerator.getAnalyzer();
        this.genModelHelper = this.codeGenerator.getGenModelHelper();
    }

    protected void doTypedElement(@NonNull CGTypedElement cgTypedElement) {
        CGTypeId cgTypeId = cgTypedElement.getTypeId();
        if (cgTypeId != null) {
            cgTypeId.accept(this);
        }
    }

    protected void doValuedElement(@NonNull CGValuedElement cgValuedElement) {
        CGValuedElement value = cgValuedElement.getValue();
        if (value.isGlobal()) {
            ((JavaGlobalContext)this.context).addGlobal(value);
        }
        if (cgValuedElement.getValue() == cgValuedElement) {
            if (this.localContext != null) {
                this.localContext.getValueName(cgValuedElement);
            } else {
                ((JavaGlobalContext)this.context).getValueName(cgValuedElement);
            }
        }
    }

    @NonNull
    public JavaCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @NonNull
    protected CGValuedElement getIdResolverVariable() {
        CGValuedElement idResolverVariable = this.localContext.getIdResolverVariable();
        CGTypeId type = idResolverVariable.getTypeId();
        type.accept(this);
        return idResolverVariable;
    }

    @NonNull
    protected CGText getStandardLibraryVariable() {
        this.getIdResolverVariable();
        CGText standardLibraryVariable = this.localContext.getStandardLibraryVariable();
        CGTypeId type = standardLibraryVariable.getTypeId();
        type.accept(this);
        return standardLibraryVariable;
    }

    @Override
    @Nullable
    public Object visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    @Nullable
    public Object visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        TypeDescriptor unboxedTypeDescriptor;
        CGValuedElement unboxedValue = cgBoxExp.getSource();
        if (unboxedValue != null && (unboxedTypeDescriptor = this.codeGenerator.getTypeDescriptor(unboxedValue)).isAssignableTo(Iterable.class)) {
            this.getIdResolverVariable();
        }
        return super.visitCGBoxExp(cgBoxExp);
    }

    @Override
    @Nullable
    public Object visitCGCollectionPart(@NonNull CGCollectionPart cgCollectionPart) {
        boolean isRange = cgCollectionPart.isRange();
        if (cgCollectionPart.isConstant() && isRange) {
            ((JavaGlobalContext)this.context).addGlobal(cgCollectionPart);
        }
        return super.visitCGCollectionPart(cgCollectionPart);
    }

    @Override
    @Nullable
    public Object visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement referredConstant = cgConstantExp.getReferredConstant();
        if (referredConstant != null) {
            referredConstant.accept(this);
        }
        return super.visitCGConstantExp(cgConstantExp);
    }

    @Override
    @Nullable
    public Object visitCGConstraint(@NonNull CGConstraint cgConstraint) {
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgConstraint);
        try {
            Object r = super.visitCGConstraint(cgConstraint);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    @Nullable
    public Object visitCGConstructorPart(@NonNull CGConstructorPart cgConstructorPart) {
        PropertyId propertyId = ((ConstructorPart)cgConstructorPart.getPivot()).getReferredProperty().getPropertyId();
        CGExecutorConstructorPart cgExecutorConstructorPart = this.analyzer.getExecutorConstructorPart(propertyId);
        cgExecutorConstructorPart.accept(this);
        JavaTypeId javaPropertyTypeId = JavaConstants.DOMAIN_PROPERTY_TYPE_ID;
        cgExecutorConstructorPart.setTypeId(this.analyzer.getTypeId((TypeId)javaPropertyTypeId));
        this.localContext.addLocalVariable(cgExecutorConstructorPart);
        cgExecutorConstructorPart.getDependsOn().add(this.getIdResolverVariable());
        cgConstructorPart.getDependsOn().add(cgExecutorConstructorPart);
        cgConstructorPart.getDependsOn().add(cgConstructorPart.getConstructorExp());
        return super.visitCGConstructorPart(cgConstructorPart);
    }

    @Override
    @Nullable
    public Object visitCGEcoreClassConstructorExp(@NonNull CGEcoreClassConstructorExp cgConstructorExp) {
        TypeId typeId = ((ConstructorExp)cgConstructorExp.getPivot()).getTypeId();
        CGExecutorType cgExecutorType = this.localContext.getExecutorType(typeId);
        cgExecutorType.accept(this);
        this.localContext.getOuterContext().addLocalVariable(cgExecutorType);
        return super.visitCGEcoreClassConstructorExp(cgConstructorExp);
    }

    @Override
    @Nullable
    public Object visitCGElement(@NonNull CGElement cgElement) {
        for (CGElement cGElement : cgElement.getChildren()) {
            cGElement.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorCompositionProperty(@NonNull CGExecutorCompositionProperty cgExecutorProperty) {
        Property pivotProperty = (Property)cgExecutorProperty.getPivot();
        Property pivotOppositeProperty = pivotProperty.getOpposite();
        if (pivotOppositeProperty != null && pivotOppositeProperty.isComposite()) {
            JavaTypeId javaPropertyTypeId = JavaConstants.UNBOXED_COMPOSITION_PROPERTY_TYPE_ID;
            cgExecutorProperty.setTypeId(this.analyzer.getTypeId((TypeId)javaPropertyTypeId));
        }
        return super.visitCGExecutorCompositionProperty(cgExecutorProperty);
    }

    @Override
    @Nullable
    public Object visitCGExecutorNavigationProperty(@NonNull CGExecutorNavigationProperty cgExecutorProperty) {
        JavaTypeId javaPropertyTypeId = JavaConstants.UNBOXED_EXPLICIT_NAVIGATION_PROPERTY_TYPE_ID;
        cgExecutorProperty.setTypeId(this.analyzer.getTypeId((TypeId)javaPropertyTypeId));
        return super.visitCGExecutorNavigationProperty(cgExecutorProperty);
    }

    @Override
    @Nullable
    public Object visitCGExecutorOperation(@NonNull CGExecutorOperation cgExecutorOperation) {
        this.getIdResolverVariable();
        CGElementId cgOperationId = cgExecutorOperation.getUnderlyingOperationId();
        if (cgOperationId != null) {
            cgOperationId.accept(this);
        }
        cgExecutorOperation.getDependsOn().add(this.getIdResolverVariable());
        return super.visitCGExecutorOperation(cgExecutorOperation);
    }

    @Override
    @Nullable
    public Object visitCGExecutorOperationCallExp(@NonNull CGExecutorOperationCallExp cgExecutorOperationCallExp) {
        Operation referredOperation = cgExecutorOperationCallExp.getReferredOperation();
        OperationId operationId = referredOperation.getOperationId();
        CGExecutorOperation cgExecutorOperation = this.analyzer.getExecutorOperation(operationId);
        cgExecutorOperation.accept(this);
        this.localContext.getOuterContext().addLocalVariable(cgExecutorOperation);
        return super.visitCGExecutorOperationCallExp(cgExecutorOperationCallExp);
    }

    @Override
    @Nullable
    public Object visitCGExecutorOppositeProperty(@NonNull CGExecutorOppositeProperty cgExecutorProperty) {
        JavaTypeId javaPropertyTypeId = JavaConstants.UNBOXED_OPPOSITE_NAVIGATION_PROPERTY_TYPE_ID;
        cgExecutorProperty.setTypeId(this.analyzer.getTypeId((TypeId)javaPropertyTypeId));
        return super.visitCGExecutorOppositeProperty(cgExecutorProperty);
    }

    @Override
    @Nullable
    public Object visitCGExecutorProperty(@NonNull CGExecutorProperty cgExecutorProperty) {
        CGElementId cgPropertyId = cgExecutorProperty.getUnderlyingPropertyId();
        if (cgPropertyId != null) {
            cgPropertyId.accept(this);
        }
        return super.visitCGExecutorProperty(cgExecutorProperty);
    }

    @Override
    @Nullable
    public Object visitCGExecutorPropertyCallExp(@NonNull CGExecutorPropertyCallExp cgExecutorPropertyCallExp) {
        Property referredProperty = cgExecutorPropertyCallExp.getReferredProperty();
        PropertyId propertyId = referredProperty.getPropertyId();
        CGExecutorProperty cgExecutorProperty = this.analyzer.getExecutorProperty(propertyId);
        cgExecutorProperty.accept(this);
        this.localContext.getOuterContext().addLocalVariable(cgExecutorProperty);
        cgExecutorProperty.getDependsOn().add(this.getIdResolverVariable());
        return super.visitCGExecutorPropertyCallExp(cgExecutorPropertyCallExp);
    }

    @Override
    @Nullable
    public Object visitCGExecutorType(@NonNull CGExecutorType cgExecutorType) {
        this.getIdResolverVariable();
        CGTypeId cgTypeId = cgExecutorType.getUnderlyingTypeId();
        if (cgTypeId != null) {
            cgTypeId.accept(this);
        }
        return super.visitCGExecutorType(cgExecutorType);
    }

    @Override
    @Nullable
    public Object visitCGIterationCallExp(@NonNull CGIterationCallExp cgIterationCallExp) {
        this.doValuedElement(cgIterationCallExp);
        this.doTypedElement(cgIterationCallExp);
        CGValuedElement cgSource = cgIterationCallExp.getSource();
        if (cgSource != null) {
            cgSource.accept(this);
        }
        for (CGIterator cgIterator : cgIterationCallExp.getIterators()) {
            CGValuedElement cgInit = cgIterator.getInit();
            if (cgInit == null) continue;
            cgInit.accept(this);
        }
        JavaLocalContext savedLocalContext = this.localContext;
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgIterationCallExp);
        try {
            CGValuedElement cgBody = cgIterationCallExp.getBody();
            if (cgBody != null) {
                cgBody.accept(this);
            }
            for (CGIterator cgIterator : cgIterationCallExp.getIterators()) {
                cgIterator.accept(this);
            }
            return null;
        }
        finally {
            this.localContext = savedLocalContext;
        }
    }

    @Override
    @Nullable
    public Object visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        CGValuedElement in = cgLetExp.getIn();
        return super.visitCGLetExp(cgLetExp);
    }

    @Override
    @Nullable
    public Object visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgLibraryIterateCallExp) {
        this.getStandardLibraryVariable();
        return super.visitCGLibraryIterateCallExp(cgLibraryIterateCallExp);
    }

    @Override
    @Nullable
    public Object visitCGLibraryIterationCallExp(@NonNull CGLibraryIterationCallExp cgLibraryIterationCallExp) {
        this.getStandardLibraryVariable();
        return super.visitCGLibraryIterationCallExp(cgLibraryIterationCallExp);
    }

    @Override
    @Nullable
    public Object visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp cgOperationCallExp) {
        LibraryOperation libraryOperation = cgOperationCallExp.getLibraryOperation();
        try {
            Object r = super.visitCGLibraryOperationCallExp(cgOperationCallExp);
            return r;
        }
        finally {
            if (!(libraryOperation instanceof LibrarySimpleOperation)) {
                CGTypeId cgTypeId;
                this.localContext.getEvaluatorParameter();
                if (!(libraryOperation instanceof LibraryUntypedOperation) && (cgTypeId = cgOperationCallExp.getTypeId()) != null) {
                    ((JavaGlobalContext)this.context).addGlobal(cgTypeId);
                }
            }
        }
    }

    @Override
    @Nullable
    public Object visitCGLibraryPropertyCallExp(@NonNull CGLibraryPropertyCallExp cgPropertyCallExp) {
        try {
            Object r = super.visitCGLibraryPropertyCallExp(cgPropertyCallExp);
            return r;
        }
        finally {
            this.localContext.getEvaluatorParameter();
            CGTypeId cgTypeId = cgPropertyCallExp.getTypeId();
            if (cgTypeId != null) {
                ((JavaGlobalContext)this.context).addGlobal(cgTypeId);
            }
        }
    }

    @Override
    @Nullable
    public Object visitCGOperation(@NonNull CGOperation cgOperation) {
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgOperation);
        try {
            Object r = super.visitCGOperation(cgOperation);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    @Nullable
    public Object visitCGProperty(@NonNull CGProperty cgProperty) {
        this.localContext = ((JavaGlobalContext)this.context).getLocalContext(cgProperty);
        try {
            Object r = super.visitCGProperty(cgProperty);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    @Nullable
    public Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        CGExecutorType cgType = cgTypeExp.getReferredType();
        if (cgType != null) {
            cgType.accept(this);
        }
        return super.visitCGTypeExp(cgTypeExp);
    }

    @Override
    @Nullable
    public Object visitCGTypedElement(@NonNull CGTypedElement cgTypedElement) {
        this.doTypedElement(cgTypedElement);
        return super.visitCGTypedElement(cgTypedElement);
    }

    @Override
    @Nullable
    public Object visitCGValuedElement(@NonNull CGValuedElement cgValuedElement) {
        super.visitCGValuedElement(cgValuedElement);
        this.doValuedElement(cgValuedElement);
        return null;
    }

    @Override
    @Nullable
    public Object visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        CGVariable cgVariable = cgVariableExp.getReferredVariable();
        if (cgVariable != null) {
            cgVariable.accept(this);
            if (cgVariable instanceof CGParameter) {
                CGParameter castParameter = this.localContext.getCastParameter((CGParameter)cgVariable);
                cgVariableExp.setReferredVariable(castParameter);
                cgVariableExp.getDependsOn().add(castParameter);
            }
        }
        return super.visitCGVariableExp(cgVariableExp);
    }
}

