/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoolean;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBuiltInIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCastParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCatchExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGCollectionPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstantExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstraint;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreDataTypeConstructorExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcoreOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGEcorePropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElementId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorCompositionProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorConstructorPart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorNavigationProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorOppositeProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGGuardExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIfExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInfinity;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInteger;
import org.eclipse.ocl.examples.codegen.cgmodel.CGInvalid;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsInvalidExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIsUndefinedExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGIterator;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLetExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterateCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryIterationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryOperationCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGLibraryPropertyCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNull;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGProperty;
import org.eclipse.ocl.examples.codegen.cgmodel.CGReal;
import org.eclipse.ocl.examples.codegen.cgmodel.CGString;
import org.eclipse.ocl.examples.codegen.cgmodel.CGText;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTextParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGThrowExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTupleExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePart;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTuplePartCallExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeId;
import org.eclipse.ocl.examples.codegen.cgmodel.CGUnboxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariableExp;
import org.eclipse.ocl.examples.codegen.cgmodel.util.AbstractExtendingCGModelVisitor;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.Id2JavaExpressionVisitor;
import org.eclipse.ocl.examples.codegen.java.Id2JavaInterfaceVisitor;
import org.eclipse.ocl.examples.codegen.java.Iteration2Java;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaDependencyVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryIteration;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.library.LibrarySimpleOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUntypedOperation;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.impl.IntIntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.LongIntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorDoubleIterationManager;
import org.eclipse.ocl.examples.library.executor.ExecutorSingleIterationManager;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CG2JavaVisitor
extends AbstractExtendingCGModelVisitor<Object, JavaCodeGenerator> {
    @NonNull
    protected final JavaGlobalContext globalContext;
    @NonNull
    protected final GenModelHelper genModelHelper;
    @NonNull
    protected final CodeGenAnalyzer analyzer;
    @NonNull
    protected final Id2JavaInterfaceVisitor id2JavaInterfaceVisitor;
    @NonNull
    protected final JavaStream js;
    protected JavaLocalContext localContext;

    public CG2JavaVisitor(@NonNull JavaCodeGenerator codeGenerator) {
        super(codeGenerator);
        this.globalContext = codeGenerator.getGlobalContext();
        this.genModelHelper = ((JavaCodeGenerator)this.context).getGenModelHelper();
        this.analyzer = ((JavaCodeGenerator)this.context).getAnalyzer();
        this.id2JavaInterfaceVisitor = this.createId2JavaClassVisitor();
        this.js = new JavaStream(codeGenerator, this);
    }

    protected void addImport(@NonNull String className) {
        this.globalContext.addImport(className);
    }

    protected void appendGlobalPrefix() {
    }

    @NonNull
    protected Id2JavaInterfaceVisitor createId2JavaClassVisitor() {
        return new Id2JavaInterfaceVisitor();
    }

    @NonNull
    protected Id2JavaExpressionVisitor createId2JavaExpressionVisitor(@NonNull JavaStream javaStream) {
        return new Id2JavaExpressionVisitor(javaStream);
    }

    public void generateGlobals(@NonNull Iterable<? extends CGValuedElement> sortedElements) {
        for (CGValuedElement cGValuedElement : sortedElements) {
            if (cGValuedElement.isInlineable() || !cGValuedElement.isConstant() || !cGValuedElement.isGlobal()) continue;
            cGValuedElement.accept(this);
        }
    }

    @NonNull
    public Set<String> getAllImports() {
        return this.globalContext.getImports();
    }

    @NonNull
    public CodeGenAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @NonNull
    public JavaCodeGenerator getCodeGenerator() {
        return (JavaCodeGenerator)this.context;
    }

    @NonNull
    protected CGValuedElement getExpression(@Nullable CGValuedElement cgExpression) {
        return this.analyzer.getExpression(cgExpression);
    }

    @NonNull
    public GenModelHelper getGenModelHelper() {
        return this.genModelHelper;
    }

    private Class<?> getJavaReturnClass(@NonNull LibraryIteration libraryIteration) {
        try {
            Class<?> implementationClass = libraryIteration.getClass();
            Method method = implementationClass.getMethod("evaluateIteration", DomainIterationManager.class);
            return method.getReturnType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Class<?> getJavaReturnClass(@NonNull LibraryOperation libraryOperation, int argumentSize) {
        try {
            Class<?> implementationClass = libraryOperation.getClass();
            Class[] arguments = new Class[argumentSize + 3];
            arguments[0] = DomainEvaluator.class;
            arguments[1] = TypeId.class;
            arguments[2] = Object.class;
            int i = 0;
            while (i < argumentSize) {
                arguments[3 + i] = Object.class;
                ++i;
            }
            Method method = implementationClass.getMethod("evaluate", arguments);
            return method.getReturnType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Class<?> getJavaReturnClass(@NonNull LibraryProperty libraryProperty) {
        try {
            Class<?> implementationClass = libraryProperty.getClass();
            Class[] arguments = new Class[]{DomainEvaluator.class, TypeId.class, Object.class};
            Method method = implementationClass.getMethod("evaluate", arguments);
            return method.getReturnType();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    protected Class<?> getLeastDerivedClass(Class<?> requiredClass, @NonNull String getAccessor) {
        Class<?> superClass = requiredClass.getSuperclass();
        if (superClass != null) {
            try {
                Class<?> lessDerivedSuperClass = this.getLeastDerivedClass(superClass, getAccessor);
                if (lessDerivedSuperClass != null) {
                    return lessDerivedSuperClass;
                }
                Method method = superClass.getMethod(getAccessor, new Class[0]);
                if (method != null) {
                    return superClass;
                }
            }
            catch (Exception lessDerivedSuperClass) {
                // empty catch block
            }
        }
        Class<?>[] classArray = requiredClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            Class<?> lessDerivedSuperInterface = this.getLeastDerivedClass(superInterface, getAccessor);
            if (lessDerivedSuperInterface != null) {
                return lessDerivedSuperInterface;
            }
            try {
                Method method = superInterface.getMethod(getAccessor, new Class[0]);
                if (method != null) {
                    return superInterface;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    protected Method getLeastDerivedMethod(@NonNull Class<?> requiredClass, @NonNull String getAccessor) {
        Method leastDerivedMethod = this.getLeastDerivedMethodInternal(requiredClass, getAccessor);
        if (leastDerivedMethod != null) {
            return leastDerivedMethod;
        }
        try {
            return requiredClass.getMethod(getAccessor, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private Method getLeastDerivedMethodInternal(@NonNull Class<?> requiredClass, @NonNull String getAccessor) {
        Class<?> superClass = requiredClass.getSuperclass();
        if (superClass != null) {
            try {
                Method lessDerivedSuperMethod = this.getLeastDerivedMethodInternal(superClass, getAccessor);
                if (lessDerivedSuperMethod != null) {
                    return lessDerivedSuperMethod;
                }
                Method method = superClass.getMethod(getAccessor, new Class[0]);
                if (method != null) {
                    return method;
                }
            }
            catch (Exception lessDerivedSuperMethod) {
                // empty catch block
            }
        }
        Class<?>[] classArray = requiredClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            Method lessDerivedSuperMethod = this.getLeastDerivedMethodInternal(superInterface, getAccessor);
            if (lessDerivedSuperMethod != null) {
                return lessDerivedSuperMethod;
            }
            try {
                Method method = superInterface.getMethod(getAccessor, new Class[0]);
                if (method != null) {
                    return method;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    @NonNull
    protected MetaModelManager getMetaModelManager() {
        return ((JavaCodeGenerator)this.context).getMetaModelManager();
    }

    @NonNull
    protected String getValueName(@NonNull CGValuedElement cgElement) {
        String name = cgElement.getValueName();
        if (name == null) {
            name = cgElement.getName();
        }
        if (name == null) {
            name = "<null-" + cgElement.eClass().getName() + ">";
        }
        return name;
    }

    protected String getValueName2(@NonNull CGValuedElement cgElement) {
        String valueName = this.localContext != null ? this.localContext.getValueName(cgElement) : this.globalContext.getValueName(cgElement);
        return valueName;
    }

    @NonNull
    public String toString() {
        String string = this.js.toString();
        return string;
    }

    @Override
    @Nullable
    public Object visiting(@NonNull CGElement visitable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    @Override
    @Nullable
    public Object visitCGBoolean(@NonNull CGBoolean cgBoolean) {
        boolean booleanValue = cgBoolean.isBooleanValue();
        if (booleanValue) {
            this.js.appendTrue();
        } else {
            this.js.appendFalse();
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        CGValuedElement unboxedValue = this.getExpression(cgBoxExp.getSource());
        TypeId typeId = unboxedValue.getPivotTypeId();
        TypeDescriptor unboxedTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(unboxedValue);
        this.js.appendLocalStatements(unboxedValue);
        this.js.appendDeclaration(cgBoxExp);
        this.js.append(" = ");
        if (!unboxedValue.isNonNull()) {
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(" == null ? null : ");
        }
        if (unboxedTypeDescriptor.isAssignableTo(Iterable.class)) {
            String collectionName = "Collection";
            if (typeId instanceof CollectionTypeId) {
                collectionName = ((CollectionTypeId)typeId).getGeneralizedId().getName();
            }
            this.js.appendReferenceTo(this.localContext.getIdResolverVariable());
            this.js.append(".create" + collectionName + "OfAll(");
            this.js.appendIdReference((ElementId)typeId);
            this.js.append(", ");
            this.js.appendReferenceTo(Iterable.class, unboxedValue);
            this.js.append(")");
        } else if (unboxedTypeDescriptor.isAssignableTo(BigInteger.class) || unboxedTypeDescriptor.isAssignableTo(Long.class) || unboxedTypeDescriptor.isAssignableTo(Integer.class) || unboxedTypeDescriptor.isAssignableTo(Short.class) || unboxedTypeDescriptor.isAssignableTo(Byte.class) || unboxedTypeDescriptor.isAssignableTo(Character.class)) {
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".integerValueOf(");
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(")");
        } else if (unboxedTypeDescriptor.getJavaClass() == Object.class && typeId == TypeId.INTEGER) {
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".integerValueOf(");
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(")");
        } else if (unboxedTypeDescriptor.isAssignableTo(BigDecimal.class) || unboxedTypeDescriptor.isAssignableTo(Double.class) || unboxedTypeDescriptor.isAssignableTo(Float.class)) {
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".realValueOf(");
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(")");
        } else if (unboxedTypeDescriptor.isAssignableTo(Number.class)) {
            if (typeId == TypeId.REAL) {
                this.js.appendClassReference(ValuesUtil.class);
                this.js.append(".realValueOf(");
                this.js.appendReferenceTo(unboxedValue);
                this.js.append(")");
            } else {
                this.js.appendClassReference(ValuesUtil.class);
                this.js.append(".integerValueOf(");
                this.js.appendReferenceTo(unboxedValue);
                this.js.append(")");
            }
        } else if (unboxedTypeDescriptor.isAssignableTo(EEnumLiteral.class)) {
            this.js.appendClassReference(IdManager.class);
            this.js.append(".getEnumerationLiteralId(");
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(")");
        } else if (unboxedTypeDescriptor.isAssignableTo(Enumerator.class)) {
            this.js.appendIdReference((ElementId)typeId);
            this.js.append(".getEnumerationLiteralId(");
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(".getName())");
        } else {
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".createObjectValue(");
            this.js.appendIdReference((ElementId)typeId);
            this.js.append(", ");
            this.js.appendReferenceTo(unboxedValue);
            this.js.append(")");
        }
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGBuiltInIterationCallExp(@NonNull CGBuiltInIterationCallExp cgIterationCallExp) {
        CGValuedElement cgSource = this.getExpression(cgIterationCallExp.getSource());
        CGValuedElement cgBody = this.getExpression(cgIterationCallExp.getBody());
        CGIterator cgAccumulator = cgIterationCallExp.getAccumulator();
        CGIterator cgIterator = cgIterationCallExp.getIterators().get(0);
        String iteratorName = this.localContext.getNameManagerContext().getSymbolName(null, "ITERATOR_" + cgIterator.getValueName());
        Iteration2Java iterationHelper = ((JavaCodeGenerator)this.context).getIterationHelper(cgIterationCallExp.getReferredIteration());
        assert (iterationHelper != null);
        this.js.appendLocalStatements(cgSource);
        if (cgAccumulator != null) {
            CGValuedElement cgInit = cgAccumulator.getInit();
            if (cgInit != null) {
                this.js.appendLocalStatements(cgInit);
            }
            this.js.appendDeclaration(cgAccumulator);
            this.js.append(" = ");
            iterationHelper.appendAccumulatorInit(this.js, cgIterationCallExp);
            this.js.append(";\n");
        }
        this.js.appendIsRequired(cgIterator.isRequired());
        this.js.append(" ");
        this.js.appendClassReference(Iterator.class);
        this.js.append(" " + iteratorName + " = ");
        this.js.appendReferenceTo(cgSource);
        this.js.append(".iterator();\n");
        this.js.appendDeclaration(cgIterationCallExp);
        this.js.append(";\n");
        this.js.append("while (true) {\n");
        this.js.pushIndentation(null);
        this.js.append("if (!" + iteratorName + ".hasNext()) {\n");
        this.js.pushIndentation(null);
        if (iterationHelper.appendFinalValue(this.js, cgIterationCallExp)) {
            this.js.append("break;\n");
        }
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.appendDeclaration(cgIterator);
        this.js.append(" = ");
        this.js.appendClassCast(cgIterator);
        this.js.append(String.valueOf(iteratorName) + ".next();\n");
        this.js.appendCommentWithOCL(null, (Element)cgBody.getPivot());
        this.js.appendLocalStatements(cgBody);
        this.js.append("//\n");
        iterationHelper.appendUpdate(this.js, cgIterationCallExp);
        this.js.popIndentation();
        this.js.append("}\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGCastParameter(@NonNull CGCastParameter cgCastParameter) {
        CGParameter cgParameter = cgCastParameter.getReferredParameter();
        if (cgParameter != null) {
            this.js.appendDeclaration(cgCastParameter);
            this.js.append(" = ");
            this.js.appendReferenceTo(((JavaCodeGenerator)this.context).getTypeDescriptor(cgCastParameter), (CGValuedElement)cgParameter);
            this.js.append(";\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGCatchExp(@NonNull CGCatchExp cgCatchExp) {
        String eName = this.globalContext.getEName();
        CGValuedElement cgSource = this.getExpression(cgCatchExp.getSource());
        if (cgSource.isNonInvalid()) {
            this.js.appendLocalStatements(cgSource);
            this.js.appendDeclaration(cgCatchExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(";\n");
        } else {
            this.js.appendDeclaration(cgCatchExp);
            this.js.append(";\n");
            this.js.append("try {\n");
            this.js.pushIndentation(null);
            this.js.appendLocalStatements(cgSource);
            this.js.appendValueName(cgCatchExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(";\n");
            this.js.popIndentation();
            this.js.append("}\n");
            this.js.append("catch (");
            this.js.appendClassReference(Exception.class);
            this.js.append(" " + eName + ") {\n");
            this.js.pushIndentation(null);
            this.js.appendValueName(cgCatchExp);
            this.js.append(" = ");
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".createInvalidValue(" + eName + ");\n");
            this.js.popIndentation();
            this.js.append("}\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGCollectionExp(@NonNull CGCollectionExp cgCollectionExp) {
        int ranges = 0;
        for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
            if (cgPart.isRange()) {
                ++ranges;
            }
            this.js.appendLocalStatements(cgPart);
        }
        this.js.appendDeclaration(cgCollectionExp);
        this.js.append(" = ");
        this.js.appendClassReference(ValuesUtil.class);
        String kind = ((CollectionLiteralExp)cgCollectionExp.getPivot()).getKind().getName();
        if (ranges > 0) {
            this.js.append(".create" + kind + "Range(");
            this.js.appendIdReference(cgCollectionExp.getTypeId().getElementId());
            for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
                this.js.append(", ");
                this.js.appendValueName(cgPart);
            }
        } else {
            this.js.append(".create" + kind + "OfEach(");
            this.js.appendIdReference(cgCollectionExp.getTypeId().getElementId());
            for (CGCollectionPart cgPart : cgCollectionExp.getParts()) {
                this.js.append(", ");
                if (cgPart.isNull() && cgCollectionExp.getParts().size() == 1) {
                    this.js.append("(Object)");
                }
                this.js.appendValueName(cgPart);
            }
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGCollectionPart(@NonNull CGCollectionPart cgCollectionPart) {
        CGValuedElement first = this.getExpression(cgCollectionPart.getFirst());
        CGValuedElement last = cgCollectionPart.getLast();
        if (last != null) {
            this.js.appendLocalStatements(first);
            this.js.appendLocalStatements(last);
            this.js.appendDeclaration(cgCollectionPart);
            this.js.append(" = ");
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".createRange(");
            this.js.appendValueName(first);
            this.js.append(", ");
            this.js.appendValueName(last);
            this.js.append(");\n");
        } else {
            first.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGConstantExp(@NonNull CGConstantExp cgConstantExp) {
        CGValuedElement globalConstant = cgConstantExp.getReferredConstant();
        if (globalConstant != null) {
            this.js.appendValueName(globalConstant);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGConstraint(@NonNull CGConstraint cgConstraint) {
        this.localContext = this.globalContext.getLocalContext(cgConstraint);
        try {
            Object r = super.visitCGConstraint(cgConstraint);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    @Nullable
    public Object visitCGConstructorExp(@NonNull CGConstructorExp cgConstructorExp) {
        TypeId typeId = ((ConstructorExp)cgConstructorExp.getPivot()).getTypeId();
        CGExecutorType cgExecutorType = this.localContext.getExecutorType(typeId);
        this.js.appendDeclaration(cgConstructorExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgConstructorExp);
        this.js.appendValueName(cgExecutorType);
        this.js.append(".createInstance();\n");
        for (CGConstructorPart part : cgConstructorExp.getParts()) {
            part.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGConstructorPart(@NonNull CGConstructorPart cgConstructorPart) {
        PropertyId propertyId = ((ConstructorPart)cgConstructorPart.getPivot()).getReferredProperty().getPropertyId();
        CGExecutorConstructorPart cgExecutorConstructorPart = this.analyzer.getExecutorConstructorPart(propertyId);
        CGValuedElement init = this.getExpression(cgConstructorPart.getInit());
        this.js.appendLocalStatements(init);
        this.js.appendValueName(cgExecutorConstructorPart);
        this.js.append(".initValue(");
        this.js.appendValueName(cgConstructorPart.getConstructorExp());
        this.js.append(", ");
        this.js.appendValueName(init);
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGEcoreDataTypeConstructorExp(@NonNull CGEcoreDataTypeConstructorExp cgConstructorExp) {
        Class<?> packageClass;
        Class<?> factoryClass;
        EDataType eDataType = cgConstructorExp.getEDataType();
        Class javaClass = eDataType.getInstanceClass();
        if (javaClass == null) {
            throw new IllegalStateException("No Java class for " + cgConstructorExp + " in CG2JavaVisitor.visitCGEcoreDataTypeConstructorExp()");
        }
        EPackage ePackage = eDataType.getEPackage();
        String nsURI = ePackage.getNsURI();
        if (nsURI == null) {
            throw new IllegalStateException("No EPackage NsURI for " + cgConstructorExp + " in CG2JavaVisitor.visitCGEcoreDataTypeConstructorExp()");
        }
        GenPackage genPackage = this.getMetaModelManager().getGenPackage(nsURI);
        if (genPackage == null) {
            throw new IllegalStateException("No GenPackage for " + cgConstructorExp + " in CG2JavaVisitor.visitCGEcoreDataTypeConstructorExp()");
        }
        String eFactoryName = genPackage.getQualifiedFactoryInterfaceName();
        String ePackageName = genPackage.getQualifiedPackageInterfaceName();
        String dataTypeName = CodeGenUtil.upperName((String)eDataType.getName());
        ClassLoader classLoader = eDataType.getClass().getClassLoader();
        try {
            factoryClass = classLoader.loadClass(eFactoryName);
            packageClass = eDataType.getClass().getClassLoader().loadClass(ePackageName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Load class failure for " + cgConstructorExp + " in CG2JavaVisitor.visitCGEcoreDataTypeConstructorExp()", e);
        }
        this.js.appendDeclaration(cgConstructorExp);
        this.js.append(" = ");
        this.js.append("(");
        this.js.appendClassReference(javaClass);
        this.js.append(")");
        this.js.appendClassReference(factoryClass);
        this.js.append(".eINSTANCE.createFromString(");
        this.js.appendClassReference(packageClass);
        this.js.append(".Literals." + dataTypeName + ", \"");
        String partString = cgConstructorExp.getString();
        if (partString != null) {
            String javaString = Strings.convertToJavaString((String)partString);
            this.js.append(javaString);
        }
        this.js.append("\");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGEcoreOperationCallExp(@NonNull CGEcoreOperationCallExp cgOperationCallExp) {
        Operation pOperation = cgOperationCallExp.getReferredOperation();
        CGTypeId cgTypeId = this.analyzer.getTypeId(pOperation.getOwningType().getTypeId());
        TypeDescriptor requiredTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgTypeId.getElementId(), false);
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> cgArguments = cgOperationCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameter();
        this.js.appendLocalStatements(source);
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendLocalStatements(argument);
        }
        String operationAccessor = this.genModelHelper.getOperationAccessor(pOperation);
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.appendAtomicReferenceTo(requiredTypeDescriptor, source);
        this.js.append(".");
        this.js.append(operationAccessor);
        this.js.append("(");
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            if (i > 0) {
                this.js.append(", ");
            }
            CGValuedElement cgArgument = cgArguments.get(i);
            CGValuedElement argument = this.getExpression(cgArgument);
            Parameter pParameter = (Parameter)pParameters.get(i);
            GenParameter genParameter = ((JavaCodeGenerator)this.context).getGenModelHelper().getGenParameter(pParameter);
            if (genParameter != null) {
                String rawBoundType = genParameter.getRawBoundType();
                this.js.appendEcoreValue(rawBoundType, argument);
            } else {
                CGTypeId cgParameterTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
                TypeDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgParameterTypeId.getElementId(), false);
                this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            }
            ++i;
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGEcorePropertyCallExp(@NonNull CGEcorePropertyCallExp cgPropertyCallExp) {
        Property pivotProperty = cgPropertyCallExp.getReferredProperty();
        CGTypeId cgTypeId = this.analyzer.getTypeId(pivotProperty.getOwningType().getTypeId());
        ElementId elementId = (ElementId)DomainUtil.nonNullState((Object)cgTypeId.getElementId());
        TypeDescriptor requiredTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(elementId, false);
        EStructuralFeature eStructuralFeature = (EStructuralFeature)DomainUtil.nonNullState((Object)cgPropertyCallExp.getEStructuralFeature());
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        String getAccessor = this.genModelHelper.getGetAccessor(eStructuralFeature);
        Class<?> requiredJavaClass = requiredTypeDescriptor.hasJavaClass();
        Method leastDerivedMethod = requiredJavaClass != null ? this.getLeastDerivedMethod(requiredJavaClass, getAccessor) : null;
        Class<?> unboxedSourceClass = leastDerivedMethod != null ? leastDerivedMethod.getDeclaringClass() : requiredJavaClass;
        this.js.appendLocalStatements(source);
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        if (unboxedSourceClass != null && unboxedSourceClass != Object.class) {
            this.js.appendAtomicReferenceTo(unboxedSourceClass, source);
        } else {
            this.js.appendAtomicReferenceTo(source);
        }
        this.js.append(".");
        this.js.append(getAccessor);
        this.js.append("();\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGElementId(@NonNull CGElementId cgElementId) {
        ElementId elementId = cgElementId.getElementId();
        if (elementId != null && !CGUtils.isInlineableId(elementId)) {
            this.js.append("public static final ");
            this.js.appendIsRequired(true);
            this.js.append(" ");
            this.js.appendIsCaught(true, false);
            this.js.append(" ");
            this.js.appendClassReference((Class)elementId.accept((IdVisitor)this.id2JavaInterfaceVisitor));
            this.js.append(" ");
            this.js.append(this.globalContext.getValueName(cgElementId));
            this.js.append(" = ");
            this.js.appendIdReference2(elementId);
            this.js.append(";\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorCompositionProperty(@NonNull CGExecutorCompositionProperty cgExecutorProperty) {
        this.js.appendDeclaration(cgExecutorProperty);
        this.js.append(" = new ");
        this.js.appendClassReference(cgExecutorProperty);
        this.js.append("(");
        Property pivotProperty = (Property)cgExecutorProperty.getPivot();
        Property pivotOppositeProperty = pivotProperty.getOpposite();
        this.js.appendString(pivotOppositeProperty.getName());
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorConstructorPart(@NonNull CGExecutorConstructorPart cgExecutorConstructorPart) {
        this.js.appendDeclaration(cgExecutorConstructorPart);
        this.js.append(" = ");
        this.js.appendValueName(this.localContext.getIdResolverVariable());
        this.js.append(".getProperty(");
        this.js.appendIdReference(cgExecutorConstructorPart.getUnderlyingPropertyId().getElementId());
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorNavigationProperty(@NonNull CGExecutorNavigationProperty cgExecutorProperty) {
        this.js.appendDeclaration(cgExecutorProperty);
        this.js.append(" = new ");
        this.js.appendClassReference(cgExecutorProperty);
        this.js.append("(");
        this.js.appendIdReference(cgExecutorProperty.getUnderlyingPropertyId().getElementId());
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorOppositeProperty(@NonNull CGExecutorOppositeProperty cgExecutorProperty) {
        Property pivotProperty = (Property)cgExecutorProperty.getPivot();
        Property pivotOppositeProperty = pivotProperty.getOpposite();
        this.js.appendDeclaration(cgExecutorProperty);
        this.js.append(" = new ");
        this.js.appendClassReference(cgExecutorProperty);
        this.js.append("(");
        this.js.appendIdReference((ElementId)pivotOppositeProperty.getPropertyId());
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorOperation(@NonNull CGExecutorOperation cgExecutorOperation) {
        this.js.appendDeclaration(cgExecutorOperation);
        this.js.append(" = ");
        this.js.appendValueName(this.localContext.getIdResolverVariable());
        this.js.append(".getOperation(");
        this.js.appendIdReference(cgExecutorOperation.getUnderlyingOperationId().getElementId());
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorOperationCallExp(@NonNull CGExecutorOperationCallExp cgOperationCallExp) {
        Operation pOperation = cgOperationCallExp.getReferredOperation();
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> cgArguments = cgOperationCallExp.getArguments();
        List pParameters = pOperation.getOwnedParameter();
        this.js.appendLocalStatements(source);
        for (CGValuedElement cgArgument : cgArguments) {
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendLocalStatements(argument);
        }
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgOperationCallExp);
        this.js.appendReferenceTo(cgOperationCallExp.getExecutorOperation());
        this.js.append(".evaluate(");
        this.js.append(this.getValueName(this.localContext.getEvaluatorParameter()));
        this.js.append(", ");
        this.js.appendIdReference((ElementId)cgOperationCallExp.getPivotTypeId());
        this.js.append(", ");
        this.js.appendValueName(source);
        int iMax = Math.min(pParameters.size(), cgArguments.size());
        int i = 0;
        while (i < iMax) {
            this.js.append(", ");
            CGValuedElement cgArgument = cgArguments.get(i);
            Parameter pParameter = (Parameter)pParameters.get(i);
            CGTypeId cgTypeId = this.analyzer.getTypeId(pParameter.getTypeId());
            TypeDescriptor parameterTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(cgTypeId.getElementId(), false);
            CGValuedElement argument = this.getExpression(cgArgument);
            this.js.appendReferenceTo(parameterTypeDescriptor, argument);
            ++i;
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorPropertyCallExp(@NonNull CGExecutorPropertyCallExp cgPropertyCallExp) {
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        this.js.appendLocalStatements(source);
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgPropertyCallExp);
        this.js.appendReferenceTo(cgPropertyCallExp.getExecutorProperty());
        this.js.append(".evaluate(");
        this.js.append(this.getValueName(this.localContext.getEvaluatorParameter()));
        this.js.append(", ");
        this.js.appendIdReference((ElementId)cgPropertyCallExp.getPivotTypeId());
        this.js.append(", ");
        this.js.appendValueName(source);
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGExecutorType(@NonNull CGExecutorType cgExecutorType) {
        this.js.appendDeclaration(cgExecutorType);
        this.js.append(" = ");
        this.js.appendValueName(this.localContext.getIdResolverVariable());
        this.js.append(".getType(");
        this.js.appendIdReference(cgExecutorType.getUnderlyingTypeId().getElementId());
        this.js.append(", null);\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGGuardExp(@NonNull CGGuardExp cgGuardExp) {
        CGValuedElement cgSource = this.getExpression(cgGuardExp.getSource());
        if (cgSource.isNull()) {
            this.js.append("throw new ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append("();\n");
        } else {
            this.js.appendLocalStatements(cgSource);
            if (!cgSource.isNonNull()) {
                this.js.append("if (");
                this.js.appendValueName(cgSource);
                this.js.append(" == null) {\n");
                this.js.pushIndentation(null);
                this.js.append("throw new ");
                this.js.appendClassReference(InvalidValueException.class);
                this.js.append("(\"Null source\");\n");
                this.js.popIndentation();
                this.js.append("}\n");
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIfExp(@NonNull CGIfExp cgIfExp) {
        CGValuedElement condition = this.getExpression(cgIfExp.getCondition());
        CGValuedElement thenExpression = this.getExpression(cgIfExp.getThenExpression());
        CGValuedElement elseExpression = this.getExpression(cgIfExp.getElseExpression());
        this.js.appendLocalStatements(condition);
        this.js.appendDeclaration(cgIfExp);
        this.js.append(";\n");
        this.js.append("if (");
        this.js.appendValueName(condition);
        this.js.append(") {\n");
        this.js.pushIndentation(null);
        this.js.appendAssignment(cgIfExp, thenExpression);
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.append("else {\n");
        this.js.pushIndentation(null);
        this.js.appendAssignment(cgIfExp, elseExpression);
        this.js.popIndentation();
        this.js.append("}\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGInfinity(@NonNull CGInfinity object) {
        this.js.appendClassReference(ValuesUtil.class);
        this.js.append(".UNLIMITED_VALUE");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGInteger(@NonNull CGInteger object) {
        this.js.appendDeclaration(object);
        this.js.append(" = ");
        this.js.appendClassReference(ValuesUtil.class);
        this.js.append(".integerValueOf(");
        Number integerValue = object.getIntegerValue();
        String valueString = integerValue.toString();
        assert (valueString != null);
        if (integerValue instanceof IntIntegerValueImpl) {
            this.js.append(valueString);
        } else if (integerValue instanceof LongIntegerValueImpl) {
            this.js.append(String.valueOf(valueString) + "L");
        } else {
            this.js.append("\"" + valueString + "\"");
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGInvalid(@NonNull CGInvalid object) {
        String message = object.getMessageTemplate();
        if (message != null) {
            this.js.append("new ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append("(");
            this.js.appendString(message);
            for (Object binding : object.getBindings()) {
                this.js.append(", ");
                this.js.appendString(String.valueOf(binding));
            }
            this.js.append(")");
        } else {
            this.js.appendClassReference(ValuesUtil.class);
            this.js.append(".INVALID_VALUE");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsInvalidExp(@NonNull CGIsInvalidExp cgIsInvalidExp) {
        if (cgIsInvalidExp.isTrue()) {
            this.js.appendTrue();
        } else if (cgIsInvalidExp.isFalse()) {
            this.js.appendFalse();
        } else {
            CGValuedElement cgSource = this.getExpression(cgIsInvalidExp.getSource());
            this.js.appendLocalStatements(cgSource);
            this.js.appendDeclaration(cgIsInvalidExp);
            this.js.append(" = ");
            this.js.appendValueName(cgSource);
            this.js.append(" instanceof ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append(";\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGIsUndefinedExp(@NonNull CGIsUndefinedExp cgIsUndefinedExp) {
        if (cgIsUndefinedExp.isTrue()) {
            this.js.appendTrue();
        } else if (cgIsUndefinedExp.isFalse()) {
            this.js.appendFalse();
        } else {
            CGValuedElement cgSource = this.getExpression(cgIsUndefinedExp.getSource());
            boolean sourceIsNonInvalid = cgSource.isNonInvalid();
            boolean sourceIsNonNull = cgSource.isNonNull();
            this.js.appendLocalStatements(cgSource);
            this.js.appendDeclaration(cgIsUndefinedExp);
            this.js.append(" = ");
            if (!sourceIsNonNull && !sourceIsNonInvalid) {
                this.js.append("(");
                this.js.appendValueName(cgSource);
                this.js.append(" == null) || (");
                this.js.appendValueName(cgSource);
                this.js.append(" instanceof ");
                this.js.appendClassReference(InvalidValueException.class);
                this.js.append(")");
            } else if (!sourceIsNonNull && sourceIsNonInvalid) {
                this.js.appendValueName(cgSource);
                this.js.append(" == null");
            } else if (sourceIsNonNull && !sourceIsNonInvalid) {
                this.js.appendValueName(cgSource);
                this.js.append(" instanceof ");
                this.js.appendClassReference(InvalidValueException.class);
            }
            this.js.append(";\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLetExp(@NonNull CGLetExp cgLetExp) {
        cgLetExp.getInit().accept(this);
        this.js.appendLocalStatements(cgLetExp.getIn());
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryIterateCallExp(@NonNull CGLibraryIterateCallExp cgIterateCallExp) {
        CGValuedElement source = this.getExpression(cgIterateCallExp.getSource());
        CGValuedElement body = this.getExpression(cgIterateCallExp.getBody());
        LibraryIteration libraryIteration = (LibraryIteration)DomainUtil.nonNullState((Object)cgIterateCallExp.getLibraryIteration());
        Class<?> actualReturnClass = this.getJavaReturnClass(libraryIteration);
        CGIterator iterateResult = cgIterateCallExp.getResult();
        CGTypeId resultType = cgIterateCallExp.getTypeId();
        CGValuedElement evaluatorParameter = this.localContext.getEvaluatorParameter();
        List<CGIterator> iterators = cgIterateCallExp.getIterators();
        Class<?> operationClass = this.genModelHelper.getAbstractOperationClass(iterators);
        String astName = cgIterateCallExp.getValueName();
        Iteration referredOperation = ((LoopExp)cgIterateCallExp.getPivot()).getReferredIteration();
        Class<ExecutorSingleIterationManager> managerClass = ExecutorSingleIterationManager.class;
        String staticTypeName = "TYPE_" + astName;
        String implementationName = "IMPL_" + astName;
        String managerName = "MGR_" + astName;
        String bodyName = "BODY_" + astName;
        this.js.appendLocalStatements(source);
        CGValuedElement init = iterateResult.getInit();
        String accumulatorName = init.getValueName();
        this.js.appendLocalStatements(init);
        this.js.appendDeclaration(iterateResult);
        this.js.append(" = ");
        this.js.appendValueName(init);
        this.js.append(";\n");
        this.js.append("/**\n");
        this.js.append(" * Implementation of the iterator body.\n");
        this.js.append(" */\n");
        this.js.append("final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(operationClass);
        this.js.append(" " + bodyName + " = new ");
        this.js.appendClassReference(operationClass);
        this.js.append("()\n");
        this.js.append("{\n");
        this.js.pushIndentation(null);
        this.js.appendCommentWithOCL(null, (Element)body.getPivot());
        this.js.append("@Override\n");
        this.js.append("public ");
        this.js.appendIsRequired(false);
        this.js.append(" Object evaluate(");
        this.js.appendDeclaration(evaluatorParameter);
        this.js.append(", ");
        this.js.appendDeclaration(this.localContext.getTypeIdParameter());
        this.js.append(", ");
        this.js.appendDeclaration(iterateResult);
        for (CGParameter cGParameter : iterators) {
            this.js.append(", ");
            this.js.appendDeclaration(cGParameter);
        }
        this.js.append(") {\n");
        this.js.pushIndentation(null);
        JavaLocalContext javaLocalContext = this.localContext;
        try {
            this.localContext = this.globalContext.getLocalContext(cgIterateCallExp);
            ArrayList<CGIterator> allIterators = new ArrayList<CGIterator>(iterators);
            allIterators.add(iterateResult);
            this.js.appendCastParameters(this.localContext, allIterators);
            this.js.appendLocalStatements(body);
            this.js.append("return ");
            this.js.appendValueName(body);
            this.js.append(";\n");
        }
        finally {
            this.localContext = javaLocalContext;
        }
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.popIndentation();
        this.js.append("};\n");
        this.js.appendClassReference(DomainType.class);
        this.js.append(" " + staticTypeName + " = ");
        this.js.appendReferenceTo(evaluatorParameter);
        this.js.append(".getStaticTypeOf(");
        this.js.appendValueName(source);
        this.js.append(");\n");
        this.js.appendClassReference(LibraryIteration.class);
        this.js.append(" " + implementationName + " = (");
        this.js.appendClassReference(LibraryIteration.class);
        this.js.append(")" + staticTypeName + ".lookupImplementation(");
        this.js.appendReferenceTo(this.localContext.getStandardLibraryVariable());
        this.js.append(", ");
        this.js.appendQualifiedLiteralName((Operation)referredOperation);
        this.js.append(");\n");
        this.js.appendClassReference(managerClass);
        this.js.append(" " + managerName + " = new ");
        this.js.appendClassReference(managerClass);
        this.js.append("(");
        this.js.appendReferenceTo(evaluatorParameter);
        this.js.append(", ");
        this.js.appendValueName(resultType);
        this.js.append(", " + bodyName + ", ");
        this.js.appendValueName(source);
        this.js.append(", " + accumulatorName + ");\n");
        this.js.appendDeclaration(cgIterateCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgIterateCallExp, actualReturnClass);
        this.js.append(String.valueOf(implementationName) + ".evaluateIteration(" + managerName + ")");
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryIterationCallExp(@NonNull CGLibraryIterationCallExp cgIterationCallExp) {
        CGValuedElement source = this.getExpression(cgIterationCallExp.getSource());
        CGValuedElement body = this.getExpression(cgIterationCallExp.getBody());
        LibraryIteration libraryIteration = (LibraryIteration)DomainUtil.nonNullState((Object)cgIterationCallExp.getLibraryIteration());
        Class<?> actualReturnClass = this.getJavaReturnClass(libraryIteration);
        CGTypeId resultType = cgIterationCallExp.getTypeId();
        CGValuedElement evaluatorParameter = this.localContext.getEvaluatorParameter();
        List<CGIterator> iterators = cgIterationCallExp.getIterators();
        int arity = iterators.size();
        Class<?> operationClass = this.genModelHelper.getAbstractOperationClass(iterators);
        String astName = cgIterationCallExp.getValueName();
        Iteration referredOperation = ((LoopExp)cgIterationCallExp.getPivot()).getReferredIteration();
        Class managerClass = arity == 1 ? ExecutorSingleIterationManager.class : ExecutorDoubleIterationManager.class;
        String staticTypeName = "TYPE_" + astName;
        String accumulatorName = "ACC_" + astName;
        String implementationName = "IMPL_" + astName;
        String managerName = "MGR_" + astName;
        String bodyName = "BODY_" + astName;
        this.js.appendLocalStatements(source);
        this.js.append("/**\n");
        this.js.append(" * Implementation of the iterator body.\n");
        this.js.append(" */\n");
        this.js.append("final ");
        this.js.appendIsRequired(true);
        this.js.append(" ");
        this.js.appendClassReference(operationClass);
        this.js.append(" " + bodyName + " = new ");
        this.js.appendClassReference(operationClass);
        this.js.append("()\n");
        this.js.append("{\n");
        this.js.pushIndentation(null);
        this.js.appendCommentWithOCL(null, (Element)body.getPivot());
        this.js.append("@Override\n");
        this.js.append("public ");
        this.js.appendIsRequired(false);
        this.js.append(" Object evaluate(");
        this.js.appendDeclaration(evaluatorParameter);
        this.js.append(", ");
        this.js.appendDeclaration(this.localContext.getTypeIdParameter());
        this.js.append(", final ");
        this.js.appendIsRequired(false);
        this.js.append(" Object ");
        this.js.appendValueName(source);
        for (CGParameter cGParameter : iterators) {
            this.js.append(", ");
            this.js.appendDeclaration(cGParameter);
        }
        this.js.append(") {\n");
        this.js.pushIndentation(null);
        JavaLocalContext javaLocalContext = this.localContext;
        try {
            this.localContext = this.globalContext.getLocalContext(cgIterationCallExp);
            this.js.appendCastParameters(this.localContext, iterators);
            this.js.appendLocalStatements(body);
            this.js.append("return ");
            this.js.appendValueName(body);
            this.js.append(";\n");
        }
        finally {
            this.localContext = javaLocalContext;
        }
        this.js.popIndentation();
        this.js.append("}\n");
        this.js.popIndentation();
        this.js.append("};\n");
        this.js.appendClassReference(DomainType.class);
        this.js.append(" " + staticTypeName + " = ");
        this.js.appendReferenceTo(evaluatorParameter);
        this.js.append(".getStaticTypeOf(");
        this.js.appendValueName(source);
        this.js.append(");\n");
        this.js.appendClassReference(LibraryIteration.class);
        this.js.append(" " + implementationName + " = (");
        this.js.appendClassReference(LibraryIteration.class);
        this.js.append(")" + staticTypeName + ".lookupImplementation(");
        this.js.appendReferenceTo(this.localContext.getStandardLibraryVariable());
        this.js.append(", ");
        this.js.appendQualifiedLiteralName((Operation)referredOperation);
        this.js.append(");\n");
        this.js.append("Object " + accumulatorName + " = " + implementationName + ".createAccumulatorValue(");
        this.js.appendValueName(evaluatorParameter);
        this.js.append(", ");
        this.js.appendValueName(resultType);
        this.js.append(", ");
        this.js.appendValueName(body.getTypeId());
        this.js.append(");\n");
        this.js.appendClassReference(managerClass);
        this.js.append(" " + managerName + " = new ");
        this.js.appendClassReference(managerClass);
        this.js.append("(");
        this.js.appendReferenceTo(evaluatorParameter);
        this.js.append(", ");
        this.js.appendValueName(resultType);
        this.js.append(", " + bodyName + ", ");
        this.js.appendReferenceTo(CollectionValue.class, source);
        this.js.append(", " + accumulatorName + ");\n");
        this.js.appendDeclaration(cgIterationCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgIterationCallExp, actualReturnClass);
        this.js.append(String.valueOf(implementationName) + ".evaluateIteration(" + managerName + ")");
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryOperationCallExp(@NonNull CGLibraryOperationCallExp cgOperationCallExp) {
        CGValuedElement source = this.getExpression(cgOperationCallExp.getSource());
        List<CGValuedElement> arguments = cgOperationCallExp.getArguments();
        LibraryOperation libraryOperation = (LibraryOperation)DomainUtil.nonNullState((Object)cgOperationCallExp.getLibraryOperation());
        Class<?> actualReturnClass = this.getJavaReturnClass(libraryOperation, arguments.size());
        CGTypeId resultType = cgOperationCallExp.getTypeId();
        this.js.appendLocalStatements(source);
        for (CGValuedElement cgArgument : arguments) {
            this.js.appendLocalStatements(cgArgument);
        }
        this.js.appendDeclaration(cgOperationCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgOperationCallExp, actualReturnClass);
        this.js.appendClassReference(libraryOperation.getClass());
        this.js.append("." + this.globalContext.getInstanceName() + "." + this.globalContext.getEvaluateName() + "(");
        if (!(libraryOperation instanceof LibrarySimpleOperation)) {
            this.js.append(this.getValueName(this.localContext.getEvaluatorParameter()));
            this.js.append(", ");
            if (!(libraryOperation instanceof LibraryUntypedOperation)) {
                this.js.appendValueName(resultType);
                this.js.append(", ");
            }
        }
        this.js.appendValueName(source);
        for (CGValuedElement cgArgument : arguments) {
            this.js.append(", ");
            this.js.appendValueName(cgArgument);
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGLibraryPropertyCallExp(@NonNull CGLibraryPropertyCallExp cgPropertyCallExp) {
        CGValuedElement source = this.getExpression(cgPropertyCallExp.getSource());
        LibraryProperty libraryProperty = (LibraryProperty)DomainUtil.nonNullState((Object)cgPropertyCallExp.getLibraryProperty());
        Class<?> actualReturnClass = this.getJavaReturnClass(libraryProperty);
        CGTypeId resultType = cgPropertyCallExp.getTypeId();
        this.js.appendLocalStatements(source);
        this.js.appendDeclaration(cgPropertyCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgPropertyCallExp, actualReturnClass);
        this.js.appendClassReference(libraryProperty.getClass());
        this.js.append("." + this.globalContext.getInstanceName() + "." + this.globalContext.getEvaluateName() + "(");
        this.js.append(this.getValueName(this.localContext.getEvaluatorParameter()));
        this.js.append(", ");
        this.js.appendValueName(resultType);
        this.js.append(", ");
        this.js.appendValueName(source);
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGNull(@NonNull CGNull object) {
        this.js.append("null");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGOperation(@NonNull CGOperation cgOperation) {
        JavaLocalContext localContext2 = this.globalContext.getLocalContext(cgOperation);
        if (localContext2 != null) {
            this.localContext = localContext2;
            try {
                CGValuedElement evaluatorParameter = localContext2.getEvaluatorParameter();
                CGParameter typeIdParameter = localContext2.getTypeIdParameter();
                List<CGParameter> cgParameters = cgOperation.getParameters();
                CGValuedElement body = this.getExpression(cgOperation.getBody());
                this.js.append("@Override\n");
                this.js.append("public ");
                if (cgOperation.isNull()) {
                    this.js.append("/*@Null*/");
                } else {
                    this.js.appendIsRequired(true);
                }
                this.js.append(" ");
                this.js.appendIsCaught(!cgOperation.isInvalid(), cgOperation.isInvalid());
                this.js.append(" ");
                this.js.appendClassReference(cgOperation);
                this.js.append(" ");
                this.js.append(cgOperation.getName());
                this.js.append("(");
                this.js.appendDeclaration(evaluatorParameter);
                this.js.append(", ");
                this.js.appendDeclaration(typeIdParameter);
                for (CGParameter cgParameter : cgParameters) {
                    this.js.append(", ");
                    this.js.appendDeclaration(cgParameter);
                }
                this.js.append(") {\n");
                this.js.pushIndentation(null);
                this.js.appendCastParameters(localContext2, cgParameters);
                JavaDependencyVisitor dependencyVisitor = new JavaDependencyVisitor(localContext2);
                dependencyVisitor.visit(body);
                dependencyVisitor.visitAll(localContext2.getLocalVariables());
                Iterable<CGValuedElement> sortedDependencies = dependencyVisitor.getSortedDependencies();
                for (CGValuedElement cgElement : sortedDependencies) {
                    if (cgElement.isInlineable() || !cgElement.isConstant() || cgElement.isGlobal()) continue;
                    cgElement.accept(this);
                }
                this.js.appendLocalStatements(body);
                if (body.isInvalid()) {
                    this.js.append("throw ");
                } else {
                    this.js.append("return ");
                }
                this.js.appendValueName(body);
                this.js.append(";\n");
                this.js.popIndentation();
                this.js.append("}\n");
            }
            finally {
                this.localContext = null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGPackage(@NonNull CGPackage cgPackage) {
        this.js.appendCopyrightHeader();
        this.js.append("package " + cgPackage.getName() + ";\n");
        this.js.append("\n");
        this.js.append("<%**imports**%>\n");
        for (CGClass cgClass : cgPackage.getClasses()) {
            cgClass.accept(this);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGParameter(@NonNull CGParameter object) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGProperty(@NonNull CGProperty cgProperty) {
        this.localContext = this.globalContext.getLocalContext(cgProperty);
        try {
            Object r = super.visitCGProperty(cgProperty);
            return r;
        }
        finally {
            this.localContext = null;
        }
    }

    @Override
    @Nullable
    public Object visitCGReal(@NonNull CGReal object) {
        this.js.appendDeclaration(object);
        this.js.append(" = ");
        this.js.appendClassReference(ValuesUtil.class);
        this.js.append(".realValueOf(");
        Number realValue = object.getRealValue();
        String valueString = realValue.toString();
        if (realValue instanceof Double) {
            this.js.append(String.valueOf(valueString) + "d");
        } else {
            this.js.append("\"" + valueString + "\"");
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGString(@NonNull CGString object) {
        this.js.appendDeclaration(object);
        this.js.append(" = ");
        this.js.appendString(object.getStringValue());
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGText(@NonNull CGText cgText) {
        this.js.appendDeclaration(cgText);
        this.js.append(" = ");
        this.js.append(cgText.getTextValue());
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTextParameter(@NonNull CGTextParameter cgTextParameter) {
        this.js.appendDeclaration(cgTextParameter);
        this.js.append(" = ");
        this.js.append(cgTextParameter.getTextValue());
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGThrowExp(@NonNull CGThrowExp cgThrowExp) {
        CGValuedElement cgSource = this.getExpression(cgThrowExp.getSource());
        if (cgSource.isNonInvalid()) {
            cgSource.accept(this);
        } else if (cgSource.isInvalid()) {
            this.js.append("throw ");
            this.js.appendReferenceTo(InvalidValueException.class, cgSource);
            this.js.append(";\n");
        } else {
            this.js.appendLocalStatements(cgSource);
            this.js.append("if (");
            if (cgSource.isGlobal()) {
                this.js.appendValueName(cgSource);
            } else {
                this.js.appendValueName(cgSource);
            }
            this.js.append(" instanceof ");
            this.js.appendClassReference(InvalidValueException.class);
            this.js.append(") {\n");
            this.js.pushIndentation(null);
            this.js.append("throw ");
            this.js.appendReferenceTo(InvalidValueException.class, cgSource);
            this.js.append(";\n");
            this.js.popIndentation();
            this.js.append("}\n");
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTupleExp(@NonNull CGTupleExp cgTupleExp) {
        List<CGTuplePart> parts = cgTupleExp.getParts();
        for (CGTuplePart cgPart : parts) {
            this.js.appendLocalStatements(cgPart.getValue());
        }
        this.js.appendDeclaration(cgTupleExp);
        this.js.append(" = ");
        this.js.appendClassReference(ValuesUtil.class);
        this.js.append(".createTupleOfEach(");
        this.js.appendIdReference(cgTupleExp.getTypeId().getElementId());
        int iSize = parts.size();
        int i = 0;
        while (i < iSize) {
            CGValuedElement cgPartValue = parts.get(i).getValue();
            this.js.append(", ");
            if (cgPartValue.isNull() && iSize == 1) {
                this.js.append("(Object)");
            }
            this.js.appendValueName(cgPartValue);
            ++i;
        }
        this.js.append(");\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTuplePartCallExp(@NonNull CGTuplePartCallExp cgTuplePartCallExp) {
        CGValuedElement source = this.getExpression(cgTuplePartCallExp.getSource());
        TuplePartId partId = cgTuplePartCallExp.getPivotTuplePartId();
        this.js.appendLocalStatements(source);
        this.js.appendDeclaration(cgTuplePartCallExp);
        this.js.append(" = ");
        this.js.appendClassCast(cgTuplePartCallExp);
        this.js.appendAtomicReferenceTo(TupleValue.class, source);
        this.js.append(".getValue(" + partId.getIndex() + "/*" + partId.getName() + "*/);\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTypeId(@NonNull CGTypeId cgTypeId) {
        if (cgTypeId.isInlineable()) {
            this.js.appendIdReference(cgTypeId.getElementId());
        } else {
            super.visitCGTypeId(cgTypeId);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        return null;
    }

    @Override
    @Nullable
    public Object visitCGUnboxExp(@NonNull CGUnboxExp cgUnboxExp) {
        CGValuedElement source = this.getExpression(cgUnboxExp.getSource());
        TypeDescriptor boxedTypeDescriptor = ((JavaCodeGenerator)this.context).getTypeDescriptor(source);
        this.js.appendLocalStatements(source);
        this.js.appendDeclaration(cgUnboxExp);
        this.js.append(" = ");
        if (boxedTypeDescriptor.isAssignableTo(CollectionValue.class)) {
            this.js.appendValueName(source);
            this.js.append(".asEcoreObject()");
        } else if (boxedTypeDescriptor.isAssignableTo(IntegerValue.class)) {
            this.js.appendValueName(source);
            this.js.append(".asNumber()");
        } else if (boxedTypeDescriptor.isAssignableTo(RealValue.class)) {
            this.js.appendValueName(source);
            this.js.append(".asNumber()");
        } else if (boxedTypeDescriptor.isAssignableTo(EnumerationLiteralId.class)) {
            this.js.appendReferenceTo(this.localContext.getIdResolverVariable());
            this.js.append(".unboxedValueOf(");
            this.js.appendValueName(source);
            this.js.append(")");
        } else {
            this.js.append(String.valueOf(cgUnboxExp.getName()) + ".GET_UNBOXED_VALUE(");
            this.js.append(", \"" + boxedTypeDescriptor.getClassName() + "\")");
        }
        this.js.append(";\n");
        return null;
    }

    @Override
    @Nullable
    public Object visitCGVariable(@NonNull CGVariable cgVariable) {
        CGValuedElement init = cgVariable.getInit();
        if (init != null) {
            this.js.appendLocalStatements(init);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitCGVariableExp(@NonNull CGVariableExp cgVariableExp) {
        return null;
    }
}

