/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.AbstractId2JavaClassVisitor;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id2BoxedJavaClassVisitor
extends AbstractId2JavaClassVisitor {
    protected Id2BoxedJavaClassVisitor(@NonNull GenModelHelper genModelHelper) {
        super(genModelHelper);
    }

    @NonNull
    public Class<?> visitCollectionTypeId(@NonNull CollectionTypeId id) {
        CollectionTypeId generalizedId = id.getGeneralizedId();
        if (generalizedId == TypeId.BAG) {
            return BagValue.class;
        }
        if (generalizedId == TypeId.COLLECTION) {
            return CollectionValue.class;
        }
        if (generalizedId == TypeId.ORDERED_SET) {
            return OrderedSetValue.class;
        }
        if (generalizedId == TypeId.SEQUENCE) {
            return SequenceValue.class;
        }
        if (generalizedId == TypeId.SET) {
            return SetValue.class;
        }
        return CollectionValue.class;
    }

    @NonNull
    public Class<?> visitDataTypeId(@NonNull DataTypeId id) {
        return ObjectValue.class;
    }

    @NonNull
    public Class<?> visitEnumerationId(@NonNull EnumerationId id) {
        return EnumerationLiteralId.class;
    }

    @NonNull
    public Class<?> visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        return EnumerationLiteralId.class;
    }

    @NonNull
    public Class<?> visitMetaclassId(@NonNull MetaclassId id) {
        if (id.getElementId() instanceof EnumerationLiteralId) {
            return EnumerationLiteralId.class;
        }
        return DomainType.class;
    }

    @Override
    @NonNull
    public Class<?> visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        Object javaClass = super.visitPrimitiveTypeId(id);
        if (javaClass != null) {
            return javaClass;
        }
        if (id == TypeId.INTEGER) {
            return IntegerValue.class;
        }
        if (id == TypeId.REAL) {
            return RealValue.class;
        }
        if (id == TypeId.UNLIMITED_NATURAL) {
            return IntegerValue.class;
        }
        return this.visiting((ElementId)id);
    }
}

