/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.examples.codegen.java.AbstractId2JavaClassVisitor;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.DataTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.EnumerationId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.PrimitiveTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id2UnboxedJavaClassVisitor
extends AbstractId2JavaClassVisitor {
    protected Id2UnboxedJavaClassVisitor(@NonNull GenModelHelper genModelHelper) {
        super(genModelHelper);
    }

    @NonNull
    public Class<?> visitCollectionTypeId(@NonNull CollectionTypeId id) {
        return List.class;
    }

    @NonNull
    public Class<?> visitDataTypeId(@NonNull DataTypeId id) {
        return Object.class;
    }

    @NonNull
    public Class<?> visitEnumerationId(@NonNull EnumerationId id) {
        return Enumerator.class;
    }

    @NonNull
    public Class<?> visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        return Enumerator.class;
    }

    @NonNull
    public Class<?> visitMetaclassId(@NonNull MetaclassId id) {
        if (id.getElementId() instanceof EnumerationLiteralId) {
            return Enumerator.class;
        }
        return DomainType.class;
    }

    @Override
    @NonNull
    public Class<?> visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        Object javaClass = super.visitPrimitiveTypeId(id);
        if (javaClass != null) {
            return javaClass;
        }
        if (id == TypeId.INTEGER) {
            return Object.class;
        }
        if (id == TypeId.REAL) {
            return Number.class;
        }
        if (id == TypeId.UNLIMITED_NATURAL) {
            return Number.class;
        }
        return this.visiting((ElementId)id);
    }
}

