/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGBoxExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGExecutorType;
import org.eclipse.ocl.examples.codegen.cgmodel.CGTypeExp;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.JavaConstants;
import org.eclipse.ocl.examples.codegen.java.JavaGlobalContext;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.TypeId;

public class JavaDependencyVisitor
extends DependencyVisitor {
    @NonNull
    protected final JavaGlobalContext globalContext;
    protected final JavaLocalContext localContext;

    public JavaDependencyVisitor(@NonNull CodeGenAnalyzer analyzer, @NonNull JavaGlobalContext globalContext) {
        super(analyzer);
        this.globalContext = globalContext;
        this.localContext = null;
    }

    public JavaDependencyVisitor(@NonNull JavaLocalContext localContext) {
        super(localContext.getAnalyzer());
        this.globalContext = localContext.getGlobalContext();
        this.localContext = localContext;
    }

    @Nullable
    public Object visitCGBoxExp(@NonNull CGBoxExp cgBoxExp) {
        TypeId typeId = cgBoxExp.getSource().getPivotTypeId();
        if (typeId != null) {
            this.addDependency(cgBoxExp, ((CodeGenAnalyzer)this.context).getElementId((ElementId)typeId));
            typeId.accept((IdVisitor)this.id2DependencyVisitor);
        }
        return super.visitCGBoxExp(cgBoxExp);
    }

    @Nullable
    public Object visitCGExecutorType(@NonNull CGExecutorType cgTypeWithReflection) {
        this.addDependency(cgTypeWithReflection, this.localContext.getIdResolverVariable());
        cgTypeWithReflection.setTypeId(((CodeGenAnalyzer)this.context).getTypeId((TypeId)JavaConstants.DOMAIN_TYPE_TYPE_ID));
        return super.visitCGExecutorType(cgTypeWithReflection);
    }

    @Nullable
    public Object visitCGTypeExp(@NonNull CGTypeExp cgTypeExp) {
        CGValuedElement variableValue = cgTypeExp.getValue();
        variableValue.accept(this);
        this.addDependency(cgTypeExp, variableValue);
        this.addDependency(cgTypeExp, cgTypeExp.getReferredType());
        return super.visitCGTypeExp(cgTypeExp);
    }
}

