/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java;

import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.CGUtils;
import org.eclipse.ocl.examples.codegen.analyzer.CodeGenAnalyzer;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGVariable;
import org.eclipse.ocl.examples.codegen.generator.AbstractGenModelHelper;
import org.eclipse.ocl.examples.codegen.generator.CodeGenOptions;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.Id2JavaExpressionVisitor;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.java.JavaLocalContext;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDynamicEObjectsDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedEObjectsDescriptor;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaStream {
    @NonNull
    protected JavaCodeGenerator codeGenerator;
    @NonNull
    protected CG2JavaVisitor cg2java;
    @NonNull
    protected CodeGenAnalyzer analyzer;
    @NonNull
    protected final Id2JavaExpressionVisitor id2JavaExpressionVisitor;
    protected final boolean useNullAnnotations;
    protected final boolean suppressNullWarnings;
    @NonNull
    private StringBuilder s = new StringBuilder();
    @NonNull
    private Stack<String> indentationStack = new Stack();
    @NonNull
    private String defaultIndentationString = "    ";

    @NonNull
    public static PrettyPrintOptions.Global createOptions(@NonNull Visitable element) {
        ResourceSet resourceSet;
        Resource resource;
        Namespace scope = null;
        if (element instanceof EObject) {
            Object eObject = (EObject)element;
            while (eObject != null) {
                if (eObject instanceof Root) break;
                if (eObject instanceof Type) {
                    scope = (Namespace)eObject;
                    break;
                }
                if (eObject instanceof Package) {
                    scope = (Namespace)eObject;
                    break;
                }
                eObject = eObject instanceof ExpressionInOCL && ((ExpressionInOCL)eObject).getContextVariable() != null ? ((ExpressionInOCL)eObject).getContextVariable().getType() : eObject.eContainer();
            }
        }
        PrettyPrintOptions.Global createOptions = PrettyPrinter.createOptions(scope);
        createOptions.setLinelength(80);
        if (element instanceof EObject && (resource = EcoreUtil.getRootContainer((EObject)((EObject)element)).eResource()) != null && (resourceSet = resource.getResourceSet()) != null) {
            MetaModelManager metaModelManager = MetaModelManager.getAdapter((ResourceSet)resourceSet);
            createOptions.setMetaModelManager(metaModelManager);
        }
        return createOptions;
    }

    public JavaStream(@NonNull JavaCodeGenerator codeGenerator, @NonNull CG2JavaVisitor cg2java) {
        this.codeGenerator = codeGenerator;
        this.cg2java = cg2java;
        this.analyzer = codeGenerator.getAnalyzer();
        this.id2JavaExpressionVisitor = cg2java.createId2JavaExpressionVisitor(this);
        CodeGenOptions options = codeGenerator.getOptions();
        this.useNullAnnotations = options.useNullAnnotations();
        this.suppressNullWarnings = this.useNullAnnotations && options.suppressNonNullWarningsForEMFCollections();
    }

    public void append(@Nullable String string) {
        if (string != null) {
            if (this.indentationStack.isEmpty()) {
                this.s.append(string);
            } else {
                int sLength = this.s.length();
                boolean atStartOfLine = sLength == 0 || this.s.charAt(sLength - 1) == '\n';
                int i = 0;
                while (i < string.length()) {
                    char c = string.charAt(i);
                    if (c != '\r') {
                        if (atStartOfLine) {
                            atStartOfLine = false;
                            this.s.append(this.indentationStack.peek());
                        }
                        this.s.append(c);
                        atStartOfLine = c == '\n';
                    }
                    ++i;
                }
            }
        }
    }

    public void appendAssignment(@NonNull CGValuedElement toVariable, @NonNull CGValuedElement cgExpression) {
        if (cgExpression.isInvalid()) {
            cgExpression.accept(this.cg2java);
        } else {
            this.appendLocalStatements(cgExpression);
            this.appendValueName(toVariable);
            this.append(" = ");
            this.appendValueName(cgExpression);
            this.append(";\n");
        }
    }

    public void appendAtomicReferenceTo(@NonNull Class<?> requiredClass, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendAtomicReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            Class<?> actualClass = actualTypeDescriptor.getJavaClass();
            if (cgValue.getValue().isCaught() || !requiredClass.isAssignableFrom(actualClass)) {
                this.append("((");
                this.appendClassReference(requiredClass.getName());
                this.append(")");
                this.appendValueName(cgValue);
                this.append(")");
            } else {
                this.appendValueName(cgValue);
            }
        }
    }

    public void appendAtomicReferenceTo(@NonNull TypeDescriptor requiredTypeDescriptor, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendAtomicReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getValue().isCaught() || !requiredTypeDescriptor.isAssignableFrom(actualTypeDescriptor)) {
                this.append("((");
                this.appendClassReference(requiredTypeDescriptor);
                this.append(")");
                this.appendValueName(cgValue);
                this.append(")");
            } else {
                this.appendValueName(cgValue);
            }
        }
    }

    public void appendAtomicReferenceTo(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendAtomicReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getValue().isCaught()) {
                this.append("((");
                this.appendClassReference(actualTypeDescriptor);
                this.append(")");
                this.appendValueName(cgValue);
                this.append(")");
            } else {
                this.appendValueName(cgValue);
            }
        }
    }

    public void appendCastParameters(@NonNull JavaLocalContext localContext) {
        for (CGVariable cGVariable : localContext.getCastParameters()) {
            cGVariable.accept(this.cg2java);
        }
    }

    public void appendCastParameters(@NonNull JavaLocalContext localContext, @NonNull List<? extends CGParameter> cgParameters) {
        for (CGParameter cGParameter : cgParameters) {
            CGParameter castParameter = localContext.basicGetCastParameter(cGParameter);
            if (castParameter == null) continue;
            castParameter.accept(this.cg2java);
        }
    }

    public void appendClassCast(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendClassCast>>");
        } else {
            TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            this.append("(");
            this.appendClassReference(typeDescriptor);
            this.append(")");
        }
    }

    public void appendClassCast(@Nullable CGValuedElement cgValue, @Nullable Class<?> actualJavaClass) {
        if (cgValue == null) {
            this.append("<<null-appendClassCast>>");
        } else {
            TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            Class<?> requiredJavaClass = typeDescriptor.getJavaClass();
            if (actualJavaClass == null || !requiredJavaClass.isAssignableFrom(actualJavaClass)) {
                this.append("(");
                this.appendClassReference(typeDescriptor.getClassName());
                this.append(")");
            }
        }
    }

    public void appendClassReference(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null->>");
        } else if (cgValue.getValue().isCaught()) {
            this.appendClassReference(Object.class);
        } else {
            TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            typeDescriptor.append(this);
        }
    }

    public void appendClassReference(@Nullable Class<?> javaClass) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            TypeVariable<Class<?>>[] typeParameters = javaClass.getTypeParameters();
            if (typeParameters.length > 0) {
                this.append("<");
                int i = 0;
                while (i < typeParameters.length) {
                    if (i != 0) {
                        this.append(",");
                    }
                    this.append("?");
                    ++i;
                }
                this.append(">");
            }
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@NonNull TypeDescriptor typeDescriptor) {
        typeDescriptor.append(this);
    }

    public void appendClassReference(@Nullable Class<?> javaClass, Class<?> ... typeParameters) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            if (typeParameters.length > 0) {
                this.append("<");
                int i = 0;
                while (i < typeParameters.length) {
                    if (i != 0) {
                        this.append(",");
                    }
                    this.appendClassReference(typeParameters[i]);
                    ++i;
                }
                this.append(">");
            }
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@Nullable Class<?> javaClass, boolean useExtends, Class<?> ... typeParameters) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            if (typeParameters.length > 0) {
                this.append("<");
                int i = 0;
                while (i < typeParameters.length) {
                    if (i != 0) {
                        this.append(",");
                    }
                    if (useExtends) {
                        this.append("? extends ");
                    }
                    this.appendClassReference(typeParameters[i]);
                    ++i;
                }
                this.append(">");
            }
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(Class<?> javaClass, TypeDescriptor ... typeDescriptors) {
        if (javaClass != null) {
            this.appendClassReference(javaClass.getName());
            if (typeDescriptors.length > 0) {
                this.append("<");
                int i = 0;
                while (i < typeDescriptors.length) {
                    if (i != 0) {
                        this.append(",");
                    }
                    this.append("? extends ");
                    TypeDescriptor typeDescriptor = typeDescriptors[i];
                    typeDescriptor.append(this);
                    ++i;
                }
                this.append(">");
            }
        } else {
            this.appendClassReference(Object.class);
        }
    }

    public void appendClassReference(@Nullable String className) {
        if (className != null) {
            int dollar = className.indexOf("$");
            if (dollar > 0) {
                String importClassName = className.substring(0, dollar);
                this.append(ImportUtils.getAffixedName(importClassName));
                this.cg2java.addImport(importClassName);
                this.append(className.substring(dollar).replace('$', '.'));
            } else {
                this.append(ImportUtils.getAffixedName(className));
                this.cg2java.addImport(className);
            }
        }
    }

    public void appendCommentWithOCL(@Nullable String title, @Nullable Element element) {
        this.append("/**\n");
        this.pushIndentation(" * ");
        if (title != null) {
            this.append(String.valueOf(title) + "\n");
        }
        if (element != null) {
            PrettyPrintOptions.Global createOptions = JavaStream.createOptions((Visitable)element);
            this.append(String.valueOf(PrettyPrinter.print((Element)element, (PrettyPrintOptions)createOptions)) + "\n");
            this.popIndentation();
        }
        this.append(" */\n");
    }

    public void appendCopyrightHeader() {
        this.append("/*\n");
        this.pushIndentation(" *");
        this.append(" \u00abcodeGenHelper.getCopyright(' * ')\u00bb\n");
        this.append("************************************************************************\n");
        this.append(" This code is 100% auto-generated\n");
        this.append(" using: " + this.getClass().getName() + "\n");
        this.append("\n");
        this.append(" Do not edit it.\n");
        this.append("/\n");
        this.popIndentation();
        this.append("\n");
    }

    public void appendDeclaration(@NonNull CGValuedElement cgElement) {
        boolean isGlobal = cgElement.isGlobal();
        if (isGlobal) {
            this.append("public static ");
        }
        if (!cgElement.isSettable()) {
            this.append("final ");
        }
        TypeDescriptor typeDescriptor = this.codeGenerator.getTypeDescriptor(cgElement);
        if (this.suppressNullWarnings && (typeDescriptor instanceof UnboxedEObjectsDescriptor || typeDescriptor instanceof UnboxedDynamicEObjectsDescriptor)) {
            this.append("@SuppressWarnings(\"null\")");
        }
        this.appendIsRequired(cgElement.isNonNull());
        this.append(" ");
        this.appendIsCaught(cgElement.isNonInvalid(), cgElement.isCaught());
        this.append(" ");
        this.appendClassReference(cgElement);
        this.append(" ");
        String valueName = this.cg2java.getValueName2(cgElement);
        this.append(valueName);
    }

    public void appendEcoreValue(@NonNull String returnClassName, @NonNull CGValuedElement cgValue) {
        TypeDescriptor javaTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
        Class<?> javaClass = javaTypeDescriptor.getJavaClass();
        String bodyTypeName = javaClass.getName();
        if (!returnClassName.equals(bodyTypeName) && !(cgValue.getValue() instanceof CGParameter)) {
            if (javaClass == Boolean.class) {
                this.appendValueName(cgValue);
            } else if (javaClass == Number.class) {
                if ("java.math.BigDecimal".equals(returnClassName)) {
                    this.appendClassReference(ValuesUtil.class);
                    this.append(".bigDecimalValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("java.math.BigInteger".equals(returnClassName)) {
                    this.appendClassReference(ValuesUtil.class);
                    this.append(".bigIntegerValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("char".equals(returnClassName)) {
                    this.append("(char)");
                    this.appendValueName(cgValue);
                    this.append(".intValue()");
                } else if ("java.lang.Character".equals(returnClassName)) {
                    this.appendClassReference(Character.class);
                    this.append(".valueOf((char)");
                    this.appendValueName(cgValue);
                    this.append(".intValue())");
                } else {
                    this.appendValueName(cgValue);
                    if ("double".equals(returnClassName) || "java.lang.Double".equals(returnClassName)) {
                        this.append(".doubleValue()");
                    } else if ("float".equals(returnClassName) || "java.lang.Float".equals(returnClassName)) {
                        this.append(".floatValue()");
                    } else if ("int".equals(returnClassName) || "java.lang.Integer".equals(returnClassName)) {
                        this.append(".intValue()");
                    } else if ("long".equals(returnClassName) || "java.lang.Long".equals(returnClassName)) {
                        this.append(".longValue()");
                    } else if ("short".equals(returnClassName) || "java.lang.Short".equals(returnClassName)) {
                        this.append(".shortValue()");
                    }
                }
            } else if (javaClass == Object.class) {
                if ("java.math.BigInteger".equals(returnClassName)) {
                    this.appendClassReference(ValuesUtil.class);
                    this.append(".bigIntegerValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else if ("char".equals(returnClassName) || "java.lang.Character".equals(returnClassName)) {
                    this.appendClassReference(ValuesUtil.class);
                    this.append(".characterValueOf(");
                    this.appendValueName(cgValue);
                    this.append(")");
                } else {
                    this.append("((");
                    this.appendClassReference(Number.class);
                    this.append(")");
                    this.appendValueName(cgValue);
                    this.append(")");
                    if ("int".equals(returnClassName) || "java.lang.Integer".equals(returnClassName)) {
                        this.append(".intValue()");
                    } else if ("long".equals(returnClassName) || "java.lang.Long".equals(returnClassName)) {
                        this.append(".longValue()");
                    } else if ("short".equals(returnClassName) || "java.lang.Short".equals(returnClassName)) {
                        this.append(".shortValue()");
                    }
                }
            } else {
                this.append("(");
                this.appendClassReference(returnClassName);
                this.append(")");
                this.appendValueName(cgValue);
            }
        } else {
            this.appendValueName(cgValue);
        }
    }

    public void appendFalse() {
        this.appendClassReference(ValuesUtil.class);
        this.append(".FALSE_VALUE");
    }

    public void appendIdReference(@Nullable ElementId elementId) {
        if (elementId == null) {
            this.append("<<null-appendIdReference>>");
        } else if (CGUtils.isInlineableId(elementId)) {
            elementId.accept((IdVisitor)this.id2JavaExpressionVisitor);
        } else {
            this.appendValueName(this.analyzer.getElementId(elementId));
        }
    }

    public void appendIdReference2(@NonNull ElementId elementId) {
        elementId.accept((IdVisitor)this.id2JavaExpressionVisitor);
    }

    public void appendIsCaught(boolean isNonInvalid, boolean isCaught) {
        this.append("/*");
        this.append(isNonInvalid ? "@NonInvalid" : (isCaught ? "@Caught" : "@Thrown"));
        this.append("*/");
    }

    public void appendIsRequired(boolean isRequired) {
        if (!this.useNullAnnotations) {
            this.append("/*");
            this.append(isRequired ? "@NonNull" : "@Nullable");
            this.append("*/");
        } else {
            this.append("@");
            this.appendClassReference(isRequired ? "org.eclipse.jdt.annotation.NonNull" : "org.eclipse.jdt.annotation.Nullable");
        }
    }

    public void appendLocalStatements(@NonNull CGValuedElement cgElement) {
        if (!(cgElement.isInlineable() || cgElement.isConstant() || cgElement.isGlobal())) {
            cgElement.accept(this.cg2java);
        }
    }

    public void appendQualifiedLiteralName(@NonNull Operation anOperation) {
        GenPackage genPackage;
        Type type = anOperation.getOwningType();
        if (type != null && (genPackage = this.codeGenerator.getGenModelHelper().getGenPackage(type)) != null) {
            String qualifiedPackageName = String.valueOf(genPackage.getQualifiedPackageName());
            String tablesClassName = String.valueOf(genPackage.getPrefix()) + "Tables";
            this.appendClassReference(String.valueOf(qualifiedPackageName) + "." + tablesClassName);
            this.append(".Operations._" + type.getName() + "__" + AbstractGenModelHelper.encodeName((NamedElement)anOperation));
        }
    }

    public void appendReferenceTo(@NonNull Class<?> requiredClass, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getValue().isCaught() || !actualTypeDescriptor.isAssignableTo(requiredClass)) {
                this.append("(");
                this.appendClassReference(requiredClass.getName());
                this.append(")");
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendReferenceTo(@NonNull TypeDescriptor requiredTypeDescriptor, @Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendReferenceTo>>");
        } else {
            TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
            if (cgValue.getValue().isCaught() || !requiredTypeDescriptor.isAssignableFrom(actualTypeDescriptor)) {
                this.append("(");
                this.appendClassReference(requiredTypeDescriptor.getClassName());
                this.append(")");
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendReferenceTo(@Nullable CGValuedElement cgValue) {
        if (cgValue == null) {
            this.append("<<null-appendReferenceTo>>");
        } else {
            if (cgValue.getValue().isCaught()) {
                TypeDescriptor actualTypeDescriptor = this.codeGenerator.getTypeDescriptor(cgValue);
                this.append("(");
                this.appendClassReference(actualTypeDescriptor.getClassName());
                this.append(")");
            }
            this.appendValueName(cgValue);
        }
    }

    public void appendString(@NonNull String string) {
        String javaString = Strings.convertToJavaString((String)string);
        this.append("\"");
        this.append(javaString);
        this.append("\"");
    }

    public void appendTrue() {
        this.appendClassReference(ValuesUtil.class);
        this.append(".TRUE_VALUE");
    }

    public void appendValueName(@Nullable CGValuedElement cgElement) {
        if (cgElement == null) {
            this.append("<<null-appendValueName>>");
        } else if (cgElement.isInlineable()) {
            CGValuedElement cgNext;
            CGValuedElement cgValue = cgElement;
            while ((cgNext = cgValue.getReferredValuedElement()) != cgValue) {
                cgValue = cgNext;
            }
            cgValue.accept(this.cg2java);
        } else {
            if (cgElement.isGlobal()) {
                this.cg2java.appendGlobalPrefix();
            }
            String valueName = this.cg2java.getValueName2(cgElement);
            this.append(valueName);
        }
    }

    @NonNull
    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @NonNull
    protected String getValueName(@NonNull CGValuedElement cgElement) {
        String name = cgElement.getValueName();
        if (name == null) {
            name = cgElement.getName();
        }
        if (name == null) {
            name = "<null-" + cgElement.eClass().getName() + ">";
        }
        return name;
    }

    public void popIndentation() {
        this.indentationStack.pop();
    }

    public void pushIndentation(@Nullable String extraIndentation) {
        if (extraIndentation == null) {
            extraIndentation = this.defaultIndentationString;
        }
        if (this.indentationStack.isEmpty()) {
            this.indentationStack.push(extraIndentation);
        } else {
            this.indentationStack.push(String.valueOf(this.indentationStack.peek()) + extraIndentation);
        }
    }

    public void resetStream() {
        this.s.setLength(0);
    }

    @NonNull
    public String toString() {
        String string = this.s.toString();
        return string;
    }
}

