/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinecore;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.internal.options.CodeGenerationMode;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.examples.codegen.common.PivotQueries;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreCodeGenerator;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGeneratorAdapterFactory;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreTables;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.LibraryConstants;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.codegen.ecore.genmodel.util.UML2GenModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLinEcoreGenModelGeneratorAdapter
extends GenBaseGeneratorAdapter {
    @NonNull
    public static final String OCL_GENMODEL_URI = "http://www.eclipse.org/OCL/GenModel";
    @NonNull
    public static final String USE_DELEGATES_KEY = "Use Delegates";
    @NonNull
    public static final String USE_NULL_ANNOTATIONS_KEY = "Use Null Annotations";
    @NonNull
    private Set<GenModel> hadDelegates = new HashSet<GenModel>();
    @NonNull
    private Map<GenPackage, String> constantsTexts = new HashMap<GenPackage, String>();

    public static boolean useDelegates(@NonNull GenModel genModel) {
        EMap details;
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null && (details = genAnnotation.getDetails()).containsKey((Object)USE_DELEGATES_KEY)) {
            return Boolean.valueOf((String)details.get((Object)USE_DELEGATES_KEY));
        }
        CodeGenerationMode preference = (CodeGenerationMode)CommonOptions.CODE_GENERATION_MODE.getPreferredValue();
        return preference == CodeGenerationMode.DELEGATED;
    }

    public static boolean useNullAnnotations(@NonNull GenModel genModel) {
        EMap details;
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null && (details = genAnnotation.getDetails()).containsKey((Object)USE_NULL_ANNOTATIONS_KEY)) {
            return Boolean.valueOf((String)details.get((Object)USE_NULL_ANNOTATIONS_KEY));
        }
        return false;
    }

    public OCLinEcoreGenModelGeneratorAdapter(@NonNull OCLinEcoreGeneratorAdapterFactory generatorAdapterFactory) {
        super((GeneratorAdapterFactory)generatorAdapterFactory);
    }

    protected void convertConstraintToOperation(@NonNull Ecore2Pivot ecore2pivot, @NonNull GenModel genModel, @NonNull EClassifier eClassifier, @NonNull String key, @NonNull String body, @Nullable String message) {
        Type pType = (Type)ecore2pivot.getCreated(Type.class, (EObject)eClassifier);
        if (pType != null) {
            List ownedInvariants = pType.getOwnedInvariant();
            for (Constraint rule : ownedInvariants) {
                String ruleName = rule.getName();
                if (ruleName == null) {
                    ruleName = "";
                }
                if (!ruleName.equals(key)) continue;
                String prefix = UML2GenModelUtil.getInvariantPrefix((GenModel)genModel);
                if (prefix == null) {
                    prefix = "";
                }
                EOperation eOperation = Pivot2Ecore.createConstraintEOperation((Constraint)rule, (String)(String.valueOf(prefix) + ruleName));
                ((EClass)eClassifier).getEOperations().add((Object)eOperation);
                ecore2pivot.addMapping((EObject)eOperation, (Element)rule);
                EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", (String)"body", (String)body);
                if (message == null) continue;
                EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", (String)"body$message", (String)message);
            }
        }
    }

    protected void convertConstraintsToOperations(@NonNull MetaModelManager metaModelManager, @NonNull GenModel genModel) {
        List genPackages = genModel.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            Ecore2Pivot ecore2pivot;
            EPackage ecorePackage = genPackage.getEcorePackage();
            Resource ecoreResource = ecorePackage.eResource();
            if (ecoreResource == null || (ecore2pivot = Ecore2Pivot.getAdapter((Resource)ecoreResource, (MetaModelManager)metaModelManager)) == null) continue;
            for (GenClass genClass : genPackage.getGenClasses()) {
                EClass eClass = genClass.getEcoreClass();
                if (eClass == null) continue;
                EClass eClassifier = eClass;
                ArrayList<EAnnotation> obsoleteAnnotations = null;
                for (EAnnotation eAnnotation : eClassifier.getEAnnotations()) {
                    String source = eAnnotation.getSource();
                    if (OCLCommon.isDelegateURI((String)source)) {
                        EMap details = eAnnotation.getDetails();
                        for (String key : details.keySet()) {
                            if (key == null || key.endsWith("$message")) continue;
                            String expression = (String)details.get((Object)key);
                            String messageExpression = (String)details.get((Object)(String.valueOf(key) + "$message"));
                            if (expression == null) continue;
                            this.convertConstraintToOperation(ecore2pivot, genModel, (EClassifier)eClassifier, key, expression, messageExpression);
                        }
                        if (obsoleteAnnotations == null) {
                            obsoleteAnnotations = new ArrayList<EAnnotation>();
                        }
                        obsoleteAnnotations.add(eAnnotation);
                    }
                    if (!"http://www.eclipse.org/emf/2002/Ecore".equals(source)) continue;
                    eAnnotation.getDetails().remove((Object)"constraints");
                }
                if (obsoleteAnnotations != null) {
                    eClassifier.getEAnnotations().removeAll(obsoleteAnnotations);
                }
                genClass.initialize(eClass);
            }
        }
    }

    protected void createDispatchTables(@NonNull GenModel genModel, @NonNull Monitor monitor) throws IOException {
        try {
            String lineDelimiter = this.getLineDelimiter(genModel);
            genModel.setLineDelimiter(lineDelimiter);
            File projectFolder = this.getProjectFolder(genModel);
            List genPackages = genModel.getAllGenPackagesWithClassifiers();
            for (GenPackage genPackage : genPackages) {
                OCLinEcoreTables generateTables = new OCLinEcoreTables(genPackage);
                String tablesClass = generateTables.getTablesClassName();
                String dir = genPackage.getQualifiedPackageName().replace(".", "/");
                generateTables.generateTablesClass(this.constantsTexts.get(genPackage));
                String str = generateTables.toString();
                File tablesFolder = new File(projectFolder, dir);
                tablesFolder.mkdirs();
                File file = new File(tablesFolder, String.valueOf(tablesClass) + ".java");
                FileWriter testFile = new FileWriter(file);
                testFile.append(str);
                testFile.close();
            }
        }
        finally {
            genModel.setLineDelimiter(null);
        }
    }

    @NonNull
    protected Map<String, String> createFeatureBodies(@NonNull GenModel genModel) throws IOException {
        HashMap<String, String> allResults = new HashMap<String, String>();
        List genPackages = genModel.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            MetaModelManager metaModelManager = PivotUtil.getMetaModelManager((Resource)((Resource)DomainUtil.nonNullState((Object)genPackage.eResource())));
            OCLinEcoreCodeGenerator converter = new OCLinEcoreCodeGenerator(metaModelManager, genPackage);
            Map<String, String> results = converter.generateBodies();
            for (Map.Entry<String, String> entry : results.entrySet()) {
                allResults.put(entry.getKey(), entry.getValue());
            }
            this.constantsTexts.put(genPackage, converter.generateConstants());
        }
        ArrayList resultsKeys = new ArrayList(allResults.keySet());
        Collections.sort(resultsKeys);
        return allResults;
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        assert (object != null);
        GenModel genModel = (GenModel)object;
        try {
            if (projectType == "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject" && !OCLinEcoreGenModelGeneratorAdapter.useDelegates(genModel) && (this.hasDelegates(genModel) || this.hadDelegates.contains(genModel))) {
                EList modelPluginVariables = genModel.getModelPluginVariables();
                if (!modelPluginVariables.contains(LibraryConstants.PLUGIN_ID)) {
                    modelPluginVariables.add(LibraryConstants.PLUGIN_ID);
                }
                if (!modelPluginVariables.contains("org.eclipse.ocl.examples.pivot")) {
                    modelPluginVariables.add("org.eclipse.ocl.examples.pivot");
                }
                if (!modelPluginVariables.contains("org.eclipse.ocl.examples.codegen")) {
                    modelPluginVariables.add("org.eclipse.ocl.examples.codegen");
                }
                if (OCLinEcoreGenModelGeneratorAdapter.useNullAnnotations(genModel) && !modelPluginVariables.contains("org.eclipse.jdt.annotation")) {
                    modelPluginVariables.add("org.eclipse.jdt.annotation");
                }
                for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
                    this.createImportManager(genPackage.getReflectionPackageName(), String.valueOf(genPackage.getFactoryInterfaceName()) + "Tables");
                }
                Resource genResource = genModel.eResource();
                ResourceSet resourceSet = genResource.getResourceSet();
                if (resourceSet == null) {
                    throw new NullPointerException("No ResourceSet for genmodel");
                }
                MetaModelManager metaModelManager = MetaModelManager.findAdapter((ResourceSet)resourceSet);
                MetaModelManagerResourceSetAdapter adapter = MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, (MetaModelManager)metaModelManager);
                metaModelManager = adapter.getMetaModelManager();
                this.convertConstraintsToOperations(metaModelManager, genModel);
                Map<String, String> results = this.createFeatureBodies(genModel);
                this.installJavaBodies(metaModelManager, genModel, results);
                this.pruneDelegates(genModel);
            }
        }
        catch (Exception e) {
            BasicDiagnostic thisDiagnostic = new BasicDiagnostic(4, ((Object)((Object)this)).getClass().getPackage().getName(), 0, "Failed to pre-generate " + genModel.getModelPluginID() + " constraints", new Object[]{e});
            Diagnostic thatDiagnostic = super.doPreGenerate(object, projectType);
            if (thatDiagnostic.getSeverity() == 0) {
                return thisDiagnostic;
            }
            thatDiagnostic.getChildren().add(thisDiagnostic);
            return thatDiagnostic;
        }
        return super.doPreGenerate(object, projectType);
    }

    protected Diagnostic generateModel(Object object, Monitor monitor) {
        assert (object != null);
        GenModel genModel = (GenModel)object;
        try {
            if (!OCLinEcoreGenModelGeneratorAdapter.useDelegates(genModel) && this.hadDelegates.contains(genModel)) {
                monitor.beginTask("", 4);
                monitor.subTask("Generating Dispatch Tables");
                for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
                    this.createImportManager(genPackage.getReflectionPackageName(), String.valueOf(genPackage.getFactoryInterfaceName()) + "Tables");
                }
                this.createDispatchTables(genModel, monitor);
                monitor.worked(1);
                monitor.worked(1);
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    String modelProjectDirectory = genModel.getModelProjectDirectory();
                    IProject modelProject = workspace.getRoot().getProject(modelProjectDirectory);
                    modelProject.refreshLocal(2, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                }
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            BasicDiagnostic thisDiagnostic = new BasicDiagnostic(4, ((Object)((Object)this)).getClass().getPackage().getName(), 0, "Failed to generate " + genModel.getModelPluginID() + " tables and bodies", new Object[]{e});
            Diagnostic thatDiagnostic = super.generateModel(object, monitor);
            if (thatDiagnostic.getSeverity() == 0) {
                return thisDiagnostic;
            }
            thatDiagnostic.getChildren().add(thisDiagnostic);
            return thatDiagnostic;
        }
        return super.generateModel(object, monitor);
    }

    protected String getLineDelimiter(GenModel genModel) {
        String modelProjectDirectory = String.valueOf(genModel.getModelProjectDirectory()) + "/.project";
        URI workspacePath = URI.createURI((String)modelProjectDirectory);
        String targetFileEncoding = this.getEncoding(workspacePath);
        return this.getLineDelimiter(workspacePath, targetFileEncoding);
    }

    @NonNull
    protected File getProjectFolder(@NonNull GenModel genModel) {
        String modelProjectDirectory = genModel.getModelProjectDirectory();
        String modelDirectory = genModel.getModelDirectory();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject modelProject = workspace.getRoot().getProject(modelProjectDirectory);
            Path javaSource = new Path(modelDirectory);
            IFolder folder = modelProject.getParent().getFolder((IPath)javaSource);
            java.net.URI locationURI = folder.getLocationURI();
            return new File(locationURI.getRawPath());
        }
        URI locationURI = URI.createPlatformResourceURI((String)modelDirectory, (boolean)true);
        ResourceSet resourceSet = genModel.eResource().getResourceSet();
        URIConverter uriConverter = resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
        URI normalizedURI = uriConverter.normalize(locationURI);
        return new File(normalizedURI.toFileString());
    }

    protected boolean hasConstraints(Class pivotClass) {
        if (pivotClass.getOwnedInvariant().size() > 0) {
            return true;
        }
        for (Operation operation : PivotQueries.getOperations((Type)pivotClass)) {
            if (operation.getPrecondition().size() > 0) {
                return true;
            }
            if (operation.getPostcondition().size() > 0) {
                return true;
            }
            if (operation.getBodyExpression() == null) continue;
            return true;
        }
        for (Property property : PivotQueries.getProperties((Type)pivotClass)) {
            if (property.getDefaultExpression() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDelegates(@NonNull GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            EPackage ePackage = genPackage.getEcorePackage();
            if (ePackage == null || !this.hasDelegates(ePackage)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDelegates(@NonNull EPackage ePackage) {
        List validationDelegates = EcoreUtil.getValidationDelegates((EPackage)ePackage);
        for (String validationDelegate : validationDelegates) {
            if (!OCLCommon.isDelegateURI((String)validationDelegate)) continue;
            return true;
        }
        List settingDelegates = EcoreUtil.getSettingDelegates((EPackage)ePackage);
        for (String settingDelegate : settingDelegates) {
            if (!OCLCommon.isDelegateURI((String)settingDelegate)) continue;
            return true;
        }
        List invocationDelegates = EcoreUtil.getInvocationDelegates((EPackage)ePackage);
        for (String invocationDelegate : invocationDelegates) {
            if (!OCLCommon.isDelegateURI((String)invocationDelegate)) continue;
            return true;
        }
        return false;
    }

    protected void installJavaBodies(@NonNull MetaModelManager metaModelManager, @NonNull GenModel genModel, @NonNull Map<String, String> results) {
        List genPackages = genModel.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            Ecore2Pivot ecore2pivot;
            EPackage ecorePackage = genPackage.getEcorePackage();
            Resource ecoreResource = ecorePackage.eResource();
            if (ecoreResource == null || (ecore2pivot = Ecore2Pivot.getAdapter((Resource)ecoreResource, (MetaModelManager)metaModelManager)) == null) continue;
            for (GenClass genClass : genPackage.getGenClasses()) {
                EClass eClass = genClass.getEcoreClass();
                if (eClass == null) continue;
                for (EOperation eOperation : eClass.getEOperations()) {
                    this.installOperation(ecore2pivot, eOperation, results);
                }
                for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                    this.installProperty(ecore2pivot, eFeature, results);
                }
            }
        }
    }

    protected void installOperation(@NonNull Ecore2Pivot ecore2pivot, @NonNull EOperation eOperation, @NonNull Map<String, String> results) {
        String body;
        Element pOperation = ecore2pivot.getCreated(Element.class, (EObject)eOperation);
        String fragmentURI = null;
        if (pOperation instanceof Operation) {
            fragmentURI = EcoreUtil.getURI((EObject)pOperation).fragment().toString();
        } else if (pOperation instanceof Constraint) {
            Constraint constraint = (Constraint)pOperation;
            fragmentURI = String.valueOf(EcoreUtil.getURI((EObject)constraint.eContainer()).fragment().toString()) + "==" + constraint.getName();
        }
        String string = body = fragmentURI != null ? results.get(fragmentURI) : null;
        if (body == null || (body = body.trim()).length() == 0) {
            body = "throw new UnsupportedOperationException();  // FIXME Unimplemented " + (pOperation != null ? Pivot2Moniker.toString((Element)pOperation) : "");
        }
        EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body", (String)body);
        EList eAnnotations = eOperation.getEAnnotations();
        EAnnotation oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
    }

    protected void installProperty(@NonNull Ecore2Pivot ecore2pivot, @NonNull EStructuralFeature eFeature, @NonNull Map<String, String> results) {
        Property pProperty = (Property)ecore2pivot.getCreated(Property.class, (EObject)eFeature);
        String fragmentURI = EcoreUtil.getURI((EObject)pProperty).fragment().toString();
        String body = results.get(fragmentURI);
        if (body == null) {
            body = "throw new UnsupportedOperationException();  // FIXME Unimplemented " + (pProperty != null ? Pivot2Moniker.toString((Element)pProperty) : "");
        }
        EcoreUtil.setAnnotation((EModelElement)eFeature, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"get", (String)body);
        EList eAnnotations = eFeature.getEAnnotations();
        EAnnotation oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
    }

    protected void pruneDelegates(@NonNull GenModel genModel) {
        for (GenPackage genPackage : genModel.getAllGenPackagesWithClassifiers()) {
            EPackage ePackage = genPackage.getEcorePackage();
            if (ePackage == null || !this.hasDelegates(ePackage)) continue;
            this.hadDelegates.add(genModel);
            EcoreUtil.setValidationDelegates((EPackage)ePackage, this.pruneDelegates(EcoreUtil.getValidationDelegates((EPackage)ePackage)));
            EcoreUtil.setSettingDelegates((EPackage)ePackage, this.pruneDelegates(EcoreUtil.getSettingDelegates((EPackage)ePackage)));
            EcoreUtil.setInvocationDelegates((EPackage)ePackage, this.pruneDelegates(EcoreUtil.getInvocationDelegates((EPackage)ePackage)));
        }
    }

    protected List<String> pruneDelegates(@Nullable List<String> oldDelegates) {
        ArrayList<String> newDelegates = new ArrayList<String>();
        if (oldDelegates != null) {
            for (String aDelegate : oldDelegates) {
                if (OCLCommon.isDelegateURI((String)aDelegate)) continue;
                newDelegates.add(aDelegate);
            }
        }
        return newDelegates;
    }
}

