/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.oclinjunit;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.Pivot2CGVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGClass;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGOperation;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGParameter;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.CG2JavaVisitor;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.util.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitCG2JavaClassVisitor
extends CG2JavaVisitor {
    @NonNull
    protected final ExpressionInOCL expInOcl;
    @NonNull
    protected final CGPackage cgPackage;

    @NonNull
    public static JUnitCG2JavaClassVisitor generate(@NonNull JavaCodeGenerator codeGenerator, @NonNull ExpressionInOCL expInOcl, String packageName, String className) {
        JUnitCG2JavaClassVisitor cg2JavaClassVisitor = new JUnitCG2JavaClassVisitor(codeGenerator, expInOcl, packageName, className);
        cg2JavaClassVisitor.generate();
        return cg2JavaClassVisitor;
    }

    public JUnitCG2JavaClassVisitor(@NonNull JavaCodeGenerator codeGenerator, @NonNull ExpressionInOCL expInOcl, String packageName, String className) {
        super(codeGenerator);
        this.expInOcl = expInOcl;
        this.cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        this.cgPackage.setName(packageName);
        CGClass cgClass = CGModelFactory.eINSTANCE.createCGClass();
        cgClass.setName(className);
        this.cgPackage.getClasses().add(cgClass);
        CGOperation cgOperation = this.createCGOperation(expInOcl);
        cgClass.getOperations().add(cgOperation);
        this.analyzer.analyze(this.cgPackage);
    }

    @NonNull
    public CGOperation createCGOperation(@NonNull ExpressionInOCL expInOcl) {
        Variable contextVariable = expInOcl.getContextVariable();
        if (contextVariable != null) {
            contextVariable.setIsRequired(false);
        }
        Pivot2CGVisitor pivot2CGVisitor = new Pivot2CGVisitor(this.analyzer);
        CGValuedElement cgBody = (CGValuedElement)DomainUtil.nonNullState((Object)((CGNamedElement)expInOcl.accept((Visitor)pivot2CGVisitor)));
        CGOperation cgOperation = CGModelFactory.eINSTANCE.createCGOperation();
        List<CGParameter> cgParameters = cgOperation.getParameters();
        if (contextVariable != null) {
            CGParameter cgContext = pivot2CGVisitor.getParameter(contextVariable);
            cgParameters.add(cgContext);
        }
        for (Variable parameterVariable : expInOcl.getParameterVariable()) {
            CGParameter cgParameter = pivot2CGVisitor.getParameter(parameterVariable);
            cgParameters.add(cgParameter);
        }
        cgOperation.setPivot((NamedElement)expInOcl);
        TypeId pivotTypeId = expInOcl.getTypeId();
        cgOperation.setTypeId(this.analyzer.getTypeId(pivotTypeId));
        cgOperation.setName(this.globalContext.getEvaluateName());
        cgOperation.setBody(cgBody);
        return cgOperation;
    }

    protected void generate() {
        CG2JavaPreVisitor cg2PreVisitor = ((JavaCodeGenerator)this.context).createCG2JavaPreVisitor();
        this.cgPackage.accept(cg2PreVisitor);
        this.safeVisit(this.cgPackage);
    }

    @Override
    @NonNull
    public Set<String> getAllImports() {
        return this.globalContext.getImports();
    }

    @Override
    @Nullable
    public Object visitCGClass(@NonNull CGClass cgClass) {
        Class<?> baseClass = this.genModelHelper.getAbstractOperationClass(this.expInOcl.getParameterVariable());
        String title = String.valueOf(cgClass.getName()) + " provides the Java implementation for\n";
        this.js.appendCommentWithOCL(title, (Element)this.expInOcl);
        String className = cgClass.getName();
        this.js.append("@SuppressWarnings(\"nls\")\n");
        this.js.append("public class " + className + " extends ");
        this.js.appendClassReference(baseClass);
        this.js.append("\n");
        this.js.append("{\n");
        this.js.pushIndentation(null);
        this.js.append("public static final ");
        this.js.appendIsRequired(true);
        this.js.append(" " + className + " " + this.globalContext.getInstanceName() + " = new " + className + "();\n");
        DependencyVisitor dependencyVisitor = new DependencyVisitor(this.analyzer);
        dependencyVisitor.visitAll(this.globalContext.getGlobals());
        dependencyVisitor.visitAll(cgClass.getOperations());
        Iterable<CGValuedElement> sortedDependencies = dependencyVisitor.getSortedDependencies();
        this.generateGlobals(sortedDependencies);
        this.js.append("\n");
        if (this.expInOcl.getContextVariable() != null) {
            for (CGOperation cgOperation : cgClass.getOperations()) {
                cgOperation.accept(this);
            }
        } else {
            this.js.append("/*\n");
            this.js.append("\u00abIF expInOcl.messageExpression != null\u00bb\u00ab(expInOcl.messageExpression as StringLiteralExp).stringSymbol\u00bb\u00abENDIF\u00bb\n");
            this.js.append("*/\n");
        }
        this.js.popIndentation();
        this.js.append("}\n");
        return null;
    }
}

