/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.types.IdResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformation {
    @NonNull
    protected final DomainEvaluator evaluator;
    @NonNull
    protected final IdResolver idResolver;
    @NonNull
    protected final List<EObject>[] modelObjects;
    @NonNull
    protected final Map<String, Integer> modelIndexes = new HashMap<String, Integer>();

    protected AbstractTransformation(@NonNull DomainEvaluator evaluator, @NonNull String[] modelNames) {
        this.evaluator = evaluator;
        this.idResolver = evaluator.getIdResolver();
        List[] modelObjects = new List[modelNames.length];
        this.modelObjects = modelObjects;
        int i = 0;
        while (i < modelNames.length) {
            modelObjects[i] = new ArrayList();
            this.modelIndexes.put(modelNames[i], i);
            ++i;
        }
    }

    public void addRootObjects(@NonNull String modelName, @NonNull List<? extends EObject> eRootObjects) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        List<EObject> eObjects = this.modelObjects[modelIndex];
        for (EObject eObject : eRootObjects) {
            if (eObjects.contains(eObject)) continue;
            eObjects.add(eObject);
        }
    }

    @NonNull
    protected <T extends EObject> List<T> getObjectsByType(@NonNull Class<T> javaClass, int modelIndex, @NonNull EClass eClass) {
        List<EObject> eRootObjects = this.modelObjects[modelIndex];
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eRootObject : eRootObjects) {
            if (eClass.isInstance((Object)eRootObject)) {
                EObject eObject2 = eRootObject;
                eObjects.add(eObject2);
            }
            TreeIterator tit = eRootObject.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!eClass.isInstance((Object)eObject)) continue;
                EObject eObject2 = eObject;
                eObjects.add(eObject2);
            }
        }
        return eObjects;
    }

    @NonNull
    public List<EObject> getRootObjects(@NonNull String modelName) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        List<EObject> eObjects = this.modelObjects[modelIndex];
        ArrayList<EObject> eRootObjects = new ArrayList<EObject>(eObjects.size());
        for (EObject eObject : eObjects) {
            if (eObject.eContainer() != null) continue;
            eRootObjects.add(eObject);
        }
        return eRootObjects;
    }

    public abstract boolean run() throws Exception;
}

