/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.values.Bag;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.BagImpl;
import org.eclipse.ocl.examples.domain.values.impl.CollectionValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.SparseSequenceValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagValueImpl
extends CollectionValueImpl
implements BagValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.BAG_VALUE;
    }

    @NonNull
    public static Bag<Object> createBagOfEach(@NonNull Object[] boxedValues) {
        BagImpl<Object> result = new BagImpl<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public BagValueImpl(@NonNull CollectionTypeId typeId, @NonNull Bag<? extends Object> boxedValues) {
        super(typeId, boxedValues);
    }

    @Override
    @NonNull
    public BagValue asBagValue() {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BagValueImpl) || obj instanceof SetValue) {
            return false;
        }
        return this.elements.equals(((BagValueImpl)obj).elements);
    }

    @Override
    @NonNull
    public BagValue excluding(@Nullable Object value) {
        BagImpl result = new BagImpl();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new BagValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public BagValue flatten() {
        BagImpl<Object> flattened = new BagImpl<Object>();
        if (this.flatten(flattened)) {
            return new BagValueImpl(this.getTypeId(), (Bag<? extends Object>)flattened);
        }
        return this;
    }

    @NonNull
    public Bag<? extends Object> getElements() {
        return (Bag)this.elements;
    }

    @Override
    @NonNull
    public String getKind() {
        return "Bag";
    }

    @Override
    @NonNull
    public BagValue including(@Nullable Object value) {
        assert (!(value instanceof InvalidValueException));
        BagImpl<Object> result = new BagImpl<Object>(this.elements);
        result.add(value);
        return new BagValueImpl(this.getTypeId(), (Bag<? extends Object>)result);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    @NonNull
    public SequenceValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), values);
    }

    @Override
    @NonNull
    public SequenceValue toSequenceValue() {
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), new ArrayList(this.elements));
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Bag");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends BagValueImpl
    implements BagValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new BagImpl());
        }

        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }
    }
}

