/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.ExecutorProperty;

public abstract class AbstractExecutorProperty
implements DomainProperty {
    @NonNull
    protected final String name;
    @NonNull
    protected final DomainInheritance executorType;
    protected final int propertyIndex;
    protected ExecutorProperty opposite;

    public AbstractExecutorProperty(@NonNull String name, @NonNull DomainInheritance executorType, int propertyIndex) {
        this.name = name;
        this.executorType = executorType;
        this.propertyIndex = propertyIndex;
        this.opposite = null;
    }

    public DomainExpression getDefaultExpression() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainStandardLibrary standardLibrary) {
        return this.executorType;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public DomainProperty getOpposite() {
        return (DomainProperty)DomainUtil.nonNullState((Object)this.opposite);
    }

    public DomainType getOwningType() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainType getType() {
        return this.executorType;
    }

    @NonNull
    public TypeId getTypeId() {
        DomainType type2 = this.getType();
        return type2.getTypeId();
    }

    void initOpposite(@NonNull ExecutorProperty opposite) {
        this.opposite = opposite;
    }

    public void initValue(@NonNull Object objectValue, @Nullable Object propertyValue) {
        throw new UnsupportedOperationException();
    }

    public boolean isStatic() {
        return false;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.executorType)) + "::" + String.valueOf(this.name);
    }
}

