/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainMetaclass;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.types.AbstractCollectionType;
import org.eclipse.ocl.examples.domain.types.AbstractStandardLibrary;
import org.eclipse.ocl.examples.domain.types.AbstractTupleType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;

public abstract class ExecutableStandardLibrary
extends AbstractStandardLibrary {
    @NonNull
    private Map<DomainType, WeakReference<DomainMetaclass>> classifiers = new WeakHashMap<DomainType, WeakReference<DomainMetaclass>>();
    @NonNull
    private Map<DomainType, Map<DomainType, WeakReference<AbstractCollectionType>>> specializations = new WeakHashMap<DomainType, Map<DomainType, WeakReference<AbstractCollectionType>>>();
    @NonNull
    private Map<TupleTypeId, WeakReference<DomainTupleType>> tupleTypeMap = new WeakHashMap<TupleTypeId, WeakReference<DomainTupleType>>();

    @NonNull
    protected abstract DomainMetaclass createMetaclass(@NonNull DomainType var1);

    @NonNull
    public DomainType getBagType() {
        return OCLstdlibTables.Types._Bag;
    }

    @NonNull
    public DomainCollectionType getBagType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType(this.getBagType(), elementType, lower, upper);
    }

    @NonNull
    public DomainType getBooleanType() {
        return OCLstdlibTables.Types._Boolean;
    }

    @NonNull
    public DomainType getCollectionType() {
        return OCLstdlibTables.Types._Collection;
    }

    @NonNull
    public synchronized DomainCollectionType getCollectionType(@NonNull DomainType genericType, @NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        AbstractCollectionType specializedType = null;
        Map<DomainType, WeakReference<AbstractCollectionType>> map = this.specializations.get(genericType);
        if (map == null) {
            map = new WeakHashMap<DomainType, WeakReference<AbstractCollectionType>>();
            this.specializations.put(genericType, map);
        } else {
            specializedType = (AbstractCollectionType)this.weakGet(map, elementType);
        }
        if (specializedType == null) {
            specializedType = new AbstractCollectionType((DomainStandardLibrary)this, (String)DomainUtil.nonNullModel((Object)genericType.getName()), genericType, elementType, lower, upper);
            map.put(elementType, new WeakReference<AbstractCollectionType>(specializedType));
        }
        return specializedType;
    }

    @NonNull
    public DomainType getIntegerType() {
        return OCLstdlibTables.Types._Integer;
    }

    @NonNull
    public synchronized DomainMetaclass getMetaclass(@NonNull DomainType classType) {
        DomainMetaclass metaclass = (DomainMetaclass)this.weakGet(this.classifiers, classType);
        if (metaclass == null) {
            metaclass = this.createMetaclass(classType);
            this.classifiers.put(classType, new WeakReference<DomainMetaclass>(metaclass));
        }
        return metaclass;
    }

    @NonNull
    public DomainType getOclAnyType() {
        return OCLstdlibTables.Types._OclAny;
    }

    @NonNull
    public DomainType getOclComparableType() {
        return OCLstdlibTables.Types._OclComparable;
    }

    @NonNull
    public DomainType getOclElementType() {
        return OCLstdlibTables.Types._OclElement;
    }

    @NonNull
    public DomainType getOclInvalidType() {
        return OCLstdlibTables.Types._OclInvalid;
    }

    public DomainType getOclMessageType() {
        return OCLstdlibTables.Types._OclMessage;
    }

    @NonNull
    public DomainType getOclSelfType() {
        return OCLstdlibTables.Types._OclSelf;
    }

    @NonNull
    public DomainType getOclSummableType() {
        return OCLstdlibTables.Types._OclSummable;
    }

    @NonNull
    public DomainType getOclTupleType() {
        return OCLstdlibTables.Types._OclTuple;
    }

    @NonNull
    public DomainType getOclVoidType() {
        return OCLstdlibTables.Types._OclVoid;
    }

    @NonNull
    public DomainType getOrderedSetType() {
        return OCLstdlibTables.Types._OrderedSet;
    }

    @NonNull
    public DomainCollectionType getOrderedSetType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType(this.getOrderedSetType(), elementType, lower, upper);
    }

    @NonNull
    public DomainType getRealType() {
        return OCLstdlibTables.Types._Real;
    }

    @NonNull
    public DomainType getSequenceType() {
        return OCLstdlibTables.Types._Sequence;
    }

    @NonNull
    public DomainCollectionType getSequenceType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType(this.getSequenceType(), elementType, lower, upper);
    }

    @NonNull
    public DomainType getSetType() {
        return OCLstdlibTables.Types._Set;
    }

    @NonNull
    public DomainCollectionType getSetType(@NonNull DomainType elementType, @Nullable IntegerValue lower, @Nullable IntegerValue upper) {
        return this.getCollectionType(this.getSetType(), elementType, lower, upper);
    }

    @NonNull
    public DomainType getStringType() {
        return OCLstdlibTables.Types._String;
    }

    @NonNull
    public DomainElement getTemplateParameter(@NonNull TemplateParameterId id, DomainElement context) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public synchronized DomainTupleType getTupleType(@NonNull TupleTypeId typeId) {
        DomainTupleType domainTupleType;
        WeakReference<DomainTupleType> ref = this.tupleTypeMap.get(typeId);
        if (ref != null && (domainTupleType = (DomainTupleType)ref.get()) != null) {
            return domainTupleType;
        }
        domainTupleType = new AbstractTupleType((DomainStandardLibrary)this, typeId);
        this.tupleTypeMap.put(typeId, new WeakReference<DomainTupleType>(domainTupleType));
        return domainTupleType;
    }

    @NonNull
    public DomainType getUniqueCollectionType() {
        return OCLstdlibTables.Types._UniqueCollection;
    }

    @NonNull
    public DomainType getUnlimitedNaturalType() {
        return OCLstdlibTables.Types._UnlimitedNatural;
    }
}

