/**
 * <copyright>
 * 
 * Copyright (c) 2010, 2012 E.D.Willink and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   C.Damus, K.Hussey, E.D.Willink - Initial API and implementation
 *   E.D.Willink - Bug 353171
 * 
 * </copyright>
 *
 * $Id: AbstractOCLDelegateFactory.java,v 1.5 2011/05/30 16:09:57 ewillink Exp $
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

/**
 * Partial implementation of a factory of OCL delegates for Ecore features.
 */
public abstract class AbstractOCLDelegateFactory
{
	protected final @NonNull String delegateURI;

	/**
	 * Construct a factory for an unknown delegate domain; often the global factory.
	 */
	protected AbstractOCLDelegateFactory(@NonNull String delegateURI) {
		this.delegateURI = delegateURI;
	}

	protected @Nullable OCLDelegateDomain getDelegateDomain(@NonNull EPackage ePackage) {
		DelegateEPackageAdapter ePackageAdapter = DelegateEPackageAdapter.getAdapter(ePackage);
		OCLDelegateDomain delegateDomain = (OCLDelegateDomain) ePackageAdapter.getDelegateDomain(delegateURI);
		return delegateDomain;
	}

	/**
	 * @nooverride This is not intended to be overridden by clients.
	 */
	public @NonNull String getURI() {
		return delegateURI;
	}

	/**
	 * Return the DelegateDomain for this package, creating one if it does not already exist. 
	 */
	protected OCLDelegateDomain loadDelegateDomain(@NonNull EPackage ePackage) {
		DelegateEPackageAdapter ePackageAdapter = DelegateEPackageAdapter.getAdapter(ePackage);
		return (OCLDelegateDomain) ePackageAdapter.loadDelegateDomain(delegateURI);
	}
}
