/**
 * <copyright>
 *
 * Copyright (c) 2012,2013 E.D.Willink and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   E.D.Willink - Initial API and implementation
 *
 * </copyright>
 */
package org.eclipse.ocl.examples.pivot.options;

import org.eclipse.ocl.common.delegate.VirtualDelegateMapping;
import org.eclipse.ocl.common.internal.preferences.StringPreference;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;

public class OCLinEcoreOptions
{
	/**
	 * The value of the OCL Delegate URI written to *.ecore files when no default was
	 * available when the file was read.
	 * <p>
	 * The default value of "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot" uses the
	 * Pivot-based evaluator when the embedded OCL is invoked, typically be model validation. 
	 * <p>
	 * The alternate value of "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG" uses the
	 * classic Ecore-based evaluator. 
	 * <p>
	 * The virtual value of "http://www.eclipse.org/emf/2002/Ecore/OCL" uses the
	 * {@link VirtualDelegateMapping} to control which evaluator to use.
	 */
    public static final StringPreference EXPORT_DELEGATION_URI = new StringPreference(
    	PivotConstants.PLUGIN_ID, "export.delegation.mode", OCLDelegateDomain.OCL_DELEGATE_URI_PIVOT); //$NON-NLS-1$

    /**
     * Not instantiable by clients.
     */
    private OCLinEcoreOptions() {
        super();
    }
}
