/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.attributes;

import com.google.common.collect.Lists;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.attributes.ClassAttribution;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;

public class VoidTypeAttribution
extends ClassAttribution {
    public static final VoidTypeAttribution INSTANCE = new VoidTypeAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        super.computeLookup(target, environmentView, scopeView);
        if (!environmentView.hasFinalResult()) {
            MetaModelManager metaModelManager = environmentView.getMetaModelManager();
            for (PackageServer packageServer : Lists.newArrayList(metaModelManager.getAllPackages())) {
                for (TypeServer typeServer : packageServer.getMemberTypes()) {
                    Type primaryType = typeServer.getPivotType();
                    environmentView.addAllOperations(primaryType, false);
                    environmentView.addAllProperties(primaryType, false);
                }
            }
        }
        return scopeView.getParent();
    }
}

