/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.options.OCLinEcoreOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateInstaller {
    @NonNull
    protected final MetaModelManager metaModelManager;
    protected final String exportDelegateURI;

    @Nullable
    public static String getAnnotationKey(@NonNull Constraint pivotConstraint) {
        String name = pivotConstraint.getName();
        EStructuralFeature eContainingFeature = pivotConstraint.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.TYPE__OWNED_INVARIANT) {
            if (pivotConstraint.isCallable()) {
                return "body";
            }
            return name;
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__PRECONDITION) {
            return name != null ? "pre_" + name : "pre";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__POSTCONDITION) {
            return name != null ? "post_" + name : "post";
        }
        return null;
    }

    @Nullable
    public static String getDelegateURI(@NonNull List<EObject> contents) {
        for (EObject eObject : contents) {
            String exportURI;
            if (!(eObject instanceof EPackage) || (exportURI = DelegateInstaller.getDelegateURI((EPackage)eObject)) == null) continue;
            return exportURI;
        }
        return null;
    }

    @Nullable
    public static String getDelegateURI(@NonNull EPackage ePackage) {
        HashSet allURIs = new HashSet();
        allURIs.addAll(EcoreUtil.getInvocationDelegates((EPackage)ePackage));
        allURIs.addAll(EcoreUtil.getSettingDelegates((EPackage)ePackage));
        allURIs.addAll(EcoreUtil.getValidationDelegates((EPackage)ePackage));
        String theURI = null;
        for (String uri : allURIs) {
            if (!uri.startsWith("http://www.eclipse.org/emf/2002/Ecore/OCL")) continue;
            if (theURI != null) {
                return "http://www.eclipse.org/emf/2002/Ecore/OCL";
            }
            theURI = uri;
        }
        if (theURI != null) {
            return theURI;
        }
        for (EPackage eSubpackage : ePackage.getESubpackages()) {
            String exportURI = DelegateInstaller.getDelegateURI(eSubpackage);
            if (exportURI == null) continue;
            return exportURI;
        }
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EAnnotation classifierAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
            if (classifierAnnotation != null && !classifierAnnotation.getDetails().isEmpty()) {
                return classifierAnnotation.getSource();
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                EAnnotation featureAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eFeature);
                if (featureAnnotation == null || featureAnnotation.getDetails().isEmpty()) continue;
                return featureAnnotation.getSource();
            }
            for (EOperation eOperation : eClass.getEOperations()) {
                EAnnotation operationAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
                if (operationAnnotation == null || operationAnnotation.getDetails().isEmpty()) continue;
                return operationAnnotation.getSource();
            }
        }
        return null;
    }

    public static boolean needsDelegates(@NonNull EPackage ePackage) {
        boolean needsDelegates = false;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EAnnotation classifierAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
            if (classifierAnnotation != null && !classifierAnnotation.getDetails().isEmpty()) {
                needsDelegates = true;
                break;
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                EAnnotation featureAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eFeature);
                if (featureAnnotation == null || featureAnnotation.getDetails().isEmpty()) continue;
                needsDelegates = true;
                break;
            }
            if (needsDelegates) break;
            for (EOperation eOperation : eClass.getEOperations()) {
                EAnnotation operationAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation);
                if (operationAnnotation == null || operationAnnotation.getDetails().isEmpty()) continue;
                needsDelegates = true;
                break;
            }
            if (needsDelegates) break;
        }
        return needsDelegates;
    }

    public DelegateInstaller(@NonNull MetaModelManager metaModelManager, @Nullable String exportDelegateURI) {
        this.metaModelManager = metaModelManager;
        this.exportDelegateURI = exportDelegateURI != null ? exportDelegateURI : (String)OCLinEcoreOptions.EXPORT_DELEGATION_URI.getPreferredValue();
    }

    @NonNull
    protected EAnnotation createAnnotation(@NonNull EModelElement eModelElement) {
        EAnnotation oclAnnotation = this.removeDelegateAnnotations(eModelElement, this.exportDelegateURI);
        if (oclAnnotation == null) {
            oclAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            oclAnnotation.setSource(this.exportDelegateURI);
            eModelElement.getEAnnotations().add((Object)oclAnnotation);
        }
        return oclAnnotation;
    }

    @Nullable
    public EAnnotation createConstraintDelegate(@NonNull EModelElement eModelElement, @NonNull Constraint pivotConstraint, @Nullable URI ecoreURI) {
        OpaqueExpression specification = pivotConstraint.getSpecification();
        if (specification == null) {
            return null;
        }
        String exprString = this.createExpression(specification, ecoreURI);
        if (exprString == null) {
            return null;
        }
        EAnnotation oclAnnotation = this.createAnnotation(eModelElement);
        String key = DelegateInstaller.getAnnotationKey(pivotConstraint);
        oclAnnotation.getDetails().put((Object)key, (Object)exprString);
        EStructuralFeature eContainingFeature = pivotConstraint.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.TYPE__OWNED_INVARIANT && !(eModelElement instanceof EOperation)) {
            OCLExpression messageExpression;
            String messageString = PivotUtil.getMessage(specification);
            if (messageString == null && specification instanceof ExpressionInOCL && (messageExpression = ((ExpressionInOCL)specification).getMessageExpression()) != null) {
                messageString = this.createExpression(messageExpression, ecoreURI);
            }
            if (messageString != null && messageString.length() > 0) {
                String name = pivotConstraint.getName();
                oclAnnotation.getDetails().put((Object)(String.valueOf(name) + "$message"), (Object)messageString);
            }
        }
        return oclAnnotation;
    }

    @Nullable
    protected String createExpression(@NonNull OpaqueExpression bodyExpression, @Nullable URI ecoreURI) {
        OCLExpression bodyExpression2;
        String exprString = PivotUtil.getBody(bodyExpression);
        if (exprString == null && bodyExpression instanceof ExpressionInOCL && (bodyExpression2 = ((ExpressionInOCL)bodyExpression).getBodyExpression()) != null) {
            exprString = this.createExpression(bodyExpression2, ecoreURI);
        }
        return exprString;
    }

    @Nullable
    protected String createExpression(@NonNull OCLExpression bodyExpression, @Nullable URI ecoreURI) {
        Namespace namespace = PivotUtil.getNamespace(bodyExpression);
        PrettyPrintOptions.Global options = PrettyPrinter.createOptions(namespace);
        options.setBaseURI(ecoreURI);
        return PrettyPrinter.print((Element)bodyExpression, options);
    }

    public void installDelegates(@NonNull PackageServer packageServer) {
        boolean hasDelegates = false;
        for (TypeServer typeServer : packageServer.getMemberTypes()) {
            if (!this.installDelegates(typeServer.getPivotType())) continue;
            hasDelegates = true;
        }
        EPackage ePackage = packageServer.getEPackage();
        if (ePackage != null && hasDelegates) {
            this.installDelegates(ePackage);
        }
        for (PackageServer packageServer2 : packageServer.getMemberPackages()) {
            if (packageServer2 == null) continue;
            this.installDelegates(packageServer2);
        }
    }

    private boolean installDelegates(@NonNull Type pivotType) {
        boolean hasDelegates = false;
        Type primaryType = this.metaModelManager.getPrimaryType(pivotType);
        EObject eTarget = primaryType.getETarget();
        if (eTarget instanceof EClassifier) {
            EStructuralFeature eFeature;
            EOperation eOperation;
            EClassifier eClassifier = (EClassifier)eTarget;
            this.removeDelegateAnnotations((EModelElement)eClassifier, null);
            for (Constraint constraint : this.metaModelManager.getLocalInvariants(pivotType)) {
                if (constraint.isCallable()) {
                    EAnnotation oclAnnotation;
                    EOperation eContext = null;
                    String name = constraint.getName();
                    for (EOperation candidate : ((EClass)eClassifier).getEOperations()) {
                        if (!name.equals(candidate.getName()) || !EcoreUtil.isInvariant((EOperation)candidate)) continue;
                        eContext = candidate;
                        break;
                    }
                    if (eContext == null) {
                        EOperation eOperation2 = Pivot2Ecore.createConstraintEOperation(constraint, name);
                        ((EClass)eClassifier).getEOperations().add((Object)eOperation2);
                        eContext = eOperation2;
                    }
                    if ((oclAnnotation = this.createConstraintDelegate((EModelElement)eContext, constraint, null)) == null) {
                        return false;
                    }
                    eContext.getEAnnotations().add((Object)oclAnnotation);
                    hasDelegates = true;
                    continue;
                }
                EAnnotation oclAnnotation = this.createConstraintDelegate((EModelElement)eClassifier, constraint, null);
                if (oclAnnotation == null) {
                    return false;
                }
                eClassifier.getEAnnotations().add((Object)oclAnnotation);
                hasDelegates = true;
            }
            for (Operation anOperation : this.metaModelManager.getMemberOperations(pivotType, false)) {
                eOperation = (EOperation)anOperation.getETarget();
                if (eOperation == null) continue;
                this.installDelegate(eOperation);
            }
            for (Operation anOperation : this.metaModelManager.getMemberOperations(pivotType, true)) {
                eOperation = (EOperation)anOperation.getETarget();
                if (eOperation == null) continue;
                this.installDelegate(eOperation);
            }
            for (Property aProperty : this.metaModelManager.getMemberProperties(pivotType, false)) {
                eFeature = (EStructuralFeature)aProperty.getETarget();
                if (eFeature == null) continue;
                this.installDelegate(eFeature);
            }
            for (Property aProperty : this.metaModelManager.getMemberProperties(pivotType, true)) {
                eFeature = (EStructuralFeature)aProperty.getETarget();
                if (eFeature == null) continue;
                this.installDelegate(eFeature);
            }
            for (EAnnotation eAnnotation : eClassifier.getEAnnotations()) {
                TreeIterator tit = eAnnotation.eAllContents();
                while (tit.hasNext()) {
                    EAnnotation nestedAnnotation;
                    EObject eObject = (EObject)tit.next();
                    if (!(eObject instanceof EAnnotation) || !"http://www.eclipse.org/uml2/1.1.0/GenModel".equals((nestedAnnotation = (EAnnotation)eObject).getSource())) continue;
                    nestedAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
                }
            }
            if (hasDelegates) {
                this.installDelegates(eClassifier, pivotType);
            }
        }
        return hasDelegates;
    }

    public boolean installDelegate(@NonNull EModelElement eModelElement, @NonNull Constraint pivotConstraint, @Nullable URI ecoreURI) {
        OpaqueExpression specification = pivotConstraint.getSpecification();
        if (specification == null) {
            return false;
        }
        String exprString = PivotUtil.getBody(specification);
        Namespace namespace = PivotUtil.getNamespace(specification);
        PrettyPrintOptions.Global options = PrettyPrinter.createOptions(namespace);
        options.setBaseURI(ecoreURI);
        if (exprString == null && specification instanceof ExpressionInOCL) {
            exprString = PrettyPrinter.print((Element)DomainUtil.nonNullModel((Object)((ExpressionInOCL)specification).getBodyExpression()), options);
        }
        if (exprString == null) {
            return false;
        }
        EAnnotation oclAnnotation = this.removeDelegateAnnotations(eModelElement, this.exportDelegateURI);
        if (oclAnnotation == null) {
            oclAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            oclAnnotation.setSource(this.exportDelegateURI);
            eModelElement.getEAnnotations().add((Object)oclAnnotation);
        }
        String name = pivotConstraint.getName();
        EStructuralFeature eContainingFeature = pivotConstraint.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.TYPE__OWNED_INVARIANT) {
            if (eModelElement instanceof EOperation) {
                oclAnnotation.getDetails().put((Object)"body", (Object)exprString);
            } else {
                OCLExpression messageExpression;
                oclAnnotation.getDetails().put((Object)name, (Object)exprString);
                String messageString = PivotUtil.getMessage(specification);
                if (messageString == null && specification instanceof ExpressionInOCL && (messageExpression = ((ExpressionInOCL)specification).getMessageExpression()) != null) {
                    messageString = PrettyPrinter.print((Element)messageExpression, options);
                }
                if (messageString != null && messageString.length() > 0) {
                    oclAnnotation.getDetails().put((Object)(String.valueOf(name) + "$message"), (Object)messageString);
                }
            }
        } else if (eContainingFeature == PivotPackage.Literals.PROPERTY__DEFAULT_EXPRESSION) {
            oclAnnotation.getDetails().put((Object)"derivation", (Object)exprString);
        } else if (eContainingFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
            String key = name != null ? "body_" + name : "body";
            oclAnnotation.getDetails().put((Object)key, (Object)exprString);
        } else if (eContainingFeature == PivotPackage.Literals.OPERATION__PRECONDITION) {
            oclAnnotation.getDetails().put((Object)("pre_" + name), (Object)exprString);
        } else if (eContainingFeature == PivotPackage.Literals.OPERATION__POSTCONDITION) {
            oclAnnotation.getDetails().put((Object)("post_" + name), (Object)exprString);
        }
        return true;
    }

    public void installDelegate(@NonNull EOperation eOperation) {
        EList eAnnotations = eOperation.getEAnnotations();
        EAnnotation oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
            oclAnnotation.setSource(this.exportDelegateURI);
            eAnnotations.add(oclAnnotation);
        }
    }

    public void installDelegate(@NonNull EStructuralFeature eFeature) {
        EList eAnnotations = eFeature.getEAnnotations();
        EAnnotation oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
            oclAnnotation.setSource(this.exportDelegateURI);
            eAnnotations.add(oclAnnotation);
        }
    }

    public void installDelegates(@NonNull EClassifier eClassifier, @NonNull Type pivotType) {
        StringBuilder s = null;
        for (Constraint pivotConstraint : this.metaModelManager.getLocalInvariants(pivotType)) {
            String constraintName = pivotConstraint.getName();
            if (pivotConstraint.isCallable() || constraintName == null) continue;
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(" ");
            }
            s.append(constraintName);
        }
        EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (s != null) {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                eClassifier.getEAnnotations().add(0, (Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)"constraints", (Object)s.toString());
        } else {
            eClassifier.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public void installDelegates(@NonNull EPackage ePackage) {
        EAnnotation packageAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (packageAnnotation == null) {
            packageAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            packageAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
            ePackage.getEAnnotations().add((Object)packageAnnotation);
        }
        EMap details = packageAnnotation.getDetails();
        details.put((Object)"invocationDelegates", (Object)this.exportDelegateURI);
        details.put((Object)"settingDelegates", (Object)this.exportDelegateURI);
        details.put((Object)"validationDelegates", (Object)this.exportDelegateURI);
    }

    public boolean installOperationDelegate(@NonNull EOperation eOperation, @NonNull OpaqueExpression bodyExpression, @Nullable URI ecoreURI) {
        String exprString = this.createExpression(bodyExpression, ecoreURI);
        if (exprString == null) {
            return false;
        }
        EAnnotation oclAnnotation = this.createAnnotation((EModelElement)eOperation);
        oclAnnotation.getDetails().put((Object)"body", (Object)exprString);
        return true;
    }

    public boolean installPropertyDelegate(@NonNull EStructuralFeature eStructuralFeature, @NonNull OpaqueExpression defaultExpression, @Nullable URI ecoreURI) {
        String exprString = this.createExpression(defaultExpression, ecoreURI);
        if (exprString == null) {
            return false;
        }
        EAnnotation oclAnnotation = this.createAnnotation((EModelElement)eStructuralFeature);
        oclAnnotation.getDetails().put((Object)"derivation", (Object)exprString);
        return true;
    }

    @Nullable
    public String getExportDelegateURI() {
        return this.exportDelegateURI;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    protected EAnnotation removeDelegateAnnotations(@NonNull EModelElement eModelElement, @Nullable String exportDelegateURI) {
        EAnnotation annotation4;
        EAnnotation annotation3;
        EAnnotation annotation2;
        EList eAnnotations = eModelElement.getEAnnotations();
        EAnnotation oclAnnotation = null;
        EAnnotation annotation1 = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (annotation1 != null) {
            if ("http://www.eclipse.org/emf/2002/Ecore/OCL".equals(exportDelegateURI)) {
                oclAnnotation = annotation1;
            } else {
                eAnnotations.remove(annotation1);
            }
        }
        if ((annotation2 = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
            if ("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG".equals(exportDelegateURI)) {
                oclAnnotation = annotation2;
            } else {
                eAnnotations.remove(annotation2);
            }
        }
        if ((annotation3 = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot")) != null) {
            if ("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot".equals(exportDelegateURI)) {
                oclAnnotation = annotation3;
            } else {
                eAnnotations.remove(annotation3);
            }
        }
        if ((annotation4 = eModelElement.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
            eAnnotations.remove(annotation4);
        }
        return oclAnnotation;
    }
}

