/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.delegate.DelegateInstaller;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreTypeRefVisitor;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreReferenceVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    private static final Logger logger = Logger.getLogger(Pivot2EcoreReferenceVisitor.class);
    @NonNull
    protected final Pivot2EcoreTypeRefVisitor typeRefVisitor;

    public Pivot2EcoreReferenceVisitor(@NonNull Pivot2Ecore context) {
        super(context);
        this.typeRefVisitor = new Pivot2EcoreTypeRefVisitor(context);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    public <T extends EClassifier> void safeVisitAll(List<EGenericType> eGenericTypes, List<T> eTypes, List<? extends Type> superClasses) {
        if (superClasses.size() > 0) {
            ArrayList superEClasses = new ArrayList(superClasses.size());
            this.typeRefVisitor.safeVisitAll(superEClasses, superClasses);
            eTypes.clear();
            eGenericTypes.clear();
            for (EObject superEClass : superEClasses) {
                if (superEClass instanceof EGenericType) {
                    eGenericTypes.add((EGenericType)superEClass);
                    continue;
                }
                EClassifier castSuperEClass = (EClassifier)superEClass;
                eTypes.add(castSuperEClass);
            }
        } else {
            eGenericTypes.clear();
        }
    }

    @Override
    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore Reference pass");
    }

    @Override
    public EObject visitAnnotation(@NonNull Annotation pivotAnnotation) {
        EAnnotation eAnnotation = ((Pivot2Ecore)this.context).getCreated(EAnnotation.class, pivotAnnotation);
        eAnnotation.getReferences().clear();
        for (Element pivotReference : pivotAnnotation.getReference()) {
            if (pivotReference == null) continue;
            EObject target = ((Pivot2Ecore)this.context).getCreated(EObject.class, pivotReference);
            if (target == null && pivotReference instanceof PivotObjectImpl) {
                target = ((PivotObjectImpl)((Object)pivotReference)).getTarget();
            }
            if (target == null) continue;
            eAnnotation.getReferences().add((Object)target);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotClass) {
        EClass eClass = ((Pivot2Ecore)this.context).getCreated(EClass.class, pivotClass);
        this.safeVisitAll((List<EGenericType>)eClass.getEGenericSuperTypes(), (List)eClass.getESuperTypes(), (List<? extends Type>)pivotClass.getSuperClass());
        return eClass;
    }

    @Override
    public EObject visitDataType(@NonNull DataType pivotDataType) {
        EDataType eDataType = ((Pivot2Ecore)this.context).getCreated(EDataType.class, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitOperation(@NonNull Operation pivotOperation) {
        EOperation eOperation = ((Pivot2Ecore)this.context).getCreated(EOperation.class, pivotOperation);
        this.safeVisitAll((List<EGenericType>)eOperation.getEGenericExceptions(), (List)eOperation.getEExceptions(), (List<? extends Type>)pivotOperation.getRaisedException());
        return (EObject)super.visitOperation(pivotOperation);
    }

    @Override
    public EObject visitPackage(@NonNull Package pivotPackage) {
        EPackage ePackage = ((Pivot2Ecore)this.context).getCreated(EPackage.class, pivotPackage);
        if (ePackage == null) {
            return null;
        }
        boolean needsDelegates = DelegateInstaller.needsDelegates(ePackage);
        if (needsDelegates) {
            ((Pivot2Ecore)this.context).getDelegateInstaller().installDelegates(ePackage);
        }
        return null;
    }

    @Override
    public EObject visitProperty(@NonNull Property pivotProperty) {
        if (pivotProperty.isImplicit()) {
            return null;
        }
        EStructuralFeature eStructuralFeature = ((Pivot2Ecore)this.context).getCreated(EStructuralFeature.class, pivotProperty);
        if (eStructuralFeature instanceof EReference) {
            EReference eOpposite;
            EReference eReference = (EReference)eStructuralFeature;
            Property pivotOpposite = pivotProperty.getOpposite();
            if (pivotOpposite != null && !pivotOpposite.isImplicit() && (eOpposite = ((Pivot2Ecore)this.context).getCreated(EReference.class, pivotOpposite)) != null) {
                eReference.setEOpposite(eOpposite);
            }
            for (Property pivotKey : pivotProperty.getKeys()) {
                EAttribute eAttribute;
                if (pivotKey == null || (eAttribute = ((Pivot2Ecore)this.context).getCreated(EAttribute.class, pivotKey)) == null) continue;
                eReference.getEKeys().add((Object)eAttribute);
            }
        }
        return (EObject)super.visitProperty(pivotProperty);
    }

    @Override
    public EObject visitTypeTemplateParameter(@NonNull TypeTemplateParameter pivotTypeTemplateParameter) {
        ETypeParameter eTypeParameter = ((Pivot2Ecore)this.context).getCreated(ETypeParameter.class, pivotTypeTemplateParameter);
        for (Type constrainingType : pivotTypeTemplateParameter.getConstrainingType()) {
            EGenericType eGenericType = this.typeRefVisitor.resolveEGenericType(constrainingType);
            eTypeParameter.getEBounds().add((Object)eGenericType);
        }
        return null;
    }

    @Override
    public EObject visitTypedElement(@NonNull TypedElement pivotTypedElement) {
        ETypedElement eTypedElement = ((Pivot2Ecore)this.context).getCreated(ETypedElement.class, pivotTypedElement);
        Type pivotType = pivotTypedElement.getType();
        if (pivotType == null) {
            return null;
        }
        EObject eObject = this.typeRefVisitor.safeVisit(pivotType);
        if (eObject instanceof EGenericType) {
            eTypedElement.setEGenericType((EGenericType)eObject);
        } else if (eObject instanceof EClassifier) {
            eTypedElement.setEType((EClassifier)eObject);
        } else if (eObject instanceof ETypeParameter) {
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setETypeParameter((ETypeParameter)eObject);
            eTypedElement.setEGenericType(eGenericType);
        } else {
            EObject eObject2 = this.typeRefVisitor.safeVisit(pivotType);
        }
        return null;
    }

    @Override
    public EObject visitTypedMultiplicityElement(@NonNull TypedMultiplicityElement pivotTypedElement) {
        ETypedElement eTypedElement = ((Pivot2Ecore)this.context).getCreated(ETypedElement.class, pivotTypedElement);
        Type pivotType = pivotTypedElement.getType();
        if (pivotType == null || pivotType instanceof VoidType) {
            eTypedElement.setLowerBound(0);
            eTypedElement.setUpperBound(1);
            eTypedElement.setOrdered(true);
            eTypedElement.setUnique(true);
            return null;
        }
        if (pivotType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)pivotType;
            Type elementType = collectionType.getElementType();
            EObject eObject = this.typeRefVisitor.safeVisit(elementType);
            if (eObject instanceof EGenericType) {
                eTypedElement.setEGenericType((EGenericType)eObject);
            } else {
                eTypedElement.setEType((EClassifier)eObject);
            }
            eTypedElement.setOrdered(collectionType.isOrdered());
            eTypedElement.setUnique(collectionType.isUnique());
            IntegerValue lower = collectionType.getLowerValue();
            IntegerValue upper = collectionType.getUpperValue();
            try {
                eTypedElement.setLowerBound(lower.intValue());
            }
            catch (InvalidValueException e) {
                logger.error((Object)"Illegal lower bound", (Throwable)e);
            }
            try {
                eTypedElement.setUpperBound(upper.isUnlimited() ? -1 : upper.intValue());
            }
            catch (InvalidValueException e) {
                logger.error((Object)"Illegal upper bound", (Throwable)e);
            }
            return null;
        }
        if (pivotTypedElement.isRequired()) {
            eTypedElement.setLowerBound(1);
            eTypedElement.setUpperBound(1);
        } else {
            eTypedElement.setLowerBound(0);
            eTypedElement.setUpperBound(1);
        }
        eTypedElement.setUnique(true);
        eTypedElement.setOrdered(true);
        return this.visitTypedElement(pivotTypedElement);
    }
}

