/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainLogger;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationVisitor
extends AbstractExtendingVisitor<Object, Object>
implements EvaluationVisitor {
    @NonNull
    protected final EvaluationEnvironment evaluationEnvironment;
    @NonNull
    protected final Environment environment;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final DomainModelManager modelManager;
    @NonNull
    private EvaluationVisitor undecoratedVisitor;
    private DomainLogger logger = new DomainLogger(){

        public void append(@NonNull String message) {
            System.out.append(message);
        }
    };
    private boolean isCanceled = false;

    protected AbstractEvaluationVisitor(@NonNull Environment env, @NonNull EvaluationEnvironment evalEnv, @NonNull DomainModelManager modelManager) {
        super(Object.class);
        this.evaluationEnvironment = evalEnv;
        this.environment = env;
        this.metaModelManager = env.getMetaModelManager();
        this.modelManager = modelManager;
        this.undecoratedVisitor = this;
    }

    @Override
    @NonNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluationEnvironment;
    }

    @NonNull
    public IdResolver getIdResolver() {
        return this.metaModelManager.getIdResolver();
    }

    @Nullable
    public DomainLogger getLogger() {
        return this.logger;
    }

    @Override
    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @Override
    @NonNull
    public DomainModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return this.metaModelManager;
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        return this.metaModelManager.getIdResolver().getStaticTypeOf(value);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.metaModelManager.getIdResolver().getStaticTypeOf(value, values);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.metaModelManager.getIdResolver().getStaticTypeOf(value, values);
    }

    @NonNull
    protected final EvaluationVisitor getUndecoratedVisitor() {
        return this.undecoratedVisitor;
    }

    @Deprecated
    protected final EvaluationVisitor getVisitor() {
        return this.undecoratedVisitor;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public void setLogger(@Nullable DomainLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setUndecoratedVisitor(@NonNull EvaluationVisitor evaluationVisitor) {
        this.undecoratedVisitor = evaluationVisitor;
    }

    @Deprecated
    void setVisitor(@NonNull EvaluationVisitor visitor) {
        this.setUndecoratedVisitor(visitor);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.getEvaluationEnvironment());
        result.append(')');
        return result.toString();
    }

    @Override
    public Object visitConstraint(@NonNull Constraint constraint) {
        OpaqueExpression specification = constraint.getSpecification();
        if (!(specification instanceof ExpressionInOCL)) {
            return null;
        }
        OCLExpression body = ((ExpressionInOCL)specification).getBodyExpression();
        if (body == null) {
            throw new IllegalArgumentException("constraint has no body expression");
        }
        Object result = body.accept(this.getUndecoratedVisitor());
        return ValuesUtil.asBoolean((Object)result);
    }
}

