/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.helper;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.AbstractParserContext;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.ModelContext;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.context.PropertyContext;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;

public class OCLHelperImpl
implements OCLHelper {
    @NonNull
    private final OCL ocl;
    @NonNull
    protected final Environment rootEnvironment;
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    protected final EnvironmentFactory environmentFactory;
    private Environment env;
    private boolean validating = true;
    private Diagnostic problems;

    public OCLHelperImpl(@NonNull OCL ocl) {
        this.ocl = ocl;
        this.rootEnvironment = ocl.getEnvironment();
        this.metaModelManager = this.rootEnvironment.getMetaModelManager();
        this.environmentFactory = this.rootEnvironment.getFactory();
    }

    @NonNull
    public ExpressionInOCL createBodyCondition(@NonNull String expression) throws ParserException {
        Operation contextOperation = this.getEnvironment().getContextOperation();
        if (contextOperation == null) {
            throw new IllegalStateException("Undefined contextOperation");
        }
        OperationContext parserContext = new OperationContext(this.metaModelManager, null, contextOperation, null);
        return parserContext.parse(expression);
    }

    @NonNull
    public ExpressionInOCL createDerivedValueExpression(@NonNull String expression) throws ParserException {
        Property contextProperty = this.getEnvironment().getContextProperty();
        if (contextProperty == null) {
            throw new IllegalStateException("Undefined contextProperty");
        }
        PropertyContext parserContext = new PropertyContext(this.metaModelManager, null, contextProperty);
        return parserContext.parse(expression);
    }

    @NonNull
    public ExpressionInOCL createInvariant(@NonNull String expression) throws ParserException {
        Type contextClassifier = this.getEnvironment().getContextClassifier();
        if (contextClassifier == null) {
            throw new IllegalStateException("Undefined contextClassifier");
        }
        ClassContext parserContext = new ClassContext(this.metaModelManager, null, contextClassifier);
        return parserContext.parse(expression);
    }

    @NonNull
    public ExpressionInOCL createPostcondition(@NonNull String expression) throws ParserException {
        Operation contextOperation = this.getEnvironment().getContextOperation();
        if (contextOperation == null) {
            throw new IllegalStateException("Undefined contextOperation");
        }
        OperationContext parserContext = new OperationContext(this.metaModelManager, null, contextOperation, "result");
        return parserContext.parse(expression);
    }

    @NonNull
    public ExpressionInOCL createPrecondition(@NonNull String expression) throws ParserException {
        Operation contextOperation = this.getEnvironment().getContextOperation();
        if (contextOperation == null) {
            throw new IllegalStateException("Undefined contextOperation");
        }
        OperationContext parserContext = new OperationContext(this.metaModelManager, null, contextOperation, null);
        return parserContext.parse(expression);
    }

    @NonNull
    public ExpressionInOCL createQuery(@NonNull String expression) throws ParserException {
        Type contextClassifier = this.getEnvironment().getContextClassifier();
        AbstractParserContext parserContext = contextClassifier != null ? new ClassContext(this.metaModelManager, null, contextClassifier) : new ModelContext(this.metaModelManager, null);
        return parserContext.parse(expression);
    }

    @NonNull
    protected ExpressionInOCL createSpecification(@NonNull String expression) throws ParserException {
        Type contextClassifier = this.getEnvironment().getContextClassifier();
        if (contextClassifier == null) {
            throw new IllegalStateException("Undefined contextClassifier");
        }
        ClassContext parserContext = new ClassContext(this.metaModelManager, null, contextClassifier);
        return parserContext.parse(expression);
    }

    @Nullable
    public Property getContextProperty() {
        return this.getEnvironment().getContextProperty();
    }

    @Nullable
    public Type getContextClassifier() {
        return this.getEnvironment().getContextClassifier();
    }

    @Nullable
    public Operation getContextOperation() {
        return this.getEnvironment().getContextOperation();
    }

    @NonNull
    public Environment getEnvironment() {
        return this.env == null ? this.rootEnvironment : this.env;
    }

    @NonNull
    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    @NonNull
    public OCL getOCL() {
        return this.ocl;
    }

    public Diagnostic getProblems() {
        return this.problems;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setContext(@NonNull EClassifier context) {
        Type pContext = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)context);
        if (pContext != null) {
            this.setContext(pContext);
        }
    }

    public void setContext(@NonNull Type context) {
        this.setEnvironment(this.environmentFactory.createClassifierContext(this.getEnvironment(), context));
    }

    private void setEnvironment(@NonNull Environment env) {
        this.env = env;
    }

    public void setInstancePropertyContext(@NonNull Object instance, @NonNull Property property) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createPropertyContext(this.getEnvironment(), property));
    }

    public void setInstanceContext(@NonNull Object instance) {
        this.setEnvironment(this.environmentFactory.createInstanceContext(this.getEnvironment(), instance));
    }

    public void setInstanceOperationContext(@NonNull Object instance, @NonNull Operation operation) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.getEnvironment(), operation));
    }

    public void setOperationContext(@NonNull EClassifier context, @NonNull EOperation operation) {
        Type pContext = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)context);
        Operation pOperation = this.metaModelManager.getPivotOfEcore(Operation.class, (EObject)operation);
        if (pContext != null && pOperation != null) {
            this.setOperationContext(pContext, pOperation);
        }
    }

    public void setOperationContext(@NonNull Type context, @NonNull Operation operation) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.getEnvironment(), operation));
    }

    public void setPropertyContext(@NonNull EClassifier context, @NonNull EStructuralFeature property) {
        Type pContext = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)context);
        Property pProperty = this.metaModelManager.getPivotOfEcore(Property.class, (EObject)property);
        if (pContext != null && pProperty != null) {
            this.setPropertyContext(pContext, pProperty);
        }
    }

    public void setPropertyContext(@NonNull Type context, @NonNull Property property) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createPropertyContext(this.getEnvironment(), property));
    }

    void setProblems(Diagnostic problems) {
        this.problems = problems;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }
}

